/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.builtin.SelectorAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.CasterProperties;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.ProgressionPath;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.inventory.ItemStack;

public class ShopAction
extends SelectorAction {
    private boolean showNoPermission;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        boolean showPath = parameters.getBoolean("show_path_spells", false);
        boolean showExtra = parameters.getBoolean("show_extra_spells", false);
        boolean showRequired = parameters.getBoolean("show_required_spells", false);
        boolean showFree = parameters.getBoolean("show_free", false);
        boolean addSellShop = parameters.getBoolean("add_sell_shop", false);
        this.showNoPermission = parameters.getBoolean("show_no_permission", false);
        Object itemDefaults = parameters.get("items");
        parameters.set("items", null);
        boolean isSellShop = parameters.getBoolean("sell");
        if (isSellShop) {
            parameters.set("earn_scale", parameters.get("scale"));
            parameters.set("scale", null);
            if (!parameters.contains("selected")) {
                parameters.set("selected", (Object)context.getController().getMessages().get("shops.sold"));
            }
        }
        if (!parameters.contains("cost_type") && (showPath || showExtra || showRequired || parameters.contains("spells"))) {
            parameters.set("cost_type", (Object)"sp");
        }
        if (!parameters.contains("apply_lore_to_item")) {
            parameters.set("apply_lore_to_item", (Object)true);
        }
        if (!parameters.contains("apply_name_to_item")) {
            parameters.set("apply_name_to_item", (Object)true);
        }
        super.prepare(context, parameters);
        parameters.set("items", itemDefaults);
        this.loadItems(context, parameters, "items", false);
        this.loadItems(context, parameters, "spells", true);
        Mage mage = context.getMage();
        CasterProperties caster = mage.getActiveProperties();
        ProgressionPath currentPath = caster.getPath();
        if (currentPath != null) {
            ArrayList<String> spellKeys = new ArrayList<String>();
            if (showPath) {
                spellKeys.addAll(currentPath.getSpells());
            }
            if (showRequired) {
                spellKeys.addAll(currentPath.getRequiredSpells());
            }
            this.loadSpells(context, spellKeys, showFree, false);
            if (showExtra) {
                this.loadSpells(context, currentPath.getExtraSpells(), showFree, true);
            }
        }
        if (addSellShop) {
            int startNextLine = (int)Math.floor(this.getNumSlots() / 9) * 9;
            int buttonSlot = startNextLine + 8;
            MemoryConfiguration sellShopConfig = new MemoryConfiguration();
            sellShopConfig.set("slot", (Object)buttonSlot);
            sellShopConfig.set("auto_close", (Object)true);
            sellShopConfig.set("selected", (Object)"");
            sellShopConfig.set("cast_spell", (Object)context.getSpell().getSpellKey().getKey());
            if (!isSellShop) {
                ConfigurationSection spellParameters = sellShopConfig.createSection("cast_spell_parameters");
                spellParameters.set("sell", (Object)true);
                spellParameters.set("title", (Object)this.getMessage("sell_title"));
                sellShopConfig.set("name", (Object)this.getMessage("sell_icon_name"));
                sellShopConfig.set("icon", (Object)parameters.getString("sell_icon", "yellow_wool"));
            } else {
                sellShopConfig.set("name", (Object)this.getMessage("buy_icon_name"));
                sellShopConfig.set("icon", (Object)parameters.getString("buy_icon", "green_wool"));
            }
            ArrayList<ConfigurationSection> buttonConfigs = new ArrayList<ConfigurationSection>();
            buttonConfigs.add((ConfigurationSection)sellShopConfig);
            this.loadOptions(buttonConfigs);
        }
    }

    protected void loadSpells(CastContext context, Collection<String> spellKeys, boolean showFree, boolean isExtra) {
        Mage mage = context.getMage();
        CasterProperties caster = mage.getActiveProperties();
        MageController controller = context.getController();
        ArrayList<SpellTemplate> spells = new ArrayList<SpellTemplate>();
        for (String spellKey : spellKeys) {
            SpellTemplate spell = controller.getSpellTemplate(spellKey);
            if (spell == null) {
                mage.sendDebugMessage(ChatColor.GRAY + " Skipping " + spellKey + ", is invalid", 3);
                continue;
            }
            if (caster.hasSpell(spellKey) && (spell.getWorth() > 0.0 || showFree)) {
                mage.sendDebugMessage(ChatColor.GRAY + " Skipping " + spellKey + ", already have it", 3);
                continue;
            }
            if (spell.getWorth() <= 0.0 && !showFree) {
                mage.sendDebugMessage(ChatColor.GRAY + " Skipping " + spellKey + ", is free", 3);
                continue;
            }
            if (!this.showNoPermission && !spell.hasCastPermission(mage.getCommandSender())) {
                mage.sendDebugMessage(ChatColor.YELLOW + " Skipping " + spellKey + ", no permission", 3);
                continue;
            }
            spells.add(spell);
        }
        if (spells.size() == 0) {
            return;
        }
        mage.sendDebugMessage(ChatColor.GOLD + "Spells to buy: " + spells.size(), 2);
        Collections.sort(spells, new Comparator<SpellTemplate>(){

            @Override
            public int compare(SpellTemplate spell1, SpellTemplate spell2) {
                return Double.compare(spell1.getWorth(), spell2.getWorth());
            }
        });
        ArrayList<ConfigurationSection> pathSpellConfigs = new ArrayList<ConfigurationSection>();
        if (isExtra) {
            int maxSlot = this.getNumSlots();
            int paddedSlot = 8 - (maxSlot + 8) % 9;
            for (int i = 0; i < paddedSlot; ++i) {
                MemoryConfiguration emptyConfig = new MemoryConfiguration();
                emptyConfig.set("item", (Object)"none");
                pathSpellConfigs.add((ConfigurationSection)emptyConfig);
            }
        }
        String addLore = isExtra ? this.getMessage("extra_spell") : null;
        for (SpellTemplate spell : spells) {
            MemoryConfiguration spellConfig = new MemoryConfiguration();
            spellConfig.set("item", (Object)("spell:" + spell.getKey()));
            if (addLore != null) {
                spellConfig.set("description", (Object)addLore);
            }
            pathSpellConfigs.add((ConfigurationSection)spellConfig);
        }
        this.loadOptions(pathSpellConfigs);
    }

    protected void loadItems(CastContext context, ConfigurationSection parameters, String key, boolean filterSpells) {
        if (parameters.contains(key)) {
            ArrayList<ConfigurationSection> itemConfigs = new ArrayList<ConfigurationSection>();
            if (parameters.isConfigurationSection(key)) {
                ConfigurationSection itemSection = parameters.getConfigurationSection(key);
                Set itemKeys = itemSection.getKeys(false);
                Iterator iterator = itemKeys.iterator();
                while (iterator.hasNext()) {
                    String itemKey = (String)iterator.next();
                    MemoryConfiguration itemConfig = new MemoryConfiguration();
                    itemConfig.set("item", (Object)itemKey);
                    itemConfig.set("cost", itemSection.get(itemKey));
                    itemConfigs.add((ConfigurationSection)itemConfig);
                }
            } else {
                List objects = parameters.getList(key);
                for (Object object : objects) {
                    if (object instanceof ConfigurationSection) {
                        itemConfigs.add((ConfigurationSection)object);
                        continue;
                    }
                    if (object instanceof Map) {
                        itemConfigs.add(ConfigurationUtils.toConfigurationSection((Map)object));
                        continue;
                    }
                    if (object instanceof String) {
                        MemoryConfiguration itemConfig = new MemoryConfiguration();
                        if (object.equals("none")) {
                            itemConfig.set("placeholder", (Object)true);
                        } else {
                            itemConfig.set("item", object);
                        }
                        itemConfigs.add((ConfigurationSection)itemConfig);
                        continue;
                    }
                    context.getLogger().warning("Invalid item in shop config: " + object);
                }
            }
            if (filterSpells) {
                CasterProperties caster = context.getMage().getActiveProperties();
                Iterator it = itemConfigs.iterator();
                while (it.hasNext()) {
                    ConfigurationSection config = (ConfigurationSection)it.next();
                    String spellName = config.getString("item");
                    if (spellName != null && caster.hasSpell(spellName)) {
                        it.remove();
                        continue;
                    }
                    config.set("item", (Object)("spell:" + spellName));
                }
            }
            if (parameters.getBoolean("sell", false)) {
                for (ConfigurationSection itemConfig : itemConfigs) {
                    String itemName = itemConfig.getString("item");
                    if (itemName == null || itemName.equalsIgnoreCase("none")) continue;
                    itemConfig.set("item", null);
                    itemConfig.set("icon", (Object)itemName);
                    ItemStack item = this.parseItem(itemName);
                    if (item == null) continue;
                    Object costs = itemConfig.get("cost");
                    if (costs != null) {
                        itemConfig.set("earn", costs);
                        itemConfig.set("cost", null);
                    } else {
                        Double worth = context.getController().getEarns(item);
                        if (worth != null && worth > 0.0) {
                            itemConfig.set("earn", (Object)worth);
                        }
                    }
                    ConfigurationSection costSection = itemConfig.createSection("costs");
                    Integer sp = Wand.getSP(item);
                    if (sp != null) {
                        costSection.set("sp", (Object)sp);
                        continue;
                    }
                    costSection.set(itemName, (Object)item.getAmount());
                }
            }
            this.loadOptions(itemConfigs);
        }
    }
}

