/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.action.GUIAction;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffectType;

public class PlayerSelectAction
extends CompoundAction
implements GUIAction {
    private Map<Integer, WeakReference<Player>> players;
    private boolean allowCrossWorld;
    private boolean active = false;
    private WeakReference<Player> target = null;
    private String ignorePlayersKey;
    private String titleKey;

    @Override
    public void deactivated() {
        this.active = false;
    }

    @Override
    public void dragged(InventoryDragEvent event) {
        event.setCancelled(true);
    }

    @Override
    public void clicked(InventoryClickEvent event) {
        int slot = event.getRawSlot();
        event.setCancelled(true);
        if (event.getSlotType() == InventoryType.SlotType.CONTAINER) {
            Player player;
            this.target = this.players.get(slot);
            Player player2 = player = this.target != null ? (Player)this.target.get() : null;
            if (player != null) {
                Mage mage = this.actionContext.getMage();
                mage.deactivateGUI();
                this.actionContext.setTargetEntity((Entity)player);
                this.actionContext.setTargetLocation(player.getLocation());
                this.actionContext.playEffects("player_selected");
            }
            this.players.clear();
            this.active = false;
        }
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.players = new HashMap<Integer, WeakReference<Player>>();
        this.active = false;
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.allowCrossWorld = parameters.getBoolean("cross_world", true);
        this.ignorePlayersKey = parameters.getString("ignore_key");
        this.titleKey = parameters.getString("title_key", "title");
    }

    @Override
    public SpellResult step(CastContext context) {
        Player targetEntity;
        if (this.active) {
            return SpellResult.PENDING;
        }
        Player player = targetEntity = this.target == null ? null : (Player)this.target.get();
        if (targetEntity == null) {
            return SpellResult.NO_TARGET;
        }
        return this.startActions();
    }

    @Override
    public SpellResult start(CastContext context) {
        ConfigurationSection mageData;
        Object friendString;
        Mage mage = context.getMage();
        MageController controller = context.getController();
        Player player = mage.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        ArrayList allPlayers = null;
        this.players.clear();
        allPlayers = this.allowCrossWorld ? new ArrayList(controller.getPlugin().getServer().getOnlinePlayers()) : context.getLocation().getWorld().getPlayers();
        Collections.sort(allPlayers, new Comparator<Player>(){

            @Override
            public int compare(Player p1, Player p2) {
                return p1.getDisplayName().compareTo(p2.getDisplayName());
            }
        });
        HashSet<String> ignorePlayers = null;
        if (this.ignorePlayersKey != null && !this.ignorePlayersKey.isEmpty() && (friendString = (mageData = mage.getData()).getString(this.ignorePlayersKey)) != null && !((String)friendString).isEmpty()) {
            ignorePlayers = new HashSet<String>(Arrays.asList(StringUtils.split((String)friendString, (char)',')));
        }
        int index = 0;
        for (Player targetPlayer : allPlayers) {
            if (targetPlayer.hasPotionEffect(PotionEffectType.INVISIBILITY) || !context.canTarget((Entity)targetPlayer) || ignorePlayers != null && ignorePlayers.contains(targetPlayer.getUniqueId().toString())) continue;
            this.players.put(index++, new WeakReference<Player>(targetPlayer));
        }
        if (this.players.size() == 0) {
            return SpellResult.NO_TARGET;
        }
        String inventoryTitle = context.getMessage("title", "Select Player");
        int invSize = (this.players.size() + 9) / 9 * 9;
        Inventory displayInventory = CompatibilityUtils.createInventory(null, invSize, inventoryTitle);
        for (Map.Entry<Integer, WeakReference<Player>> entry : this.players.entrySet()) {
            Player targetPlayer = (Player)entry.getValue().get();
            if (targetPlayer == null) continue;
            String name = targetPlayer.getName();
            String displayName = targetPlayer.getDisplayName();
            ItemStack playerItem = controller.getSkull(targetPlayer, displayName);
            ItemMeta meta = playerItem.getItemMeta();
            if (!name.equals(displayName)) {
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(name);
                meta.setLore(lore);
            }
            playerItem.setItemMeta(meta);
            displayInventory.setItem(entry.getKey().intValue(), playerItem);
        }
        this.active = true;
        mage.activateGUI(this, displayInventory);
        return SpellResult.NO_ACTION;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        parameters.add("cross_world");
        super.getParameterNames(spell, parameters);
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("cross_world")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

