/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.listener;

import com.elmakers.mine.bukkit.api.event.MagicMobDeathEvent;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.entity.EntityData;
import com.elmakers.mine.bukkit.tasks.ModifyEntityTask;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.SlimeSplitEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class MobController
implements Listener {
    private MageController controller;
    private final Map<String, EntityData> mobs = new HashMap<String, EntityData>();
    private final Map<String, EntityData> mobsByName = new HashMap<String, EntityData>();
    private final Map<EntityType, EntityData> defaultMobs = new HashMap<EntityType, EntityData>();
    private final Map<Entity, EntityData> activeMobs = new WeakHashMap<Entity, EntityData>();

    public MobController(MageController controller) {
        this.controller = controller;
    }

    public void clear() {
        this.mobs.clear();
        this.mobsByName.clear();
    }

    public void load(String mobKey, ConfigurationSection mobConfiguration) {
        if (!ConfigurationUtils.isEnabled(mobConfiguration)) {
            return;
        }
        EntityData mob = new EntityData(this.controller, mobKey, mobConfiguration);
        try {
            EntityType defaultType = EntityType.valueOf((String)mobKey.toUpperCase());
            this.defaultMobs.put(defaultType, mob);
            return;
        }
        catch (Exception defaultType) {
            this.mobs.put(mobKey, mob);
            String mobName = mob.getName();
            if (mobName != null && !mobName.isEmpty()) {
                this.mobsByName.put(mobName, mob);
            }
            return;
        }
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.HIGHEST)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        if (EntityData.isSpawning) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (entity.getType() == EntityType.PLAYER) {
            return;
        }
        Plugin plugin = this.controller.getPlugin();
        String customName = entity.getCustomName();
        EntityData customMob = this.defaultMobs.get(entity.getType());
        if (customName == null && customMob != null) {
            plugin.getServer().getScheduler().runTaskLater(plugin, (Runnable)new ModifyEntityTask(this.controller, customMob, (Entity)entity), 1L);
            return;
        }
        if (customName == null || customName.isEmpty()) {
            return;
        }
        CreatureSpawnEvent.SpawnReason reason = event.getSpawnReason();
        if (reason != CreatureSpawnEvent.SpawnReason.SPAWNER && reason != CreatureSpawnEvent.SpawnReason.SPAWNER_EGG && reason != CreatureSpawnEvent.SpawnReason.DISPENSE_EGG && reason != CreatureSpawnEvent.SpawnReason.CUSTOM) {
            return;
        }
        EntityData namedMob = this.mobsByName.get(customName);
        if (namedMob == null) {
            return;
        }
        plugin.getServer().getScheduler().runTaskLater(plugin, (Runnable)new ModifyEntityTask(this.controller, namedMob, (Entity)entity), 1L);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onEntityTarget(EntityTargetEvent event) {
        com.elmakers.mine.bukkit.api.entity.EntityData entityData;
        Entity entity = event.getEntity();
        if (this.controller.isMagicNPC(entity)) {
            event.setCancelled(true);
        } else if (event.getReason() == EntityTargetEvent.TargetReason.CLOSEST_PLAYER && (entityData = this.controller.getMob(entity)) != null && entityData.isDocile()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityTargetEntity(EntityTargetLivingEntityEvent event) {
        Mage mage;
        Entity source = event.getEntity();
        if (source instanceof Player || event.isCancelled()) {
            return;
        }
        LivingEntity target = event.getTarget();
        if (target != null) {
            Mage targetMage;
            if (source.hasMetadata("owner")) {
                List metadata = source.getMetadata("owner");
                for (MetadataValue value : metadata) {
                    String ownerId = value.asString();
                    Mage mageOwner = this.controller.getRegisteredMage(ownerId);
                    if (mageOwner == null || mageOwner.getEntity() != target) continue;
                    event.setCancelled(true);
                    return;
                }
            }
            if ((targetMage = this.controller.getRegisteredMage((Entity)target)) != null && targetMage.isSuperProtected()) {
                event.setCancelled(true);
                return;
            }
        }
        if ((mage = this.controller.getRegisteredMage(source)) == null) {
            return;
        }
        Entity currentTarget = mage.getTopDamager();
        if (currentTarget != null && currentTarget != target) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onSlimeSplit(SlimeSplitEvent event) {
        Slime entity = event.getEntity();
        if (entity.hasMetadata("nosplit")) {
            event.setCancelled(true);
            entity.removeMetadata("nosplit", this.controller.getPlugin());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        boolean isMagicMob;
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        EntityData mob = this.activeMobs.get(entity);
        boolean bl = isMagicMob = mob != null;
        if (mob == null) {
            return;
        }
        if (isMagicMob) {
            this.activeMobs.remove(entity);
            MagicMobDeathEvent deathEvent = new MagicMobDeathEvent(this.controller, mob, event);
            Bukkit.getPluginManager().callEvent((Event)deathEvent);
        }
        if (!mob.isSplittable()) {
            entity.setMetadata("nosplit", (MetadataValue)new FixedMetadataValue(this.controller.getPlugin(), (Object)true));
        }
        if (!entity.hasMetadata("nodrops")) {
            mob.modifyDrops(this.controller, event);
        }
        entity.removeMetadata("nodrops", this.controller.getPlugin());
    }

    public int getCount() {
        return this.mobs.size();
    }

    public Set<String> getKeys() {
        return this.mobs.keySet();
    }

    public Collection<EntityData> getMobs() {
        return this.mobs.values();
    }

    public EntityData get(String key) {
        return this.mobs.get(key);
    }

    public EntityData getByName(String name) {
        return this.mobsByName.get(name);
    }

    public void register(@Nonnull Entity entity, @Nonnull EntityData entityData) {
        this.activeMobs.put(entity, entityData);
    }

    @Nullable
    public EntityData getEntityData(Entity entity) {
        EntityData entityData = this.activeMobs.get(entity);
        if (entityData == null) {
            String customName = entity.getCustomName();
            if (customName != null) {
                entityData = this.mobsByName.get(customName);
            }
            if (entityData == null) {
                entityData = this.defaultMobs.get(entity.getType());
            }
        }
        return entityData;
    }

    @Nonnull
    public Collection<Entity> getActiveMobs() {
        return new ArrayList<Entity>(this.activeMobs.keySet());
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent event) {
        Chunk chunk = event.getChunk();
        Collection<Mage> magicMobs = this.controller.getMobMages();
        ArrayList<Entity> toRemove = null;
        for (Mage mage : magicMobs) {
            Entity entity = mage.getEntity();
            if (entity == null) continue;
            Location location = entity.getLocation();
            if (!chunk.getWorld().getName().equals(location.getWorld().getName())) continue;
            int chunkX = chunk.getX();
            int chunkZ = chunk.getZ();
            if (chunkZ != location.getBlockZ() >> 4 || chunkX != location.getBlockX() >> 4) continue;
            mage.sendDebugMessage(ChatColor.RED + "Despawned", 4);
            if (toRemove == null) {
                toRemove = new ArrayList<Entity>();
            }
            toRemove.add(entity);
        }
        if (toRemove != null) {
            for (Entity entity : toRemove) {
                entity.remove();
            }
        }
    }

    @Nonnull
    public EntityData getDefaultMob(EntityType entityType) {
        EntityData defaultMob = this.defaultMobs.get(entityType);
        if (defaultMob == null) {
            defaultMob = new EntityData(entityType);
        }
        return defaultMob;
    }
}

