/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicConfigurable;
import com.elmakers.mine.bukkit.api.magic.MagicPropertyType;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.magic.BaseMagicProperties;
import com.elmakers.mine.bukkit.utility.ColorHD;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.NumberConversions;

public abstract class BaseMagicConfigurable
extends BaseMagicProperties
implements MagicConfigurable {
    protected final MagicPropertyType type;
    protected final Map<String, MagicPropertyType> propertyRoutes = new HashMap<String, MagicPropertyType>();

    public BaseMagicConfigurable(MagicPropertyType type, MageController controller) {
        super(controller);
        this.type = type;
    }

    public void loadProperties() {
        ConfigurationSection routeConfig;
        Object storageObject = this.getInheritedProperty("storage");
        ConfigurationSection configurationSection = routeConfig = storageObject == null || !(storageObject instanceof ConfigurationSection) ? null : (ConfigurationSection)storageObject;
        if (routeConfig != null) {
            Set keys = routeConfig.getKeys(false);
            for (String key : keys) {
                String routeList = routeConfig.getString(key);
                String[] routes = StringUtils.split((String)routeList, (String)",");
                MagicPropertyType propertyType = null;
                for (String route : routes) {
                    try {
                        MagicPropertyType routeType = MagicPropertyType.valueOf(route.toUpperCase());
                        if (routeType == this.type) {
                            propertyType = routeType;
                            break;
                        }
                        if (propertyType != null) continue;
                        propertyType = routeType;
                    }
                    catch (Exception ex) {
                        this.controller.getLogger().info("Invalid property type: " + route);
                    }
                }
                if (this.type == MagicPropertyType.CLASS && propertyType == MagicPropertyType.SUBCLASS || propertyType == null || propertyType == this.type) continue;
                this.propertyRoutes.put(key, propertyType);
                this.migrateProperty(key, propertyType);
            }
        }
    }

    @Nullable
    public Object getInheritedProperty(String key) {
        return this.getProperty(key);
    }

    protected void migrateProperty(String key, MagicPropertyType propertyType) {
        this.migrateProperty(key, propertyType, null);
    }

    protected void migrateProperty(String key, MagicPropertyType propertyType, BaseMagicProperties template) {
        Object ownValue = this.configuration.get(key);
        Object value = ownValue;
        if (value == null && template != null) {
            value = template.getConfiguration().get(key);
        }
        if (value != null) {
            BaseMagicConfigurable storage = this.getStorage(propertyType);
            if (storage != null) {
                if (ownValue != null) {
                    this.configuration.set(key, null);
                }
                storage.upgradeInternal(key, value);
            } else {
                this.controller.getLogger().warning("Attempt to migrate property " + key + " on " + (Object)((Object)this.type) + " which routes to unavailable storage " + (Object)((Object)propertyType));
            }
        }
    }

    public void setProperty(String key, Object value) {
        MagicPropertyType propertyType = this.propertyRoutes.get(key);
        if (propertyType == null) {
            this.configuration.set(key, value);
        } else {
            BaseMagicConfigurable storage = this.getStorage(propertyType);
            if (storage != null) {
                storage.configuration.set(key, value);
            } else {
                this.controller.getLogger().warning("Attempt to set property " + key + " on " + (Object)((Object)this.type) + " which routes to unavailable storage " + (Object)((Object)propertyType));
            }
        }
    }

    @Nullable
    protected BaseMagicConfigurable getStorage(String key) {
        MagicPropertyType propertyType = this.propertyRoutes.get(key);
        if (propertyType == null) {
            return null;
        }
        return this.getStorage(propertyType);
    }

    @Override
    @Nullable
    public BaseMagicConfigurable getStorage(MagicPropertyType propertyType) {
        return null;
    }

    @Nullable
    protected Object convertProperty(@Nullable Object value) {
        return ConfigurationUtils.convertProperty(value);
    }

    protected boolean upgradeProperty(String key, Object value) {
        return this.upgradeProperty(key, value, false);
    }

    protected boolean upgradeProperty(String key, Object value, boolean force) {
        value = this.convertProperty(value);
        Object currentValue = this.getProperty(key);
        if (currentValue == value) {
            return false;
        }
        if (currentValue != null && value != null && !force) {
            try {
                String stringCurrent;
                String stringValue;
                if (currentValue.equals(value)) {
                    return false;
                }
                if (value instanceof Number || currentValue instanceof Number) {
                    float floatValue = NumberConversions.toFloat((Object)value);
                    float floatCurrent = NumberConversions.toFloat((Object)currentValue);
                    if (floatCurrent >= floatValue) {
                        return false;
                    }
                } else if (value instanceof String && (stringValue = value.toString()).equalsIgnoreCase(stringCurrent = currentValue.toString())) {
                    return false;
                }
            }
            catch (Exception ex) {
                this.controller.getLogger().log(Level.WARNING, "Error migrating property " + key, ex);
                return false;
            }
        }
        this.sendDebug("Upgraded property: " + key);
        if (value != null && value instanceof Number) {
            this.sendAddMessage("upgraded_property", this.controller.getMessages().getLevelString("wand." + key, NumberConversions.toFloat((Object)value)));
        }
        this.sendMessage(key + "_usage");
        this.setProperty(key, value);
        return true;
    }

    protected void addPotionEffects(Map<PotionEffectType, Integer> effects, String effectsString) {
        String[] effectStrings;
        if (effectsString == null || effectsString.isEmpty()) {
            return;
        }
        effectsString = effectsString.replaceAll("[\\]\\[]", "");
        for (String effectString : effectStrings = StringUtils.split((String)effectsString, (char)',')) {
            try {
                PotionEffectType type;
                effectString = effectString.trim();
                int power = 0;
                if (effectString.contains(":")) {
                    String[] pieces = StringUtils.split((String)effectString, (char)':');
                    type = PotionEffectType.getByName((String)pieces[0].toUpperCase());
                    power = Integer.parseInt(pieces[1]);
                } else {
                    type = PotionEffectType.getByName((String)effectString.toUpperCase());
                }
                if (type == null) {
                    throw new Exception("Invalid potion effect");
                }
                Integer existing = effects.get(type);
                if (existing != null && existing >= power) continue;
                effects.put(type, power);
            }
            catch (Exception ex) {
                this.controller.getLogger().log(Level.WARNING, "Invalid potion effect: " + effectString);
            }
        }
    }

    protected boolean upgradePotionEffects(String key, Object value) {
        if (!(value instanceof String)) {
            return false;
        }
        boolean modified = false;
        String currentValue = this.getProperty(key, "");
        HashMap<PotionEffectType, Integer> currentEffects = new HashMap<PotionEffectType, Integer>();
        HashMap<PotionEffectType, Integer> newEffects = new HashMap<PotionEffectType, Integer>();
        this.addPotionEffects(currentEffects, currentValue);
        this.addPotionEffects(newEffects, (String)value);
        for (Map.Entry otherEffects : newEffects.entrySet()) {
            Integer current = (Integer)currentEffects.get(otherEffects.getKey());
            if (current != null && current >= (Integer)otherEffects.getValue()) continue;
            currentEffects.put((PotionEffectType)otherEffects.getKey(), (Integer)otherEffects.getValue());
            this.sendAddMessage("upgraded_property", this.describePotionEffect((PotionEffectType)otherEffects.getKey(), (Integer)otherEffects.getValue()));
            this.sendDebug("Added potion effect: " + otherEffects.getKey());
            modified = true;
        }
        if (modified) {
            this.setProperty("potion_effects", BaseMagicConfigurable.getPotionEffectString(currentEffects));
        }
        return modified;
    }

    protected boolean organizeInventory() {
        return false;
    }

    protected boolean alphabetizeInventory() {
        return false;
    }

    public boolean addBrush(String materialKey) {
        return false;
    }

    private boolean upgradeBrushes(Object value) {
        if (!(value instanceof String) && !(value instanceof List)) {
            return false;
        }
        boolean modified = false;
        List<String> materials = value instanceof String ? Arrays.asList(StringUtils.split((String)((String)value), (char)',')) : (List<String>)value;
        for (String materialKey : materials) {
            if (!this.addBrush(materialKey = StringUtils.split((String)materialKey, (char)'@')[0].trim())) continue;
            modified = true;
            this.sendDebug("Added brush: " + materialKey);
        }
        return modified;
    }

    public boolean addOverride(String key, String value) {
        return false;
    }

    private boolean upgradeOverrides(Object value) {
        boolean modified = false;
        List<String> overrides = value instanceof String ? Arrays.asList(StringUtils.split((String)((String)value), (char)',')) : (List<String>)value;
        HashSet<String> upgradedSpells = new HashSet<String>();
        for (String override : overrides) {
            String[] pairs = StringUtils.split((String)(override = override.replace("\\|", ",")), (char)' ');
            if (pairs.length <= 1 || !this.addOverride(pairs[0], pairs[1])) continue;
            this.sendDebug("Added override: " + pairs[0] + " " + pairs[1]);
            String[] pieces = StringUtils.split((String)pairs[0], (char)'.');
            if (pieces.length > 1 && !upgradedSpells.contains(pieces[0])) {
                upgradedSpells.add(pieces[0]);
                SpellTemplate spell = this.controller.getSpellTemplate(pieces[0]);
                if (spell != null) {
                    this.sendAddMessage("spell_override_upgraded", spell.getName());
                }
            }
            modified = true;
        }
        return modified;
    }

    public boolean addSpell(String spellKey) {
        return false;
    }

    private boolean upgradeSpells(Object value) {
        if (!(value instanceof String) && !(value instanceof List)) {
            return false;
        }
        boolean modified = false;
        List<String> spells = value instanceof String ? Arrays.asList(StringUtils.split((String)((String)value), (char)',')) : (List<String>)value;
        for (String spellKey : spells) {
            if (!this.addSpell(spellKey = StringUtils.split((String)spellKey, (char)'@')[0].trim())) continue;
            modified = true;
            this.sendDebug("Added spell: " + spellKey);
        }
        return modified;
    }

    @Nonnull
    protected Map<String, Integer> getSpellLevels() {
        Object existingLevelsRaw = this.getObject("spell_levels");
        if (existingLevelsRaw == null) {
            return new HashMap<String, Integer>();
        }
        Map spellLevels = null;
        spellLevels = existingLevelsRaw instanceof Map ? (Map)existingLevelsRaw : (existingLevelsRaw instanceof ConfigurationSection ? NMSUtils.getTypedMap((ConfigurationSection)existingLevelsRaw) : new HashMap());
        return spellLevels;
    }

    protected boolean upgradeSpellLevel(String spellKey, int level) {
        BaseMagicConfigurable storage = this.getStorage("spell_levels");
        if (storage != this && storage != null) {
            return storage.upgradeSpellLevel(spellKey, level);
        }
        boolean modified = false;
        Map<String, Integer> spellLevels = this.getSpellLevels();
        Integer existingLevel = spellLevels.get(spellKey);
        if (existingLevel == null || level > existingLevel) {
            modified = true;
            spellLevels.put(spellKey, level);
        }
        if (modified) {
            this.setProperty("spell_levels", spellLevels);
        }
        return modified;
    }

    private boolean upgradeSpellLevels(Object value) {
        if (!(value instanceof Map) && !(value instanceof ConfigurationSection)) {
            return false;
        }
        boolean modified = false;
        Map<String, Integer> spellLevels = this.getSpellLevels();
        Map newLevels = value instanceof Map ? (Map)value : NMSUtils.getTypedMap((ConfigurationSection)value);
        for (Map.Entry entry : newLevels.entrySet()) {
            Integer newLevel = (Integer)entry.getValue();
            String key = entry.getKey();
            Integer existingLevel = spellLevels.get(key);
            if (existingLevel != null && newLevel <= existingLevel) continue;
            modified = true;
            this.sendDebug("Upgraded spell level for " + key + " from " + existingLevel + " to " + newLevel);
            spellLevels.put(key, newLevel);
        }
        if (modified) {
            this.setProperty("spell_levels", spellLevels);
        }
        return modified;
    }

    protected void configureInternal(@Nonnull String key, @Nonnull Object value) {
        if (value instanceof ConfigurationSection) {
            return;
        }
        value = this.convertProperty(value);
        this.setProperty(key, value);
    }

    protected void preUpdate() {
    }

    @Override
    public void configure(@Nonnull String key, @Nonnull Object value) {
        this.preUpdate();
        this.configureInternal(key, value);
        this.updated();
    }

    @Override
    public void configure(@Nonnull ConfigurationSection configuration) {
        this.preUpdate();
        Set keys = configuration.getKeys(true);
        for (String key : keys) {
            Object value = configuration.get(key);
            this.configureInternal(key, value);
        }
        this.updated();
    }

    protected boolean upgradeInternal(String key, Object value) {
        boolean modified = false;
        switch (key) {
            case "quiet": {
                modified = this.upgradeProperty(key, value, true);
                break;
            }
            case "potion_effects": {
                modified = this.upgradePotionEffects(key, value);
                break;
            }
            case "mana": 
            case "mana_regeneration": 
            case "mana_max": 
            case "mana_per_damage": {
                double costReduction = this.getDouble("cost_reduction", 0.0);
                if (!(costReduction <= 1.0)) break;
                modified = this.upgradeProperty(key, value);
                break;
            }
            case "effect_color": {
                if (!(value instanceof String)) break;
                ColorHD newColor = new ColorHD((String)value);
                modified = this.upgradeProperty(key, newColor.toString(), true);
                break;
            }
            case "organize": {
                if (!this.organizeInventory()) break;
                modified = true;
                this.sendMessage("reorganized");
                break;
            }
            case "alphabetize": {
                if (!this.alphabetizeInventory()) break;
                modified = true;
                this.sendMessage("alphabetized");
                break;
            }
            case "spells": {
                modified = this.upgradeSpells(value);
                break;
            }
            case "spell_levels": {
                modified = this.upgradeSpellLevels(value);
                break;
            }
            case "materials": {
                modified = this.upgradeBrushes(value);
                break;
            }
            case "overrides": {
                modified = this.upgradeOverrides(value);
                break;
            }
            default: {
                modified = this.upgradeProperty(key, value);
            }
        }
        return modified;
    }

    @Override
    public boolean upgrade(@Nonnull ConfigurationSection configuration) {
        this.preUpdate();
        boolean modified = false;
        Set keys = configuration.getKeys(true);
        for (String key : keys) {
            Object value = configuration.get(key);
            if (value instanceof ConfigurationSection) continue;
            modified = this.upgradeInternal(key, value) || modified;
        }
        if (modified) {
            this.updated();
        }
        return modified;
    }

    @Override
    public boolean upgrade(@Nonnull String key, @Nonnull Object value) {
        this.preUpdate();
        if (value instanceof ConfigurationSection) {
            return false;
        }
        boolean modified = this.upgradeInternal(key, value);
        if (modified) {
            this.updated();
        }
        return modified;
    }

    public void updated() {
    }

    @Override
    public boolean removeProperty(String key) {
        if (!this.hasOwnProperty(key)) {
            return false;
        }
        this.preUpdate();
        this.setProperty(key, null);
        this.updated();
        return true;
    }

    public void clear() {
        this.configuration = new MemoryConfiguration();
    }
}

