/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicPropertyType;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.TemplateProperties;
import com.elmakers.mine.bukkit.magic.TemplatedProperties;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;

public abstract class ParentedProperties
extends TemplatedProperties {
    @Nullable
    private ParentedProperties parent;

    public ParentedProperties(MagicPropertyType type, MageController controller, @Nullable TemplateProperties template) {
        super(type, controller, template);
    }

    @Nullable
    public ParentedProperties getParent() {
        return this.parent;
    }

    public ParentedProperties getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    public void setParent(@Nonnull ParentedProperties parent) {
        this.parent = parent;
    }

    @Override
    @Nullable
    public Object getInheritedProperty(String key) {
        Object value = super.getInheritedProperty(key);
        if (value == null && this.parent != null) {
            value = this.parent.getInheritedProperty(key);
        }
        return value;
    }

    public ConfigurationSection getEffectiveConfiguration() {
        ParentedProperties parent;
        ConfigurationSection effectiveConfiguration = ConfigurationUtils.cloneConfiguration(this.getConfiguration());
        TemplateProperties template = this.getTemplate();
        if (template != null) {
            ConfigurationSection templateConfiguration = ConfigurationUtils.cloneConfiguration(template.getConfiguration());
            for (String key : templateConfiguration.getKeys(false)) {
                MagicPropertyType propertyRoute = (MagicPropertyType)((Object)this.propertyRoutes.get(key));
                if (propertyRoute == null || propertyRoute == this.type) continue;
                templateConfiguration.set(key, null);
            }
            ConfigurationUtils.overlayConfigurations(effectiveConfiguration, templateConfiguration);
        }
        if ((parent = this.getParent()) != null) {
            ConfigurationSection parentConfiguration = parent.getEffectiveConfiguration();
            ConfigurationUtils.overlayConfigurations(effectiveConfiguration, parentConfiguration);
        }
        return effectiveConfiguration;
    }

    @Override
    public void describe(CommandSender sender, @Nullable Set<String> ignoreProperties, @Nullable Set<String> overriddenProperties) {
        super.describe(sender, ignoreProperties, overriddenProperties);
        if (overriddenProperties == null) {
            overriddenProperties = new HashSet<String>();
        }
        Set ownKeys = this.getConfiguration().getKeys(false);
        overriddenProperties.addAll(ownKeys);
        sender.sendMessage("" + ChatColor.BOLD + ChatColor.GREEN + "Template Configuration for (" + ChatColor.DARK_GREEN + this.getKey() + ChatColor.GREEN + "):");
        TemplateProperties template = this.getTemplate();
        HashSet<String> overriddenTemplateProperties = new HashSet<String>(overriddenProperties);
        for (String key : template.getConfiguration().getKeys(false)) {
            MagicPropertyType propertyRoute = (MagicPropertyType)((Object)this.propertyRoutes.get(key));
            if (propertyRoute == null || propertyRoute == this.type) {
                overriddenProperties.add(key);
                continue;
            }
            overriddenTemplateProperties.add(key);
        }
        template.describe(sender, ignoreProperties, overriddenTemplateProperties);
        ParentedProperties parent = this.getParent();
        if (parent != null) {
            sender.sendMessage(ChatColor.AQUA + "Parent: " + ChatColor.GREEN + parent.getKey());
            parent.describe(sender, ignoreProperties, overriddenProperties);
        }
    }

    @Override
    public boolean tickMana() {
        ParentedProperties parent = this.getParent();
        if (!this.hasOwnMana() && parent != null) {
            return parent.tickMana();
        }
        return super.tickMana();
    }

    @Override
    public void loadProperties() {
        ParentedProperties parent = this.getParent();
        if (parent != null) {
            parent.loadProperties();
        }
        super.loadProperties();
        this.passiveEffectsUpdated();
    }

    @Override
    public void passiveEffectsUpdated() {
        if (this.hasOwnMana()) {
            this.updateMaxMana(this.getMage());
        }
    }

    public boolean isLocked() {
        if (super.getProperty("locked", false).booleanValue()) {
            return true;
        }
        ParentedProperties parent = this.getParent();
        if (parent != null) {
            return parent.isLocked();
        }
        return false;
    }

    public void unlock() {
        this.configuration.set("locked", null);
        ParentedProperties parent = this.getParent();
        if (parent != null) {
            parent.unlock();
        }
        this.onUnlocked();
    }

    protected void onUnlocked() {
    }

    public void lock() {
        this.configuration.set("locked", (Object)true);
        this.onLocked();
    }

    protected void onLocked() {
    }

    @Override
    public boolean updateMaxMana(Mage mage) {
        if (!this.hasOwnMana()) {
            boolean modified = false;
            ParentedProperties parent = this.getParent();
            if (parent != null) {
                modified = parent.updateMaxMana(mage);
                this.effectiveManaMax = parent.getEffectiveManaMax();
                this.effectiveManaRegeneration = parent.getEffectiveManaRegeneration();
            }
            return modified;
        }
        return super.updateMaxMana(mage);
    }
}

