/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.api.entity;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.item.Cost;
import com.elmakers.mine.bukkit.api.magic.MageController;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Art;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;

public interface EntityData
extends Cloneable {
    public String getKey();

    public Location getLocation();

    public EntityType getType();

    public String getName();

    public Art getArt();

    public BlockFace getFacing();

    public ItemStack getItem();

    public double getHealth();

    public void setHasMoved(boolean var1);

    public void setDamaged(boolean var1);

    public boolean isDocile();

    public boolean isPreventProjectiles();

    public boolean isPreventMelee();

    public boolean isTransformable();

    public boolean isNPC();

    public boolean isHidden();

    @Nullable
    public Entity spawn();

    @Nullable
    public Entity spawn(MageController var1);

    @Nullable
    public Entity spawn(Location var1);

    @Nullable
    public Entity spawn(MageController var1, Location var2);

    @Nullable
    public Entity spawn(MageController var1, Location var2, CreatureSpawnEvent.SpawnReason var3);

    @Nullable
    public Entity undo();

    public boolean modify(MageController var1, Entity var2);

    public boolean modify(Entity var1);

    @Nullable
    public EntityData getRelativeTo(Location var1);

    public String describe();

    @Nullable
    public String getInteractSpell();

    public SourceType getInteractSpellSource();

    public TargetType getInteractSpellTarget();

    @Nullable
    public ConfigurationSection getInteractSpellParameters();

    public SourceType getInteractCommandSource();

    public List<String> getInteractCommands();

    @Nullable
    public Collection<Cost> getInteractCosts();

    public boolean hasInteract();

    public void setMaterial(@Nonnull MaterialAndData var1);

    @Nullable
    public String getInteractPermission();

    @Nullable
    public MaterialAndData getMaterial();

    @Nullable
    public ConfigurationSection getConfiguration();

    public void load(@Nonnull MageController var1, ConfigurationSection var2);

    public void attach(@Nonnull MageController var1, @Nonnull Entity var2);

    @Nonnull
    public EntityData clone();

    public static enum SourceType {
        PLAYER,
        MOB,
        CONSOLE,
        OPPED_PLAYER;

    }

    public static enum TargetType {
        NONE,
        PLAYER,
        MOB;

    }
}

