/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CompoundAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.action.GUIAction;
import com.elmakers.mine.bukkit.api.item.ItemUpdatedCallback;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.DeprecatedUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;

public class EntitySelectAction
extends CompoundAction
implements GUIAction {
    private Map<Integer, WeakReference<Entity>> entities;
    private double radius;
    private int limit = 64;
    private boolean active = false;
    private WeakReference<Entity> target = null;

    @Override
    public void deactivated() {
        this.active = false;
    }

    @Override
    public void dragged(InventoryDragEvent event) {
        event.setCancelled(true);
    }

    @Override
    public void clicked(InventoryClickEvent event) {
        int slot = event.getRawSlot();
        event.setCancelled(true);
        if (event.getSlotType() == InventoryType.SlotType.CONTAINER) {
            Entity entity;
            this.target = this.entities.get(slot);
            Entity entity2 = entity = this.target != null ? (Entity)this.target.get() : null;
            if (entity != null) {
                Mage mage = this.actionContext.getMage();
                mage.deactivateGUI();
                this.actionContext.setTargetEntity(entity);
                this.actionContext.setTargetLocation(entity.getLocation());
                this.actionContext.playEffects("entity_selected");
            }
            this.entities.clear();
            this.active = false;
        }
    }

    @Override
    public void reset(CastContext context) {
        super.reset(context);
        this.entities = new HashMap<Integer, WeakReference<Entity>>();
        this.active = false;
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.radius = parameters.getDouble("radius", 32.0);
        this.limit = parameters.getInt("limit", 64);
    }

    @Override
    public SpellResult step(CastContext context) {
        Entity targetEntity;
        if (this.active) {
            return SpellResult.PENDING;
        }
        Entity entity = targetEntity = this.target == null ? null : (Entity)this.target.get();
        if (targetEntity == null) {
            return SpellResult.NO_TARGET;
        }
        return this.startActions();
    }

    @Override
    public SpellResult start(CastContext context) {
        Mage mage = context.getMage();
        MageController controller = context.getController();
        Player player = mage.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        final Location location = context.getLocation();
        ArrayList allEntities = new ArrayList(location.getWorld().getNearbyEntities(location, this.radius, this.radius, this.radius));
        this.entities.clear();
        Collections.sort(allEntities, new Comparator<Entity>(){

            @Override
            public int compare(Entity entity1, Entity entity2) {
                return Double.compare(location.distanceSquared(entity1.getLocation()), location.distanceSquared(entity2.getLocation()));
            }
        });
        int index = 0;
        for (Entity targetEntity : allEntities) {
            if (targetEntity instanceof LivingEntity && ((LivingEntity)targetEntity).hasPotionEffect(PotionEffectType.INVISIBILITY) || !context.canTarget(targetEntity)) continue;
            this.entities.put(index++, new WeakReference<Entity>(targetEntity));
            if (this.entities.size() < this.limit) continue;
            break;
        }
        if (this.entities.size() == 0) {
            return SpellResult.NO_TARGET;
        }
        String inventoryTitle = context.getMessage("title", "Select Target");
        int invSize = (this.entities.size() + 9) / 9 * 9;
        final Inventory displayInventory = CompatibilityUtils.createInventory(null, invSize, inventoryTitle);
        for (Map.Entry<Integer, WeakReference<Entity>> entry : this.entities.entrySet()) {
            Entity targetEntity = (Entity)entry.getValue().get();
            if (targetEntity == null) continue;
            String displayName = DeprecatedUtils.getDisplayName(targetEntity);
            final Integer slot = entry.getKey();
            controller.getSkull(targetEntity, displayName, new ItemUpdatedCallback(){

                @Override
                public void updated(@Nullable ItemStack itemStack) {
                    displayInventory.setItem(slot.intValue(), itemStack);
                }
            });
        }
        this.active = true;
        mage.activateGUI(this, displayInventory);
        return SpellResult.NO_ACTION;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        parameters.add("radius");
        parameters.add("limit");
        super.getParameterNames(spell, parameters);
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("radius") || parameterKey.equals("limit")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

