/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.warp;

import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.warp.CommandBookWarps;
import com.elmakers.mine.bukkit.warp.EssentialsWarps;
import com.elmakers.mine.bukkit.warp.MagicWarp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public class WarpController {
    private final MagicController controller;
    private CommandBookWarps commandBook;
    private EssentialsWarps essentials;
    private final Map<String, MagicWarp> warps = new HashMap<String, MagicWarp>();

    public WarpController(MagicController controller) {
        this.controller = controller;
    }

    public void load(ConfigurationSection warpData) {
        this.warps.clear();
        Set keys = warpData.getKeys(false);
        for (String key : keys) {
            MagicWarp warp = new MagicWarp(key, warpData);
            this.warps.put(key, warp);
            warp.checkMarker(this.controller);
        }
    }

    public void save(ConfigurationSection warpData) {
        for (MagicWarp warp : this.warps.values()) {
            warp.save(warpData);
        }
    }

    public Collection<String> getCustomWarps() {
        return this.warps.keySet();
    }

    public boolean hasCustomWarp(String warpName) {
        return this.warps.containsKey(warpName);
    }

    public void setWarp(String warpName, Location location) {
        MagicWarp warp = this.warps.get(warpName);
        if (warp == null) {
            this.warps.put(warpName, new MagicWarp(warpName, location));
        } else {
            warp.setLocation(location);
            warp.checkMarker(this.controller);
        }
    }

    public boolean removeWarp(String warpName) {
        return this.warps.remove(warpName) != null;
    }

    public int importWarps() {
        String key;
        if (this.commandBook != null) {
            for (Map.Entry<String, Location> warpEntry : this.commandBook.getWarps().entrySet()) {
                key = warpEntry.getKey();
                this.warps.put(key, new MagicWarp(key, warpEntry.getValue()));
            }
        }
        if (this.essentials != null) {
            for (Map.Entry<String, Location> warpEntry : this.essentials.getWarps().entrySet()) {
                key = warpEntry.getKey();
                this.warps.put(key, new MagicWarp(key, warpEntry.getValue()));
            }
        }
        return this.warps.size();
    }

    @Nullable
    public MagicWarp getMagicWarp(String warpName) {
        return this.warps.get(warpName);
    }

    public Collection<MagicWarp> getMagicWarps() {
        return this.warps.values();
    }

    @Nullable
    public Location getWarp(String warpName) {
        Location warp = null;
        MagicWarp customWarp = this.warps.get(warpName);
        if (customWarp != null) {
            warp = customWarp.getLocation();
        }
        if (warp == null && this.commandBook != null) {
            warp = this.commandBook.getWarp(warpName);
        }
        if (warp == null && this.essentials != null) {
            warp = this.essentials.getWarp(warpName);
        }
        return warp;
    }

    public boolean setCommandBook(Plugin plugin) {
        this.commandBook = CommandBookWarps.create(plugin);
        return this.commandBook != null;
    }

    public boolean setEssentials(Plugin plugin) {
        this.essentials = EssentialsWarps.create(plugin);
        return this.essentials != null;
    }

    public List<String> getWarps() {
        return new ArrayList<String>(this.warps.keySet());
    }
}

