/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.utility.AscendingPair;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.WeightedPair;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.util.Vector;

public class RandomUtils {
    private static final Random random = new Random();

    public static float lerp(String[] list, int levelIndex, int nextLevelIndex, float distance) {
        if (list.length == 0) {
            return 0.0f;
        }
        if (levelIndex >= list.length) {
            return Float.parseFloat(list[list.length - 1]);
        }
        if (nextLevelIndex >= list.length) {
            return Float.parseFloat(list[list.length - 1]);
        }
        float previousValue = Float.parseFloat(list[levelIndex]);
        float nextValue = Float.parseFloat(list[nextLevelIndex]);
        return RandomUtils.lerp(Float.valueOf(previousValue), Float.valueOf(nextValue), distance).floatValue();
    }

    public static <T extends Number> T lerp(T previousValue, T nextValue, float distance) {
        return (T)Float.valueOf(((Float)previousValue).floatValue() + distance * (((Float)nextValue).floatValue() - ((Float)previousValue).floatValue()));
    }

    @Nullable
    @Deprecated
    public static <T> T weightedRandom(LinkedList<WeightedPair<T>> weightList) {
        return RandomUtils.weightedRandom(weightList);
    }

    @Nullable
    public static <T> T weightedRandom(Deque<WeightedPair<T>> weightList) {
        if (weightList == null || weightList.size() == 0) {
            return null;
        }
        Float maxWeight = weightList.getLast().getThreshold();
        Float selectedWeight = Float.valueOf(random.nextFloat() * maxWeight.floatValue());
        for (WeightedPair<T> weight : weightList) {
            if (!(selectedWeight.floatValue() < weight.getThreshold().floatValue())) continue;
            return weight.getValue();
        }
        return weightList.getFirst().getValue();
    }

    public static void populateIntegerProbabilityMap(Deque<WeightedPair<Integer>> probabilityMap, ConfigurationSection nodeMap, int levelIndex, int nextLevelIndex, float distance) {
        RandomUtils.populateProbabilityMap(Integer.class, probabilityMap, nodeMap, levelIndex, nextLevelIndex, distance);
    }

    public static void populateIntegerProbabilityMap(Deque<WeightedPair<Integer>> probabilityMap, ConfigurationSection nodeMap) {
        RandomUtils.populateProbabilityMap(Integer.class, probabilityMap, nodeMap, 0, 0, 0.0f);
    }

    public static void populateIntegerProbabilityMap(Deque<WeightedPair<Integer>> probabilityMap, ConfigurationSection parent, String key, int levelIndex, int nextLevelIndex, float distance) {
        if (parent.isConfigurationSection(key)) {
            RandomUtils.populateProbabilityMap(Integer.class, probabilityMap, parent.getConfigurationSection(key), levelIndex, nextLevelIndex, distance);
        } else if (parent.isInt(key)) {
            RandomUtils.populateProbabilityConstant(Integer.class, probabilityMap, parent.getString(key));
        } else {
            RandomUtils.populateProbabilityList(Integer.class, probabilityMap, ConfigurationUtils.getStringList(parent, key));
        }
    }

    public static void populateStringProbabilityMap(Deque<WeightedPair<String>> probabilityMap, ConfigurationSection nodeMap, int levelIndex, int nextLevelIndex, float distance) {
        RandomUtils.populateProbabilityMap(String.class, probabilityMap, nodeMap, levelIndex, nextLevelIndex, distance);
    }

    public static void populateStringProbabilityMap(Deque<WeightedPair<String>> probabilityMap, ConfigurationSection parent, String key, int levelIndex, int nextLevelIndex, float distance) {
        if (parent.isConfigurationSection(key)) {
            RandomUtils.populateProbabilityMap(String.class, probabilityMap, parent.getConfigurationSection(key), levelIndex, nextLevelIndex, distance);
        } else {
            RandomUtils.populateProbabilityList(String.class, probabilityMap, ConfigurationUtils.getStringList(parent, key));
        }
    }

    public static void populateStringProbabilityMap(Deque<WeightedPair<String>> probabilityMap, ConfigurationSection parent, String key) {
        RandomUtils.populateStringProbabilityMap(probabilityMap, parent, key, 0, 0, 0.0f);
    }

    public static void populateStringProbabilityMap(Deque<WeightedPair<String>> probabilityMap, ConfigurationSection nodeMap) {
        RandomUtils.populateProbabilityMap(String.class, probabilityMap, nodeMap, 0, 0, 0.0f);
    }

    public static void populateStringProbabilityList(Deque<WeightedPair<String>> probabilityMap, List<String> stringList) {
        RandomUtils.populateProbabilityList(String.class, probabilityMap, stringList);
    }

    public static void populateFloatProbabilityMap(Deque<WeightedPair<Float>> probabilityMap, ConfigurationSection nodeMap, int levelIndex, int nextLevelIndex, float distance) {
        RandomUtils.populateProbabilityMap(Float.class, probabilityMap, nodeMap, levelIndex, nextLevelIndex, distance);
    }

    public static void populateFloatProbabilityMap(Deque<WeightedPair<Float>> probabilityMap, ConfigurationSection parent, String key, int levelIndex, int nextLevelIndex, float distance) {
        if (parent.isConfigurationSection(key)) {
            RandomUtils.populateProbabilityMap(Float.class, probabilityMap, parent.getConfigurationSection(key), levelIndex, nextLevelIndex, distance);
        } else if (parent.isDouble(key) || parent.isInt(key)) {
            RandomUtils.populateProbabilityConstant(Float.class, probabilityMap, parent.getString(key));
        } else {
            RandomUtils.populateProbabilityList(Float.class, probabilityMap, ConfigurationUtils.getStringList(parent, key));
        }
    }

    public static void populateFloatProbabilityMap(Deque<WeightedPair<Float>> probabilityMap, ConfigurationSection nodeMap) {
        RandomUtils.populateProbabilityMap(Float.class, probabilityMap, nodeMap, 0, 0, 0.0f);
    }

    public static <T> void populateProbabilityConstant(Class<T> valueClass, Deque<WeightedPair<T>> probabilityMap, String value) {
        probabilityMap.add(new WeightedPair<T>(Float.valueOf(1.0f), Float.valueOf(1.0f), value, valueClass));
    }

    public static <T> void populateProbabilityList(Class<T> valueClass, Deque<WeightedPair<T>> probabilityMap, List<String> keys) {
        if (keys != null) {
            float currentThreshold = 0.0f;
            for (String key : keys) {
                probabilityMap.add(new WeightedPair<T>(Float.valueOf(currentThreshold += 1.0f), Float.valueOf(currentThreshold), key, valueClass));
            }
        }
    }

    public static <T> void populateProbabilityMap(Class<T> valueClass, Deque<WeightedPair<T>> probabilityMap, ConfigurationSection nodeMap, int levelIndex, int nextLevelIndex, float distance) {
        Float currentThreshold = Float.valueOf(0.0f);
        if (nodeMap != null) {
            Set keys = nodeMap.getKeys(false);
            for (String key : keys) {
                String value = nodeMap.getString(key);
                key = key.replace("^", ".");
                String[] pieces = StringUtils.split((String)value, (char)',');
                float weight = 0.0f;
                if (pieces != null && pieces.length > 1) {
                    weight = RandomUtils.lerp(pieces, levelIndex, nextLevelIndex, distance);
                } else {
                    try {
                        weight = Float.parseFloat(value);
                    }
                    catch (Exception ex) {
                        weight = 1.0f;
                    }
                }
                currentThreshold = Float.valueOf(currentThreshold.floatValue() + weight);
                probabilityMap.add(new WeightedPair<T>(currentThreshold, Float.valueOf(weight), key, valueClass));
            }
        }
    }

    public static <T> Deque<WeightedPair<T>> merge(Deque<WeightedPair<T>> base, Deque<WeightedPair<T>> inherit) {
        if (inherit == null || inherit.size() == 0) {
            return base;
        }
        if (base == null) {
            base = new ArrayDeque<WeightedPair<T>>();
        }
        if (base.size() == 0) {
            base.addAll(inherit);
        } else {
            WeightedPair<T> lastPair = base.getLast();
            float threshold = lastPair.getThreshold().floatValue();
            for (WeightedPair<T> inheritPair : inherit) {
                float weight = inheritPair.getThreshold().floatValue();
                base.add(new WeightedPair<T>(Float.valueOf(threshold += weight), inheritPair.getRawThreshold(), inheritPair.getValue()));
            }
        }
        return base;
    }

    @Nullable
    public static String getEntry(String csvList, int index) {
        if (csvList == null) {
            return null;
        }
        String[] pieces = StringUtils.split((String)csvList, (char)',');
        if (pieces == null || pieces.length <= 1) {
            return csvList;
        }
        if (index < 0 || index >= pieces.length) {
            return null;
        }
        return pieces[index];
    }

    public static void extrapolateFloatList(List<AscendingPair<Float>> list) {
        RandomUtils.extrapolateList(Float.class, list);
    }

    public static void extrapolateIntegerList(List<AscendingPair<Integer>> list) {
        RandomUtils.extrapolateList(Integer.class, list);
    }

    public static <T extends Number> void extrapolateList(Class<T> valueClass, List<AscendingPair<T>> list) {
        Collections.sort(list);
        for (int index = 0; index < list.size() - 1; ++index) {
            AscendingPair<T> current = list.get(index);
            AscendingPair<T> next = list.get(index + 1);
            long currentIndex = current.getIndex();
            long nextIndex = next.getIndex();
            if (nextIndex <= currentIndex + 1L) continue;
            float distance = 1.0f / (float)(nextIndex - currentIndex);
            AscendingPair<T> inserted = new AscendingPair<T>(currentIndex + 1L, RandomUtils.lerp(current.getValue(), next.getValue(), distance));
            list.add(index, inserted);
        }
    }

    public static Location randomizeLocation(Location origin, Vector range) {
        double xRange = range.getX();
        double yRange = range.getY();
        double zRange = range.getZ();
        origin.add(random.nextDouble() * xRange - xRange / 2.0, random.nextDouble() * yRange - yRange / 2.0, random.nextDouble() * zRange - zRange / 2.0);
        return origin;
    }

    public static <T> T getRandom(List<T> list, int startIndex) {
        return list.get(startIndex + random.nextInt(list.size() - 1));
    }

    public static <T> T getRandom(List<T> list) {
        return list.get(random.nextInt(list.size()));
    }

    public static Random getRandom() {
        return random;
    }
}

