/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.effect.EffectPlayer;
import com.elmakers.mine.bukkit.api.entity.EntityData;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.Arrays;
import java.util.Collection;
import org.bukkit.DyeColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Villager;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;

public class ModifyEntityAction
extends BaseSpellAction {
    private CreatureSpawnEvent.SpawnReason spawnReason = CreatureSpawnEvent.SpawnReason.EGG;
    private boolean loot = false;
    private boolean force = false;
    private boolean tamed = false;
    private boolean setOwner = true;
    private Vector direction = null;
    private double speed;
    private double dyOffset;
    private EntityData entityData;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.loot = parameters.getBoolean("loot", false);
        this.force = parameters.getBoolean("force", false);
        this.tamed = parameters.getBoolean("tamed", false);
        this.speed = parameters.getDouble("speed", 0.0);
        this.direction = ConfigurationUtils.getVector(parameters, "direction");
        this.dyOffset = parameters.getDouble("dy_offset", 0.0);
        String disguiseTarget = parameters.getString("disguise_target");
        if (disguiseTarget != null) {
            Entity targetEntity;
            Entity entity = targetEntity = disguiseTarget.equals("target") ? context.getTargetEntity() : context.getEntity();
            if (targetEntity != null) {
                ConfigurationSection disguiseConfig = parameters.createSection("disguise");
                disguiseConfig.set("type", (Object)targetEntity.getType().name().toLowerCase());
                if (targetEntity instanceof Player) {
                    Player targetPlayer = (Player)targetEntity;
                    disguiseConfig.set("name", (Object)targetPlayer.getName());
                    disguiseConfig.set("skin", (Object)targetPlayer.getName());
                }
            }
        }
        this.entityData = context.getController().getMob(parameters);
        if (parameters.contains("reason")) {
            String reasonText = parameters.getString("reason").toUpperCase();
            try {
                this.spawnReason = CreatureSpawnEvent.SpawnReason.valueOf((String)reasonText);
            }
            catch (Exception ex) {
                this.spawnReason = CreatureSpawnEvent.SpawnReason.EGG;
            }
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        Entity targetEntity = context.getTargetEntity();
        EntityType newType = this.entityData.getType();
        if (newType != null && !targetEntity.getType().equals((Object)newType)) {
            return this.replaceEntity(targetEntity, context);
        }
        Collection<EffectPlayer> entityEffects = context.getEffects("modified");
        for (EffectPlayer effectPlayer : entityEffects) {
            effectPlayer.start(targetEntity.getLocation(), targetEntity, null, null);
        }
        context.registerModified(targetEntity);
        this.entityData.modify(targetEntity);
        return this.modify(context, targetEntity);
    }

    private SpellResult modify(CastContext context, Entity spawnedEntity) {
        LivingEntity shooter;
        if (spawnedEntity == null) {
            return SpellResult.FAIL;
        }
        MageController controller = context.getController();
        if (spawnedEntity instanceof AreaEffectCloud) {
            ((AreaEffectCloud)spawnedEntity).setSource((ProjectileSource)context.getLivingEntity());
        } else if (spawnedEntity instanceof Projectile) {
            ((Projectile)spawnedEntity).setShooter((ProjectileSource)context.getLivingEntity());
        }
        if (!this.loot) {
            spawnedEntity.setMetadata("nodrops", (MetadataValue)new FixedMetadataValue(controller.getPlugin(), (Object)true));
        }
        if (this.speed > 0.0) {
            Vector motion = this.direction;
            motion = motion == null ? context.getDirection() : motion.clone();
            if (this.dyOffset != 0.0) {
                motion.setY(motion.getY() + this.dyOffset);
            }
            motion.normalize();
            motion.multiply(this.speed);
            CompatibilityUtils.setEntityMotion(spawnedEntity, motion);
        }
        if (this.setOwner && spawnedEntity instanceof Creature) {
            spawnedEntity.setMetadata("owner", (MetadataValue)new FixedMetadataValue(controller.getPlugin(), (Object)context.getMage().getId()));
        }
        if ((shooter = context.getLivingEntity()) != null) {
            if (spawnedEntity instanceof Projectile) {
                ((Projectile)spawnedEntity).setShooter((ProjectileSource)shooter);
            } else if (spawnedEntity instanceof AreaEffectCloud) {
                ((AreaEffectCloud)spawnedEntity).setSource((ProjectileSource)shooter);
            }
        }
        if (this.tamed && spawnedEntity instanceof Tameable) {
            Tameable tameable = (Tameable)spawnedEntity;
            tameable.setTamed(true);
            Player owner = context.getMage().getPlayer();
            if (owner != null) {
                tameable.setOwner((AnimalTamer)owner);
            }
        }
        return SpellResult.CAST;
    }

    private SpellResult replaceEntity(Entity targetEntity, CastContext context) {
        context.registerModified(targetEntity);
        MageController controller = context.getController();
        Entity spawnedEntity = controller.replaceMob(targetEntity, this.entityData, this.force, this.spawnReason);
        if (spawnedEntity == null) {
            return SpellResult.FAIL;
        }
        Collection<EffectPlayer> entityEffects = context.getEffects("spawned");
        for (EffectPlayer effectPlayer : entityEffects) {
            effectPlayer.start(spawnedEntity.getLocation(), spawnedEntity, null, null);
        }
        context.registerForUndo(spawnedEntity);
        return this.modify(context, spawnedEntity);
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    @Override
    public boolean requiresTargetEntity() {
        return true;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("loot");
        parameters.add("baby");
        parameters.add("name");
        parameters.add("type");
        parameters.add("speed");
        parameters.add("reason");
        parameters.add("villager_profession");
        parameters.add("skeleton_type");
        parameters.add("ocelot_type");
        parameters.add("rabbit_type");
        parameters.add("horse_variant");
        parameters.add("horse_style");
        parameters.add("horse_color");
        parameters.add("color");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("type")) {
            for (EntityType type : EntityType.values()) {
                examples.add(type.name().toLowerCase());
            }
        } else if (parameterKey.equals("reason")) {
            for (CreatureSpawnEvent.SpawnReason type : CreatureSpawnEvent.SpawnReason.values()) {
                examples.add(type.name().toLowerCase());
            }
        } else if (parameterKey.equals("ocelot_type")) {
            for (Ocelot.Type type : Ocelot.Type.values()) {
                examples.add(type.name().toLowerCase());
            }
        } else if (parameterKey.equals("villager_profession")) {
            for (Villager.Profession profession : Villager.Profession.values()) {
                examples.add(profession.name().toLowerCase());
            }
        } else if (parameterKey.equals("rabbit_type")) {
            for (Rabbit.Type type : Rabbit.Type.values()) {
                examples.add(type.name().toLowerCase());
            }
        } else if (parameterKey.equals("horse_style")) {
            for (Horse.Style type : Horse.Style.values()) {
                examples.add(type.name().toLowerCase());
            }
        } else if (parameterKey.equals("horse_color")) {
            for (Horse.Color type : Horse.Color.values()) {
                examples.add(type.name().toLowerCase());
            }
        } else if (parameterKey.equals("color")) {
            for (DyeColor type : DyeColor.values()) {
                examples.add(type.name().toLowerCase());
            }
        } else if (parameterKey.equals("loot") || parameterKey.equals("baby") || parameterKey.equals("repeat_random")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_BOOLEANS));
        } else if (parameterKey.equals("name")) {
            examples.add("Philbert");
        } else if (parameterKey.equals("speed")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_SIZES));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

