/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.data;

import com.elmakers.mine.bukkit.api.data.MageData;
import com.elmakers.mine.bukkit.api.data.MageDataCallback;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.data.ConfigurationMageDataStore;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public abstract class SQLMageDataStore
extends ConfigurationMageDataStore {
    private Connection connection;
    private final Object lockingLock = new Object();
    private int lockTimeout = 0;
    private int lockRetry = 0;

    @Nonnull
    protected abstract Connection createConnection() throws SQLException;

    @Override
    public void initialize(MageController controller, ConfigurationSection configuration) {
        super.initialize(controller, configuration);
        this.lockTimeout = configuration.getInt("lock_timeout", 5000);
        this.lockRetry = configuration.getInt("lock_retry", 100);
        if (this.lockRetry < 2) {
            this.lockRetry = 2;
        }
    }

    @Nonnull
    protected Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.connection = this.createConnection();
            this.checkSchema();
        }
        return this.connection;
    }

    public String getTextFieldType() {
        return "TEXT";
    }

    protected void checkSchema() throws SQLException {
        if (!this.tableExists("mage")) {
            this.controller.getLogger().info("Creating table: mage");
            String sql = "CREATE TABLE IF NOT EXISTS `mage` (`id` varchar(64) NOT NULL,`data` " + this.getTextFieldType() + ",`locked` tinyint default 0,`migrated` tinyint default 0,PRIMARY KEY  (`id`)) ;";
            this.execute(sql);
        }
    }

    public void execute(String query) throws SQLException {
        try (Statement statement = this.getConnection().createStatement();){
            statement.execute(query);
        }
    }

    public boolean tableExists(String table) throws SQLException {
        ResultSet tableData = this.getConnection().getMetaData().getTables(null, null, table, null);
        return tableData.next();
    }

    public boolean columnExists(String table, String column) throws SQLException {
        ResultSet columnData = this.getConnection().getMetaData().getColumns(null, null, table, column);
        return columnData.next();
    }

    @Override
    @Deprecated
    public void save(MageData mage, MageDataCallback callback) {
        this.save(mage, callback, false);
    }

    @Override
    public void save(MageData mage, MageDataCallback callback, boolean releaseLock) {
        YamlConfiguration serialized = new YamlConfiguration();
        this.save(mage, (ConfigurationSection)serialized);
        try {
            PreparedStatement insert = this.getConnection().prepareStatement("REPLACE INTO mage (id, data) VALUES (?, ?)");
            insert.setString(1, mage.getId());
            insert.setString(2, serialized.saveToString());
            insert.execute();
        }
        catch (Exception ex) {
            this.controller.getLogger().log(Level.SEVERE, "Error saving player " + mage.getId(), ex);
        }
        if (releaseLock) {
            this.releaseLock(mage);
        }
        if (callback != null) {
            callback.run(mage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseLock(MageData mage) {
        Object object = this.lockingLock;
        synchronized (object) {
            try {
                PreparedStatement release = this.getConnection().prepareStatement("UPDATE mage SET locked = 0 WHERE id = ?");
                release.setString(1, mage.getId());
                release.execute();
                this.controller.info("Released lock for " + mage.getId() + " at " + System.currentTimeMillis());
            }
            catch (Exception ex) {
                this.controller.getLogger().log(Level.WARNING, "Unable to release lock for " + mage.getId(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void obtainLock(String id) {
        Object object = this.lockingLock;
        synchronized (object) {
            boolean hasLock = false;
            long start = System.currentTimeMillis();
            try {
                PreparedStatement lockLookup = this.getConnection().prepareStatement("SELECT locked FROM mage WHERE id = ?");
                while (!hasLock) {
                    lockLookup.setString(1, id);
                    ResultSet results = lockLookup.executeQuery();
                    hasLock = results.next() ? !results.getBoolean(1) : true;
                    if (hasLock) continue;
                    if (System.currentTimeMillis() > start + (long)this.lockTimeout) {
                        this.controller.getLogger().log(Level.WARNING, "Lock timeout while waiting for mage " + id + ", claiming lock");
                        break;
                    }
                    Thread.sleep(this.lockRetry);
                }
                PreparedStatement lock = this.getConnection().prepareStatement("UPDATE mage SET locked = 1 WHERE id = ?");
                lock.setString(1, id);
                lock.execute();
            }
            catch (Exception ex) {
                this.controller.getLogger().log(Level.WARNING, "Could not obtain lock for mage " + id, ex);
            }
        }
    }

    @Override
    public void load(String id, MageDataCallback callback) {
        this.obtainLock(id);
        MageData data = null;
        try {
            PreparedStatement loadQuery = this.getConnection().prepareStatement("SELECT data FROM mage WHERE id = ?");
            loadQuery.setString(1, id);
            ResultSet results = loadQuery.executeQuery();
            if (results.next()) {
                YamlConfiguration saveFile = new YamlConfiguration();
                saveFile.loadFromString(results.getString(1));
                data = this.load(id, (ConfigurationSection)saveFile);
            }
        }
        catch (Exception ex) {
            this.controller.getLogger().log(Level.SEVERE, "Error loading player " + id, ex);
        }
        if (callback != null) {
            callback.run(data);
        }
    }

    @Override
    public void delete(String id) {
        try {
            PreparedStatement delete = this.getConnection().prepareStatement("DELETE FROM mage WHERE id = ?");
            delete.setString(1, id);
            delete.execute();
        }
        catch (Exception ex) {
            this.controller.getLogger().log(Level.WARNING, "Unable to delete mage " + id, ex);
        }
    }

    @Override
    public Collection<String> getAllIds() {
        ArrayList<String> ids = new ArrayList<String>();
        try {
            PreparedStatement idsQuery = this.getConnection().prepareStatement("SELECT id FROM mage WHERE migrated = 0");
            ResultSet idResults = idsQuery.executeQuery();
            while (idResults.next()) {
                ids.add(idResults.getString(1));
            }
        }
        catch (Exception ex) {
            this.controller.getLogger().log(Level.WARNING, "Unable to lookup all mage ids", ex);
        }
        return ids;
    }

    @Override
    public void migrate(String id) {
        try {
            PreparedStatement migrate = this.getConnection().prepareStatement("UPDATE mage SET migrated = 1 WHERE id = ?");
            migrate.setString(1, id);
            migrate.execute();
        }
        catch (Exception ex) {
            this.controller.getLogger().log(Level.WARNING, "Could not set mage " + id + " as migrated", ex);
        }
    }

    @Override
    public void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception ex) {
                this.controller.getLogger().log(Level.WARNING, "Error closing player data connection", ex);
            }
            this.connection = null;
        }
    }
}

