/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.api.block.ModifyType;
import com.elmakers.mine.bukkit.api.item.ItemUpdatedCallback;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.block.BlockBanner;
import com.elmakers.mine.bukkit.block.BlockCommand;
import com.elmakers.mine.bukkit.block.BlockExtraData;
import com.elmakers.mine.bukkit.block.BlockMobSpawner;
import com.elmakers.mine.bukkit.block.BlockSign;
import com.elmakers.mine.bukkit.block.BlockSkull;
import com.elmakers.mine.bukkit.block.BlockTileEntity;
import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.block.LeatherArmorData;
import com.elmakers.mine.bukkit.block.PotionData;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.DeprecatedUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.elmakers.mine.bukkit.utility.SkinUtils;
import com.elmakers.mine.bukkit.utility.SkullLoadedCallback;
import com.google.common.base.Objects;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.SkullType;
import org.bukkit.block.Banner;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.CommandBlock;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Sign;
import org.bukkit.block.Skull;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class MaterialAndData
implements com.elmakers.mine.bukkit.api.block.MaterialAndData {
    protected static Gson gson;
    protected Material material;
    protected Short data;
    protected Map<String, Object> tags;
    protected BlockExtraData extraData;
    protected String blockData;
    protected boolean isValid = true;
    public static final Material DEFAULT_MATERIAL;

    public MaterialAndData() {
        this.material = DEFAULT_MATERIAL;
        this.data = 0;
    }

    public MaterialAndData(Material material) {
        this.material = material;
        this.data = 0;
    }

    public MaterialAndData(Material material, String blockData) {
        this.material = material;
        this.blockData = blockData;
    }

    public MaterialAndData(Material material, short data) {
        this.material = material;
        this.data = data;
    }

    public MaterialAndData(ItemStack item) {
        int customModelData;
        ItemMeta meta;
        this.material = item.getType();
        this.data = item.getDurability();
        if (DefaultMaterials.isPlayerSkull(this)) {
            meta = item.getItemMeta();
            Object profile = InventoryUtils.getSkullProfile(meta);
            this.extraData = new BlockSkull(profile);
        } else if (DefaultMaterials.isBanner(this.material)) {
            meta = item.getItemMeta();
            if (meta != null && meta instanceof BannerMeta) {
                BannerMeta banner = (BannerMeta)meta;
                this.extraData = new BlockBanner(banner.getPatterns(), DeprecatedUtils.getBaseColor(banner));
            }
        } else if (this.material == Material.LEATHER_BOOTS || this.material == Material.LEATHER_CHESTPLATE || this.material == Material.LEATHER_HELMET || this.material == Material.LEATHER_LEGGINGS) {
            meta = item.getItemMeta();
            if (meta != null && meta instanceof LeatherArmorMeta) {
                this.extraData = new LeatherArmorData(((LeatherArmorMeta)meta).getColor());
            }
        } else if (this.material == Material.POTION && (meta = item.getItemMeta()) != null && meta instanceof PotionMeta) {
            this.extraData = new PotionData(CompatibilityUtils.getColor((PotionMeta)meta));
        }
        if (item.hasItemMeta() && (customModelData = InventoryUtils.getMetaInt(item = InventoryUtils.makeReal(item), "CustomModelData", 0)) > 0) {
            this.tags = new HashMap<String, Object>();
            this.tags.put("CustomModelData", customModelData);
        }
    }

    public MaterialAndData(Block block) {
        this.updateFrom(block);
    }

    public MaterialAndData(com.elmakers.mine.bukkit.api.block.MaterialAndData other) {
        this.updateFrom(other);
    }

    public MaterialAndData(String materialKey) {
        this();
        this.update(materialKey);
    }

    private static Gson getGson() {
        if (gson == null) {
            gson = new Gson();
        }
        return gson;
    }

    public void update(String materialKey) {
        Object blockData;
        BlockExtraData extraData;
        Material material;
        Short data;
        block46: {
            String[] pieces;
            block45: {
                MaterialAndData skullData;
                int jsonStart;
                if (materialKey == null || materialKey.length() == 0) {
                    this.isValid = false;
                    return;
                }
                String[] blockPieces = StringUtils.split((String)materialKey, (String)"?");
                if (blockPieces.length > 1) {
                    materialKey = blockPieces[0];
                    this.blockData = blockPieces[1];
                }
                if ((jsonStart = materialKey.indexOf(123)) > 0) {
                    String fullKey = materialKey;
                    materialKey = fullKey.substring(0, jsonStart);
                    String json = fullKey.substring(jsonStart);
                    try {
                        JsonReader reader = new JsonReader((Reader)new StringReader(json));
                        reader.setLenient(true);
                        this.tags = (Map)MaterialAndData.getGson().fromJson(reader, Map.class);
                        InventoryUtils.convertIntegers(this.tags);
                    }
                    catch (Throwable ex) {
                        Bukkit.getLogger().warning("[Magic] Error parsing item json: " + json + " : " + ex.getMessage());
                    }
                }
                pieces = MaterialAndData.splitMaterialKey(materialKey);
                data = 0;
                material = null;
                extraData = null;
                blockData = null;
                materialKey = pieces[0];
                if ((materialKey.equalsIgnoreCase("skull") || materialKey.equalsIgnoreCase("skull_item")) && (skullData = DefaultMaterials.getPlayerSkullItem()) != null) {
                    material = skullData.material;
                    data = skullData.data;
                }
                if (material == null) {
                    try {
                        if (pieces.length <= 0 || materialKey.equals("*")) break block45;
                        try {
                            Integer id = Integer.parseInt(materialKey);
                            material = CompatibilityUtils.getMaterial(id);
                        }
                        catch (Exception ex) {
                            materialKey = materialKey.toUpperCase();
                            material = Material.getMaterial((String)materialKey);
                            if (material != null) break block45;
                            byte legacyData = 0;
                            if (pieces.length > 1) {
                                try {
                                    legacyData = Byte.parseByte(pieces[1]);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (legacyData > 0 && (material = Material.getMaterial((String)("LEGACY_" + materialKey.toUpperCase()))) != null) {
                                material = CompatibilityUtils.migrateMaterial(material, legacyData);
                            }
                            if (material == null) {
                                material = CompatibilityUtils.getLegacyMaterial(materialKey);
                            }
                        }
                    }
                    catch (Exception ex) {
                        material = null;
                    }
                }
            }
            try {
                if (pieces.length <= 1) break block46;
                String dataString = pieces[1];
                if (dataString.equals("*")) {
                    data = null;
                    break block46;
                }
                if (DefaultMaterials.isMobSpawner(material)) {
                    extraData = new BlockMobSpawner(dataString);
                    break block46;
                }
                if (DefaultMaterials.isSkull(material)) {
                    if (dataString.contains(":")) {
                        data = 3;
                        this.material = material;
                        this.data = data;
                        ItemStack item = this.getItemStack(1);
                        item = InventoryUtils.setSkullURL(item, dataString);
                        extraData = new BlockSkull(InventoryUtils.getSkullProfile(item.getItemMeta()));
                    } else {
                        try {
                            data = Short.parseShort(dataString);
                        }
                        catch (Exception ex) {
                            data = 3;
                            extraData = new BlockSkull(dataString);
                        }
                    }
                    break block46;
                }
                if (DefaultMaterials.isBanner(material)) {
                    DyeColor color = null;
                    try {
                        short colorIndex = Short.parseShort(dataString);
                        data = colorIndex;
                        color = DyeColor.values()[colorIndex];
                    }
                    catch (Exception ex) {
                        color = null;
                    }
                    if (color != null) {
                        extraData = new BlockBanner(color);
                    }
                    break block46;
                }
                if (material == Material.LEATHER_BOOTS || material == Material.LEATHER_CHESTPLATE || material == Material.LEATHER_HELMET || material == Material.LEATHER_LEGGINGS) {
                    StringUtils.split((String)dataString, (char)',');
                    for (String piece : pieces) {
                        if (piece.startsWith("#")) {
                            try {
                                Color color = Color.fromRGB((int)Integer.parseInt(piece.substring(1), 16));
                                extraData = new LeatherArmorData(color);
                            }
                            catch (Exception ex) {
                                extraData = null;
                            }
                            continue;
                        }
                        try {
                            data = Short.parseShort(dataString);
                        }
                        catch (Exception ex) {
                            data = 0;
                        }
                    }
                    break block46;
                }
                if (material == Material.POTION) {
                    String color = dataString;
                    if (color.startsWith("#")) {
                        color = color.substring(1);
                    }
                    try {
                        Color potionColor = Color.fromRGB((int)Integer.parseInt(color, 16));
                        extraData = new PotionData(potionColor);
                    }
                    catch (Exception ex) {
                        extraData = null;
                    }
                    break block46;
                }
                try {
                    data = Short.parseShort(dataString);
                }
                catch (Exception ex) {
                    data = 0;
                }
            }
            catch (Exception ex) {
                material = null;
            }
        }
        if (material == null) {
            this.setMaterial(null, null);
            this.isValid = false;
        } else {
            this.setMaterial(material, data);
        }
        if (this.isValid) {
            this.extraData = extraData;
            this.blockData = blockData;
        }
    }

    public int hashCode() {
        return (this.material == null ? -1 : this.material.ordinal() << 16) | (this.data == null ? -1 : (int)this.data.shortValue());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof com.elmakers.mine.bukkit.api.block.MaterialAndData)) {
            return false;
        }
        com.elmakers.mine.bukkit.api.block.MaterialAndData other = (com.elmakers.mine.bukkit.api.block.MaterialAndData)obj;
        return Objects.equal((Object)other.getData(), (Object)this.data) && other.getMaterial() == this.material;
    }

    @Override
    public void updateFrom(com.elmakers.mine.bukkit.api.block.MaterialAndData other) {
        this.material = other.getMaterial();
        this.data = other.getData();
        if (other instanceof MaterialAndData) {
            MaterialAndData o = (MaterialAndData)other;
            this.extraData = o.extraData != null ? o.extraData.clone() : null;
            this.blockData = o.blockData;
            this.isValid = o.isValid;
            if (o.tags != null) {
                this.tags = new HashMap<String, Object>(o.tags);
            }
        }
    }

    @Override
    public void updateFrom(Block block) {
        this.updateFromBlock(block, null);
    }

    @Override
    public void setMaterial(Material material, short data) {
        this.setMaterial(material, (Short)data);
    }

    public void setMaterial(Material material, Short data) {
        this.material = material;
        this.data = data;
        this.extraData = null;
        this.blockData = null;
        if (material != null && CompatibilityUtils.isLegacy(material)) {
            short convertData = this.data == null ? (short)0 : this.data;
            this.material = material = CompatibilityUtils.migrateMaterial(material, (byte)convertData);
        }
        this.isValid = material != null;
    }

    @Override
    public void setMaterial(Material material) {
        this.setMaterial(material, (short)0);
    }

    public void setMaterialId(int id) {
        this.material = CompatibilityUtils.getMaterial(id);
    }

    public void updateFromBlock(Block block, @Nullable MaterialSet restrictedMaterials) {
        Material blockMaterial;
        if (block == null) {
            this.isValid = false;
            return;
        }
        if (!block.getChunk().isLoaded()) {
            block.getChunk().load(true);
            return;
        }
        if (restrictedMaterials != null && restrictedMaterials.testBlock(block)) {
            this.isValid = false;
            return;
        }
        this.extraData = null;
        this.material = blockMaterial = block.getType();
        this.data = block.getData();
        try {
            BlockState blockState = block.getState();
            if (this.material == Material.FLOWER_POT || blockState instanceof InventoryHolder || blockState instanceof Sign) {
                this.extraData = new BlockTileEntity(NMSUtils.getTileEntityData(block.getLocation()));
            } else if (blockState instanceof CommandBlock) {
                CommandBlock command = (CommandBlock)blockState;
                this.extraData = new BlockCommand(command.getCommand(), command.getName());
            } else if (blockState instanceof Skull) {
                Skull skull = (Skull)blockState;
                if (!NMSUtils.isCurrentVersion()) {
                    this.data = (short)skull.getSkullType().ordinal();
                }
                this.extraData = new BlockSkull(InventoryUtils.getSkullProfile(skull), skull.getRotation());
            } else if (blockState instanceof CreatureSpawner) {
                CreatureSpawner spawner = (CreatureSpawner)blockState;
                this.extraData = new BlockMobSpawner(spawner.getCreatureTypeName());
            } else if (DefaultMaterials.isBanner(blockMaterial) && blockState != null && blockState instanceof Banner) {
                Banner banner = (Banner)blockState;
                DyeColor color = banner.getBaseColor();
                this.extraData = new BlockBanner(banner.getPatterns(), color);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.blockData = CompatibilityUtils.getBlockData(block);
        if (this.blockData != null) {
            this.data = 0;
            if (!this.blockData.contains("[")) {
                this.blockData = null;
            }
        }
        this.isValid = true;
    }

    public static void clearItems(BlockState block) {
        if (block != null && (block instanceof InventoryHolder || block.getType() == Material.FLOWER_POT)) {
            NMSUtils.clearItems(block.getLocation());
        }
    }

    public void modifyFast(Block block) {
        short data;
        Material material = this.material == null ? block.getType() : this.material;
        short s = data = this.data == null ? block.getData() : this.data.shortValue();
        if (material != block.getType() || data != block.getData()) {
            CompatibilityUtils.setBlockFast(block, material, data);
        }
    }

    @Override
    public void modify(Block block) {
        this.modify(block, false);
    }

    @Override
    public void modify(Block block, ModifyType modifyType) {
        switch (modifyType) {
            case FAST: {
                this.modifyFast(block);
                break;
            }
            case NORMAL: {
                this.modify(block, true);
                break;
            }
            case NO_PHYSICS: {
                this.modify(block, false);
            }
        }
    }

    @Override
    public void modify(Block block, boolean applyPhysics) {
        if (!this.isValid) {
            return;
        }
        try {
            BlockState blockState = block.getState();
            if (this.material != null) {
                byte blockData;
                byte by = blockData = this.data != null ? (byte)this.data.shortValue() : block.getData();
                if (this.material == Material.AIR) {
                    MaterialAndData.clearItems(blockState);
                }
                DeprecatedUtils.setTypeAndData(block, this.material, blockData, applyPhysics);
                if (this.blockData != null) {
                    CompatibilityUtils.setBlockData(Bukkit.getServer(), block, this.blockData);
                }
                blockState = block.getState();
            }
            if (blockState != null && blockState instanceof CommandBlock && this.extraData != null && this.extraData instanceof BlockCommand) {
                CommandBlock command = (CommandBlock)blockState;
                BlockCommand commandData = (BlockCommand)this.extraData;
                command.setCommand(commandData.command);
                if (commandData.customName != null) {
                    command.setName(commandData.customName);
                }
                command.update();
            } else if (this.extraData != null && this.extraData instanceof BlockTileEntity) {
                NMSUtils.setTileEntityData(block.getLocation(), ((BlockTileEntity)this.extraData).data);
            } else if (blockState != null && DefaultMaterials.isBanner(this.material) && this.extraData != null && this.extraData instanceof BlockBanner) {
                if (blockState instanceof Banner) {
                    BlockBanner bannerData = (BlockBanner)this.extraData;
                    Banner banner = (Banner)blockState;
                    if (bannerData.patterns != null) {
                        banner.setPatterns(bannerData.patterns);
                    }
                    if (bannerData.baseColor != null) {
                        banner.setBaseColor(bannerData.baseColor);
                    }
                }
                blockState.update(true, false);
            } else if (blockState != null && blockState instanceof Skull && this.extraData != null && this.extraData instanceof BlockSkull) {
                Skull skull = (Skull)blockState;
                BlockSkull skullData = (BlockSkull)this.extraData;
                if (this.data != null && this.data != 0 && !NMSUtils.isCurrentVersion()) {
                    skull.setSkullType(SkullType.values()[this.data]);
                }
                if (skullData.rotation != null && skullData.rotation != BlockFace.SELF) {
                    skull.setRotation(skullData.rotation);
                }
                if (skullData.profile != null) {
                    InventoryUtils.setSkullProfile(skull, skullData.profile);
                    skull.update(true, false);
                } else if (skullData.playerName != null) {
                    DeprecatedUtils.setOwner(skull, skullData.playerName);
                }
            } else if (blockState != null && blockState instanceof CreatureSpawner && this.extraData != null && this.extraData instanceof BlockMobSpawner) {
                BlockMobSpawner spawnerData = (BlockMobSpawner)this.extraData;
                if (spawnerData.mobName != null && !spawnerData.mobName.isEmpty()) {
                    CreatureSpawner spawner = (CreatureSpawner)blockState;
                    spawner.setCreatureTypeByName(spawnerData.mobName);
                    spawner.update();
                }
            } else if (blockState != null && blockState instanceof Sign && this.extraData != null && this.extraData instanceof BlockSign) {
                BlockSign signData = (BlockSign)this.extraData;
                Sign sign = (Sign)blockState;
                for (int i = 0; i < signData.lines.length; ++i) {
                    sign.setLine(i, signData.lines[i]);
                }
                sign.update();
            }
        }
        catch (Exception ex) {
            Bukkit.getLogger().warning("[Magic] Error updating block state");
            ex.printStackTrace();
        }
    }

    @Override
    public Short getData() {
        return this.data;
    }

    @Override
    @Nullable
    public Byte getBlockData() {
        return this.data == null ? null : Byte.valueOf((byte)this.data.shortValue());
    }

    @Override
    public Material getMaterial() {
        return this.material;
    }

    @Override
    public String getKey() {
        return this.getKey(this.data);
    }

    public String getKey(Short data) {
        String materialKey;
        String string = materialKey = this.material == null ? "*" : this.material.name().toLowerCase();
        if (data == null) {
            materialKey = materialKey + ":*";
        } else if (DefaultMaterials.isPlayerSkull(this) && this.extraData != null && this.extraData instanceof BlockSkull) {
            BlockSkull skullData = (BlockSkull)this.extraData;
            if (skullData.playerName != null) {
                materialKey = materialKey + ":" + skullData.playerName;
            } else {
                String profileURL = SkinUtils.getProfileURL(skullData.profile);
                if (profileURL != null) {
                    materialKey = materialKey + ":" + profileURL;
                }
            }
        } else if (DefaultMaterials.isMobSpawner(this.material) && this.extraData != null && this.extraData instanceof BlockMobSpawner) {
            BlockMobSpawner spawnerData = (BlockMobSpawner)this.extraData;
            if (spawnerData.mobName != null && !spawnerData.mobName.isEmpty()) {
                materialKey = materialKey + ":" + spawnerData.mobName;
            }
        } else if (DefaultMaterials.isBanner(this.material) && this.extraData != null && this.extraData instanceof BlockBanner && ((BlockBanner)this.extraData).baseColor != null) {
            materialKey = materialKey + ":" + ((BlockBanner)this.extraData).baseColor.ordinal();
        } else if (this.material == Material.LEATHER_BOOTS || this.material == Material.LEATHER_CHESTPLATE || this.material == Material.LEATHER_HELMET || this.material == Material.LEATHER_LEGGINGS) {
            if (data != 0) {
                materialKey = materialKey + ":" + data;
            }
            if (this.extraData != null && this.extraData instanceof LeatherArmorData) {
                Color color = ((LeatherArmorData)this.extraData).getColor();
                materialKey = data != 0 ? materialKey + ",#" + Integer.toHexString(color.asRGB()) : materialKey + ":#" + Integer.toHexString(color.asRGB());
            }
        } else if (this.material == Material.POTION) {
            Color color;
            if (this.extraData != null && this.extraData instanceof PotionData && (color = ((PotionData)this.extraData).getColor()) != null) {
                materialKey = materialKey + ":" + Integer.toHexString(color.asRGB());
            }
        } else if (data != 0) {
            materialKey = materialKey + ":" + data;
        }
        if (this.blockData != null) {
            materialKey = materialKey + "?" + this.blockData;
        }
        if (this.tags != null) {
            materialKey = materialKey + MaterialAndData.getGson().toJson(this.tags);
        }
        return materialKey;
    }

    public String getWildDataKey() {
        return this.getKey(null);
    }

    @Override
    public boolean is(Block block) {
        if (NMSUtils.isCurrentVersion()) {
            return this.material == block.getType();
        }
        return this.material == block.getType() && this.data.shortValue() == block.getData();
    }

    @Override
    public boolean isDifferent(Block block) {
        String currentData;
        CommandBlock command;
        Material blockMaterial = block.getType();
        if (this.material != null && blockMaterial != this.material) {
            return true;
        }
        if (!NMSUtils.isCurrentVersion()) {
            byte blockData = block.getData();
            if (this.data != null && blockData != this.data) {
                return true;
            }
        }
        if (DefaultMaterials.isBanner(this.material)) {
            return true;
        }
        BlockState blockState = block.getState();
        if (blockState instanceof Sign) {
            return true;
        }
        if (blockState instanceof CommandBlock && this.extraData != null && this.extraData instanceof BlockCommand && !(command = (CommandBlock)blockState).getCommand().equals(((BlockCommand)this.extraData).command)) {
            return true;
        }
        return this.blockData != null && ((currentData = CompatibilityUtils.getBlockData(block)) == null || !this.blockData.equals(currentData));
    }

    @Override
    @Nullable
    public ItemStack getItemStack(int amount) {
        return this.getItemStack(amount, null);
    }

    @Override
    @Nullable
    public ItemStack getItemStack(int amount, ItemUpdatedCallback callback) {
        if (this.material == null) {
            if (callback != null) {
                callback.updated(null);
            }
            return null;
        }
        Material material = this.convertToItemStackMaterial();
        MaterialAndData item = this;
        if (material != this.material) {
            item = new MaterialAndData(this);
            item.material = material;
        }
        ItemStack stack = new ItemStack(material, amount, this.data == null ? (short)0 : this.data);
        stack = item.applyToItem(stack, callback);
        return stack;
    }

    private Material convertToItemStackMaterial() {
        return DefaultMaterials.blockToItem(this.material);
    }

    @Override
    public ItemStack applyToItem(ItemStack stack) {
        return this.applyToItem(stack, null);
    }

    @Override
    public ItemStack applyToItem(ItemStack stack, final ItemUpdatedCallback callback) {
        boolean asynchronous = false;
        stack.setType(this.material);
        if (this.data != null) {
            stack.setDurability(this.data.shortValue());
        }
        if (this.tags != null) {
            stack = InventoryUtils.makeReal(stack);
            InventoryUtils.saveTagsToItem(this.tags, stack);
        }
        if (DefaultMaterials.isPlayerSkull(this)) {
            ItemMeta meta = stack.getItemMeta();
            if (meta != null && meta instanceof SkullMeta && this.extraData != null && this.extraData instanceof BlockSkull) {
                BlockSkull skullData = (BlockSkull)this.extraData;
                if (skullData.profile != null) {
                    SkullMeta skullMeta = (SkullMeta)meta;
                    InventoryUtils.setSkullProfile((ItemMeta)skullMeta, ((BlockSkull)this.extraData).profile);
                    stack.setItemMeta(meta);
                } else if (skullData.playerName != null) {
                    asynchronous = true;
                    SkullLoadedCallback skullCallback = null;
                    if (callback != null) {
                        skullCallback = new SkullLoadedCallback(){

                            @Override
                            public void updated(ItemStack itemStack) {
                                callback.updated(itemStack);
                            }
                        };
                    }
                    DeprecatedUtils.setSkullOwner(stack, skullData.playerName, skullCallback);
                }
            }
        } else if (DefaultMaterials.isBanner(this.material)) {
            ItemMeta meta = stack.getItemMeta();
            if (meta != null && meta instanceof BannerMeta && this.extraData != null && this.extraData instanceof BlockBanner) {
                BannerMeta banner = (BannerMeta)meta;
                BlockBanner bannerData = (BlockBanner)this.extraData;
                if (bannerData.patterns != null) {
                    banner.setPatterns(bannerData.patterns);
                }
                if (bannerData.baseColor != null) {
                    DeprecatedUtils.setBaseColor(banner, bannerData.baseColor);
                }
                stack.setItemMeta(meta);
            }
        } else if (this.material == Material.LEATHER_BOOTS || this.material == Material.LEATHER_CHESTPLATE || this.material == Material.LEATHER_HELMET || this.material == Material.LEATHER_LEGGINGS) {
            ItemMeta meta = stack.getItemMeta();
            if (this.extraData != null && this.extraData instanceof LeatherArmorData && meta != null && meta instanceof LeatherArmorMeta) {
                ((LeatherArmorMeta)meta).setColor(((LeatherArmorData)this.extraData).getColor());
                stack.setItemMeta(meta);
            }
        } else if (this.material == Material.POTION) {
            ItemMeta meta = stack.getItemMeta();
            if (this.extraData != null && this.extraData instanceof PotionData && meta != null && meta instanceof PotionMeta) {
                CompatibilityUtils.setColor((PotionMeta)meta, ((PotionData)this.extraData).getColor());
                stack.setItemMeta(meta);
            }
        }
        if (!asynchronous && callback != null) {
            callback.updated(stack);
        }
        return stack;
    }

    public static String[] splitMaterialKey(String materialKey) {
        if (materialKey.contains("|")) {
            return StringUtils.split((String)materialKey, (String)"|", (int)2);
        }
        if (materialKey.contains(":")) {
            return StringUtils.split((String)materialKey, (String)":", (int)2);
        }
        return new String[]{materialKey};
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    public static String getMaterialName(ItemStack item) {
        MaterialAndData material = new MaterialAndData(item);
        return material.getName();
    }

    public static String getMaterialName(Block block) {
        MaterialAndData material = new MaterialAndData(block);
        return material.getName();
    }

    @Override
    @Nullable
    public String getBaseName() {
        if (this.material == null) {
            return null;
        }
        return this.material.name().toLowerCase().replace('_', ' ');
    }

    @Override
    public String getName() {
        return this.getName(null);
    }

    @Override
    public String getName(Messages messages) {
        String materialName;
        if (!this.isValid()) {
            return "";
        }
        String string = materialName = this.material == null ? "?" : this.material.name();
        if (this.data == null && messages != null) {
            materialName = materialName + messages.get("material.wildcard");
        }
        materialName = materialName.toLowerCase().replace('_', ' ');
        materialName = WordUtils.capitalize((String)materialName);
        return materialName;
    }

    @Override
    public void setCustomName(String customName) {
        if (this.extraData != null && this.extraData instanceof BlockCommand) {
            ((BlockCommand)this.extraData).customName = customName;
        } else {
            this.extraData = new BlockCommand(null, customName);
        }
    }

    @Override
    public void setCommandLine(String command) {
        if (this.extraData != null && this.extraData instanceof BlockCommand) {
            ((BlockCommand)this.extraData).command = command;
        } else {
            this.extraData = new BlockCommand(command);
        }
    }

    @Override
    @Nullable
    public String getCommandLine() {
        if (this.extraData != null && this.extraData instanceof BlockCommand) {
            return ((BlockCommand)this.extraData).command;
        }
        return null;
    }

    @Override
    public void setData(Short data) {
        this.data = data;
    }

    @Override
    public void setRawData(Object data) {
        this.extraData = DefaultMaterials.isSign(this.material) ? new BlockSign(data) : new BlockTileEntity(data);
    }

    public boolean matches(Material material, short data) {
        return !(this.material != null && this.material != material || this.data != null && this.data != data);
    }

    public String toString() {
        return this.isValid() ? this.material + (this.data != null && this.data != 0 ? "@" + this.data : "") : "invalid";
    }

    static {
        DEFAULT_MATERIAL = Material.AIR;
    }
}

