/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.citizens;

import com.elmakers.mine.bukkit.api.entity.EntityData;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.integration.VaultController;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.MemoryDataKey;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public abstract class CitizensTrait
extends Trait {
    private String permissionNode;
    private boolean invisible = false;
    private double cost = 0.0;
    private String mobKey;
    private ItemStack requireItem = null;
    private ItemStack hatItem;
    protected MagicAPI api;
    protected static Set<String> baseParameters = ImmutableSet.of((Object)"permission", (Object)"invisible", (Object)"cost", (Object)"mob", (Object)"requires", (Object)"hat", (Object[])new String[0]);

    protected CitizensTrait(String name) {
        super(name);
    }

    public void load(DataKey data) {
        String hatKey;
        this.permissionNode = data.getString("permission", null);
        this.invisible = data.getBoolean("invisible", false);
        this.cost = data.getDouble("cost", 0.0);
        this.mobKey = data.getString("mob");
        String itemKey = data.getString("requires");
        if (itemKey != null && itemKey.length() > 0) {
            this.requireItem = this.api.createItem(itemKey);
        }
        if ((hatKey = data.getString("hat")) != null && hatKey.length() > 0) {
            this.hatItem = this.api.createItem(hatKey);
        }
    }

    public void save(DataKey data) {
        data.setString("permission", this.permissionNode);
        data.setBoolean("invisible", this.invisible);
        data.setDouble("cost", this.cost);
        if (this.requireItem != null) {
            data.setString("requires", this.api.getItemKey(this.requireItem));
        }
        if (this.hatItem != null) {
            data.setString("hat", this.api.getItemKey(this.hatItem));
        }
        data.setString("mob", this.mobKey);
    }

    public void onRemove() {
    }

    public void onAttach() {
        this.load((DataKey)new MemoryDataKey());
        this.api = MagicPlugin.getAPI();
    }

    public void onSpawn() {
        this.updateEntity();
    }

    protected void updateEntity() {
        MageController controller;
        EntityData customEntity;
        LivingEntity li;
        Entity entity = null;
        try {
            entity = this.npc.getEntity();
        }
        catch (Exception exception) {
            // empty catch block
        }
        LivingEntity livingEntity = li = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (li != null) {
            if (this.invisible) {
                if (li instanceof ArmorStand) {
                    ((ArmorStand)li).setVisible(false);
                } else {
                    li.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 1));
                }
            } else if (li instanceof ArmorStand) {
                ((ArmorStand)li).setVisible(true);
            } else {
                li.removePotionEffect(PotionEffectType.INVISIBILITY);
            }
            if (this.hatItem != null) {
                li.getEquipment().setHelmet(this.hatItem);
            }
        }
        if (entity != null && this.mobKey != null && (customEntity = (controller = this.api.getController()).getMob(this.mobKey)) != null && controller.getRegisteredMage(entity) == null) {
            customEntity.attach(controller, entity);
        }
    }

    public abstract boolean perform(NPCRightClickEvent var1);

    @EventHandler
    public void onClick(NPCRightClickEvent event) {
        if (event.getNPC() != this.getNPC()) {
            return;
        }
        Player sender = event.getClicker();
        Player player = event.getClicker();
        if (this.permissionNode != null && !player.hasPermission(this.permissionNode)) {
            return;
        }
        if (this.cost > 0.0) {
            if (!VaultController.hasEconomy()) {
                sender.sendMessage(this.api.getMessages().get("economy.missing"));
                return;
            }
            VaultController vault = VaultController.getInstance();
            if (!vault.has(player, this.cost)) {
                sender.sendMessage(this.api.getMessages().get("economy.insufficient").replace("$cost", vault.format(this.cost)));
                return;
            }
        }
        if (this.requireItem != null && !this.api.hasItem(player, this.requireItem)) {
            sender.sendMessage(this.api.getMessages().get("economy.requires").replace("$cost", this.api.describeItem(this.requireItem)));
            return;
        }
        boolean result = this.perform(event);
        if (result && this.cost > 0.0) {
            VaultController vault = VaultController.getInstance();
            sender.sendMessage(this.api.getMessages().get("economy.deducted").replace("$cost", vault.format(this.cost)));
            vault.withdrawPlayer(player, this.cost);
        }
        if (result && this.requireItem != null) {
            sender.sendMessage(this.api.getMessages().get("economy.deducted").replace("$cost", this.api.describeItem(this.requireItem)));
            this.api.takeItem(player, this.requireItem);
        }
    }

    public void describe(CommandSender sender) {
        sender.sendMessage(ChatColor.AQUA + "Magic NPC: " + ChatColor.GOLD + this.npc.getName() + ChatColor.WHITE + "(" + ChatColor.GRAY + this.npc.getId() + ChatColor.WHITE + ")");
        String permissionDescription = this.permissionNode == null ? ChatColor.GRAY + "(None)" : ChatColor.LIGHT_PURPLE + this.permissionNode;
        sender.sendMessage(ChatColor.DARK_PURPLE + "Permission: " + permissionDescription);
        String invisibleDescription = this.invisible ? ChatColor.GREEN + "YES" : ChatColor.GRAY + "NO";
        sender.sendMessage(ChatColor.DARK_PURPLE + "Invisible: " + invisibleDescription);
        if (VaultController.hasEconomy()) {
            VaultController vault = VaultController.getInstance();
            sender.sendMessage(ChatColor.DARK_PURPLE + "Cost: " + ChatColor.GOLD + vault.format(this.cost));
        }
        if (this.requireItem != null) {
            sender.sendMessage(ChatColor.DARK_PURPLE + "Requires: " + ChatColor.GOLD + this.api.describeItem(this.requireItem));
        }
        if (this.hatItem != null) {
            sender.sendMessage(ChatColor.DARK_PURPLE + "Wearing Hat: " + ChatColor.GOLD + this.api.describeItem(this.hatItem));
        }
        if (this.mobKey != null) {
            sender.sendMessage(ChatColor.DARK_PURPLE + "Using mob profile: " + ChatColor.GOLD + this.mobKey);
        }
    }

    public void configure(CommandSender sender, String key, String value) {
        block41: {
            if (key == null) {
                return;
            }
            if (key.equalsIgnoreCase("permission")) {
                this.permissionNode = value;
                if (value == null) {
                    sender.sendMessage(ChatColor.RED + "Cleared permission node");
                } else {
                    sender.sendMessage(ChatColor.DARK_PURPLE + "Set required permission to: " + ChatColor.LIGHT_PURPLE + this.permissionNode);
                }
            } else if (key.equalsIgnoreCase("invisible")) {
                if (value == null || !value.equalsIgnoreCase("true")) {
                    sender.sendMessage(ChatColor.DARK_PURPLE + "Set NPC visible");
                    this.invisible = false;
                } else {
                    this.invisible = true;
                    sender.sendMessage(ChatColor.DARK_PURPLE + "Set NPC invisible");
                }
                this.updateEntity();
            } else if (key.equalsIgnoreCase("cost")) {
                if (value == null) {
                    sender.sendMessage(ChatColor.DARK_PURPLE + "Cleared cost");
                    this.cost = 0.0;
                } else {
                    try {
                        this.cost = Double.parseDouble(value);
                        if (VaultController.hasEconomy()) {
                            VaultController vault = VaultController.getInstance();
                            sender.sendMessage(ChatColor.DARK_PURPLE + "Set cost to: " + ChatColor.GOLD + vault.format(this.cost));
                            break block41;
                        }
                        sender.sendMessage(ChatColor.DARK_PURPLE + "Set cost to " + value);
                    }
                    catch (Exception ex) {
                        sender.sendMessage(ChatColor.RED + "Invalid cost: " + value);
                    }
                }
            } else if (key.equalsIgnoreCase("requires")) {
                if (value == null) {
                    sender.sendMessage(ChatColor.DARK_PURPLE + "Cleared item requirement");
                    this.cost = 0.0;
                } else {
                    try {
                        this.requireItem = this.api.createItem(value);
                        sender.sendMessage(ChatColor.DARK_PURPLE + "Set item requirement to " + this.api.describeItem(this.requireItem));
                    }
                    catch (Exception ex) {
                        sender.sendMessage(ChatColor.RED + "Invalid item: " + value);
                    }
                }
            } else if (key.equalsIgnoreCase("mob")) {
                MageController controller = this.api.getController();
                if (this.mobKey != null) {
                    try {
                        Mage mage;
                        Entity entity = this.npc.getEntity();
                        if (entity != null && (mage = controller.getRegisteredMage(entity)) != null) {
                            controller.removeMage(mage);
                        }
                    }
                    catch (Exception entity) {
                        // empty catch block
                    }
                }
                if (value == null) {
                    sender.sendMessage(ChatColor.DARK_PURPLE + "Cleared mob profile");
                    this.mobKey = null;
                } else {
                    EntityData customMob = controller.getMob(value);
                    if (customMob != null) {
                        this.mobKey = value;
                        this.updateEntity();
                        sender.sendMessage(ChatColor.DARK_PURPLE + "Set mob to " + this.mobKey);
                    } else {
                        sender.sendMessage(ChatColor.RED + "Invalid mob: " + value);
                    }
                }
            } else if (key.equalsIgnoreCase("hat")) {
                this.hatItem = this.api.createItem(value);
                if (this.hatItem == null) {
                    LivingEntity li;
                    sender.sendMessage(ChatColor.DARK_PURPLE + "removed hat");
                    Entity entity = null;
                    try {
                        entity = this.npc.getEntity();
                    }
                    catch (Exception customMob) {
                        // empty catch block
                    }
                    LivingEntity livingEntity = li = entity instanceof LivingEntity ? (LivingEntity)entity : null;
                    if (li != null) {
                        li.getEquipment().setHelmet(this.hatItem);
                    }
                } else {
                    try {
                        this.hatItem = this.api.createItem(value);
                        sender.sendMessage(ChatColor.DARK_PURPLE + "Set hat to " + this.api.describeItem(this.hatItem));
                        this.updateEntity();
                    }
                    catch (Exception ex) {
                        sender.sendMessage(ChatColor.RED + "Invalid item: " + value);
                    }
                }
            } else {
                sender.sendMessage(ChatColor.RED + "Not a valid configuration option- use the <tab> key for help");
            }
        }
    }
}

