/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.automata;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.automata.AutomatonTemplate;
import com.elmakers.mine.bukkit.entity.EntityData;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import com.elmakers.mine.bukkit.utility.WeightedPair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class Spawner {
    @Nonnull
    private final MageController controller;
    @Nonnull
    private final Deque<WeightedPair<String>> entityTypeProbability;
    @Nonnull
    private final Deque<WeightedPair<Integer>> countProbability;
    private final Set<String> entityNames = new HashSet<String>();
    private final Set<EntityType> entityTypes = new HashSet<EntityType>();
    private boolean randomizeYaw = false;
    private boolean randomizePitch = false;
    private final int playerRange;
    private final int minPlayers;
    private final double probability;
    private final int limit;
    private final int limitRange;
    private final int verticalRange;
    private final double radius;
    private final double verticalRadius;
    private final int locationRetry;
    private final MaterialSet passthrough;
    private final boolean track;

    public Spawner(@Nonnull MageController controller, @Nonnull AutomatonTemplate automaton, ConfigurationSection configuration) {
        this.controller = controller;
        this.entityTypeProbability = new ArrayDeque<WeightedPair<String>>();
        RandomUtils.populateStringProbabilityMap(this.entityTypeProbability, configuration, "mobs");
        if (this.entityTypeProbability.isEmpty()) {
            controller.getLogger().warning("Automaton template " + automaton.getKey() + " has a spawner with no mobs defined");
        }
        this.countProbability = new ArrayDeque<WeightedPair<Integer>>();
        RandomUtils.populateIntegerProbabilityMap(this.countProbability, configuration, "count", 0, 0, 0.0f);
        if (this.countProbability.isEmpty()) {
            this.countProbability.add(new WeightedPair<Integer>(Float.valueOf(1.0f), 1));
        }
        this.probability = configuration.getDouble("probability", 0.0);
        this.playerRange = configuration.getInt("player_range", 64);
        this.minPlayers = configuration.getInt("min_players", 1);
        this.limit = configuration.getInt("limit", 0);
        this.limitRange = configuration.getInt("limit_range", 16);
        this.verticalRange = configuration.getInt("vertical_range", 0);
        this.radius = configuration.getDouble("radius");
        this.verticalRadius = configuration.getDouble("vertical_radius");
        this.locationRetry = configuration.getInt("retries", 4);
        this.passthrough = controller.getMaterialSetManager().getMaterialSet("passthrough");
        this.randomizePitch = configuration.getBoolean("randomize_pitch", false);
        this.randomizeYaw = configuration.getBoolean("randomize_yaw", false);
        this.track = configuration.getBoolean("track", true);
    }

    private boolean isSafe(Location location) {
        Block inBlock = location.getBlock();
        Block inBlock2 = location.getBlock().getRelative(BlockFace.UP);
        Block onBlock = location.getBlock().getRelative(BlockFace.DOWN);
        return !this.passthrough.testBlock(onBlock) && this.passthrough.testBlock(inBlock) && this.passthrough.testBlock(inBlock2);
    }

    @Nullable
    private Location getSafeLocation(Location location) {
        Block onBlock = location.getBlock().getRelative(BlockFace.DOWN);
        boolean goDown = this.passthrough.testBlock(onBlock);
        for (int retry = 0; retry <= this.locationRetry; ++retry) {
            if (this.isSafe(location)) {
                return location;
            }
            if (goDown) {
                location.setY(location.getY() - 1.0);
                if (!(location.getY() <= 0.0)) continue;
                return null;
            }
            location.setY(location.getY() + 1.0);
        }
        return null;
    }

    @Nullable
    public List<Entity> spawn(Location location) {
        boolean requiresPlayers;
        if (this.entityTypeProbability.isEmpty()) {
            return null;
        }
        Random random = this.controller.getRandom();
        if (this.probability > 0.0 && random.nextDouble() > this.probability) {
            return null;
        }
        int mobCount = 0;
        boolean hasLimit = this.limit > 0 && this.limitRange > 0;
        boolean bl = requiresPlayers = this.playerRange > 0 && this.minPlayers > 0;
        if (hasLimit || requiresPlayers) {
            int range = 0;
            int playerRangeSquared = this.playerRange * this.playerRange;
            int limitRangeSquared = this.limitRange * this.limitRange;
            if (hasLimit) {
                range = this.limitRange;
            }
            if (requiresPlayers) {
                range = Math.max(this.playerRange, range);
            }
            int playerCount = 0;
            int vertical = this.verticalRange > 0 ? this.verticalRange : range;
            Collection entities = location.getWorld().getNearbyEntities(location, (double)range, (double)vertical, (double)range);
            for (Entity entity : entities) {
                if (entity instanceof Player) {
                    if (this.playerRange != range && !(entity.getLocation().distanceSquared(location) <= (double)playerRangeSquared)) continue;
                    ++playerCount;
                    continue;
                }
                if (!hasLimit || this.limitRange != range && !(entity.getLocation().distanceSquared(location) <= (double)limitRangeSquared)) continue;
                String customName = entity.getCustomName();
                if (customName == null || customName.isEmpty()) {
                    if (this.entityTypes.contains(entity.getType())) {
                        ++mobCount;
                    }
                } else if (this.entityNames.contains(customName)) {
                    ++mobCount;
                }
                if (mobCount < this.limit) continue;
                break;
            }
            if (requiresPlayers && playerCount < this.minPlayers) {
                return null;
            }
            if (hasLimit && mobCount >= this.limit) {
                return null;
            }
        }
        int count = (Integer)RandomUtils.weightedRandom(this.countProbability);
        if (hasLimit) {
            count = Math.min(count, this.limit - mobCount);
        }
        ArrayList<Entity> spawned = new ArrayList<Entity>();
        for (int num = 0; num < count; ++num) {
            Entity entity;
            Location target = location;
            if (this.radius > 0.0) {
                for (int i = 0; i < this.locationRetry + 1; ++i) {
                    target = location.clone();
                    double vertical = this.verticalRadius >= 0.0 ? this.verticalRadius : this.radius;
                    double xOffset = 2.0 * this.radius * random.nextDouble() - this.radius;
                    double yOffset = vertical > 0.0 ? 2.0 * vertical * random.nextDouble() - vertical : 0.0;
                    double zOffset = 2.0 * this.radius * random.nextDouble() - this.radius;
                    target.setX(target.getX() + xOffset);
                    target.setY(target.getY() + yOffset);
                    target.setZ(target.getZ() + zOffset);
                    target = this.getSafeLocation(target);
                    if (target != null) break;
                }
            }
            if (target == null) {
                target = location;
            }
            if (this.randomizeYaw) {
                target.setYaw(RandomUtils.getRandom().nextFloat() * 360.0f);
            }
            if (this.randomizePitch) {
                target.setPitch(RandomUtils.getRandom().nextFloat() * 180.0f - 90.0f);
            }
            String randomType = (String)RandomUtils.weightedRandom(this.entityTypeProbability);
            try {
                String customMob;
                com.elmakers.mine.bukkit.api.entity.EntityData entityData = this.controller.getMob(randomType);
                if (entityData == null) {
                    EntityType entityType = EntityType.valueOf((String)randomType.toUpperCase());
                    entityData = new EntityData(entityType);
                }
                if ((customMob = entityData.getName()) == null || customMob.isEmpty()) {
                    this.entityTypes.add(entityData.getType());
                } else {
                    this.entityNames.add(entityData.getName());
                }
                entity = entityData.spawn(this.controller, target);
            }
            catch (Throwable ex) {
                this.controller.getLogger().log(Level.WARNING, "Error spawning mob from automaton at " + location, ex);
                entity = null;
            }
            if (entity == null) continue;
            spawned.add(entity);
        }
        return this.track ? spawned : null;
    }
}

