/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CheckAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.requirements.Requirement;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.configuration.ConfigurationSection;

public class CheckRequirementsAction
extends CheckAction {
    private Collection<Requirement> requirements;
    private boolean sendMessage;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.sendMessage = parameters.getBoolean("send_message");
        this.requirements = new ArrayList<Requirement>();
        Collection<ConfigurationSection> requirementConfigurations = ConfigurationUtils.getNodeList(parameters, "requirements");
        if (requirementConfigurations != null) {
            for (ConfigurationSection requirementConfiguration : requirementConfigurations) {
                this.requirements.add(new Requirement(requirementConfiguration));
            }
        }
    }

    @Override
    protected boolean isAllowed(CastContext context) {
        String message = context.getController().checkRequirements(context, this.requirements);
        if (this.sendMessage && message != null) {
            context.getMage().sendMessage(message);
        }
        return message == null;
    }
}

