/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.wand;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.effect.EffectPlayer;
import com.elmakers.mine.bukkit.api.event.PathUpgradeEvent;
import com.elmakers.mine.bukkit.api.event.WandUpgradeEvent;
import com.elmakers.mine.bukkit.api.magic.CasterProperties;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageClass;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.Messages;
import com.elmakers.mine.bukkit.api.magic.ProgressionPath;
import com.elmakers.mine.bukkit.api.spell.PrerequisiteSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.Wand;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.WeightedPair;
import com.elmakers.mine.bukkit.wand.WandLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class WandUpgradePath
implements com.elmakers.mine.bukkit.api.wand.WandUpgradePath {
    private static Map<String, WandUpgradePath> paths = new HashMap<String, WandUpgradePath>();
    private TreeMap<Integer, WandLevel> levelMap = null;
    private Map<String, Collection<EffectPlayer>> effects = new HashMap<String, Collection<EffectPlayer>>();
    private List<String> upgradeCommands;
    private int[] levels = null;
    private final String key;
    private final WandUpgradePath parent;
    private final Set<String> spells = new HashSet<String>();
    private final Set<String> brushes = new HashSet<String>();
    private final Set<String> extraSpells = new HashSet<String>();
    private Collection<PrerequisiteSpell> requiredSpells = new HashSet<PrerequisiteSpell>();
    private Set<String> requiredSpellKeys = new HashSet<String>();
    private final Set<String> allSpells = new HashSet<String>();
    private final Set<String> allExtraSpells = new HashSet<String>();
    private final Set<String> allRequiredSpells = new HashSet<String>();
    private final Set<String> allBrushes = new HashSet<String>();
    private String upgradeKey;
    private String upgradeItemKey;
    private String name;
    private String description;
    private String followsPath;
    private Set<String> tags;
    private boolean hidden = false;
    private boolean earnsSP = true;
    private com.elmakers.mine.bukkit.block.MaterialAndData icon;
    private com.elmakers.mine.bukkit.block.MaterialAndData migrateIcon;
    private boolean matchSpellMana = true;
    private int maxUses = 500;
    private int maxMaxMana = 0;
    private int maxManaRegeneration = 0;
    private int maxMana = 0;
    private int manaRegeneration = 0;
    private Map<String, Double> maxProperties = new HashMap<String, Double>();
    private static Set<String> resolvingKeys = new LinkedHashSet<String>();
    private int minLevel = 1;
    private int maxLevel = 1;
    private float bonusLevelMultiplier = 0.5f;

    public WandUpgradePath(MageController controller, String key, WandUpgradePath inherit, ConfigurationSection template) {
        this.parent = inherit;
        this.key = key;
        this.levels = inherit.levels;
        this.maxMaxMana = inherit.maxMaxMana;
        this.maxManaRegeneration = inherit.maxManaRegeneration;
        this.maxProperties.putAll(inherit.maxProperties);
        this.minLevel = inherit.minLevel;
        this.maxLevel = inherit.maxLevel;
        this.matchSpellMana = inherit.matchSpellMana;
        this.earnsSP = inherit.earnsSP;
        this.levelMap = new TreeMap<Integer, WandLevel>((SortedMap<Integer, WandLevel>)inherit.levelMap);
        this.icon = inherit.icon;
        this.migrateIcon = inherit.migrateIcon;
        this.maxMana = inherit.maxMana;
        this.manaRegeneration = inherit.manaRegeneration;
        this.effects.putAll(inherit.effects);
        this.allRequiredSpells.addAll(inherit.allRequiredSpells);
        this.allSpells.addAll(inherit.allSpells);
        this.allExtraSpells.addAll(inherit.allExtraSpells);
        this.allBrushes.addAll(inherit.allBrushes);
        if (inherit.tags != null && !inherit.tags.isEmpty()) {
            this.tags = new HashSet<String>(inherit.tags);
        }
        this.load(controller, key, template);
        if ((this.upgradeCommands == null || this.upgradeCommands.size() == 0) && inherit.upgradeCommands != null) {
            this.upgradeCommands = new ArrayList<String>();
            this.upgradeCommands.addAll(inherit.upgradeCommands);
        }
    }

    public WandUpgradePath(MageController controller, String key, ConfigurationSection template) {
        this.key = key;
        this.parent = null;
        this.tags = null;
        this.load(controller, key, template);
    }

    protected void load(MageController controller, String key, ConfigurationSection template) {
        List<String> tagList;
        Collection<PrerequisiteSpell> pathSpells = ConfigurationUtils.getPrerequisiteSpells(controller, template, "spells", "path " + key, true);
        for (PrerequisiteSpell prerequisiteSpell : pathSpells) {
            this.spells.add(prerequisiteSpell.getSpellKey().getKey());
        }
        this.allSpells.addAll(this.spells);
        Collection<PrerequisiteSpell> pathExtraSpells = ConfigurationUtils.getPrerequisiteSpells(controller, template, "extra_spells", "path " + key, true);
        for (PrerequisiteSpell prerequisiteSpell : pathExtraSpells) {
            this.extraSpells.add(prerequisiteSpell.getSpellKey().getKey());
        }
        this.allExtraSpells.addAll(this.extraSpells);
        this.brushes.addAll(ConfigurationUtils.getKeysOrList(template, "brushes"));
        this.allBrushes.addAll(this.brushes);
        this.followsPath = template.getString("follows");
        this.upgradeKey = template.getString("upgrade");
        this.upgradeItemKey = template.getString("upgrade_item");
        Collection<PrerequisiteSpell> collection = ConfigurationUtils.getPrerequisiteSpells(controller, template, "required_spells", "path " + key, false);
        this.requiredSpells = new ArrayList<PrerequisiteSpell>(pathSpells.size() + collection.size());
        this.requiredSpells.addAll(pathSpells);
        this.requiredSpells.addAll(collection);
        this.requiredSpellKeys = new HashSet<String>(collection.size());
        for (PrerequisiteSpell prereq : collection) {
            this.requiredSpellKeys.add(prereq.getSpellKey().getKey());
            this.allRequiredSpells.add(prereq.getSpellKey().getKey());
        }
        this.icon = ConfigurationUtils.getMaterialAndData(template, "icon");
        this.migrateIcon = ConfigurationUtils.getMaterialAndData(template, "migrate_icon");
        for (PrerequisiteSpell requiredSpell : this.requiredSpells) {
            SpellTemplate spell = controller.getSpellTemplate(requiredSpell.getSpellKey().getKey());
            if (spell != null) continue;
            controller.getLogger().warning("Invalid spell required for upgrade: " + requiredSpell.getSpellKey().getKey() + ", upgrade path " + key + " will disable upgrades");
            this.upgradeKey = null;
        }
        this.matchSpellMana = template.getBoolean("match_spell_mana", this.matchSpellMana);
        this.hidden = template.getBoolean("hidden", false);
        this.earnsSP = template.getBoolean("earns_sp", this.earnsSP);
        Messages messages = controller.getMessages();
        this.name = template.getString("name", this.name);
        this.name = messages.get("paths." + key + ".name", this.name);
        this.description = template.getString("description", this.description);
        this.description = messages.get("paths." + key + ".description", this.description);
        this.upgradeCommands = template.getStringList("upgrade_commands");
        if (template.contains("effects")) {
            this.effects.clear();
            ConfigurationSection effectsNode = template.getConfigurationSection("effects");
            Set effectKeys = effectsNode.getKeys(false);
            Iterator iterator = effectKeys.iterator();
            while (iterator.hasNext()) {
                String effectKey = (String)iterator.next();
                if (effectsNode.isString(effectKey)) {
                    String referenceKey = effectsNode.getString(effectKey);
                    if (!this.effects.containsKey(referenceKey)) continue;
                    this.effects.put(effectKey, new ArrayList<EffectPlayer>(this.effects.get(referenceKey)));
                    continue;
                }
                this.effects.put(effectKey, controller.loadEffects(effectsNode, effectKey));
            }
        }
        this.maxUses = template.getInt("max_uses", this.maxUses);
        this.maxMaxMana = template.getInt("max_mana", this.maxMaxMana);
        this.maxManaRegeneration = template.getInt("max_mana_regeneration", this.maxManaRegeneration);
        this.maxMana = template.getInt("mana_max", this.maxMana);
        this.manaRegeneration = template.getInt("mana_regeneration", this.manaRegeneration);
        this.minLevel = template.getInt("min_enchant_level", this.minLevel);
        this.maxLevel = template.getInt("max_enchant_level", this.maxLevel);
        ConfigurationSection maxConfig = template.getConfigurationSection("max_properties");
        if (maxConfig != null) {
            for (String maxKey : maxConfig.getKeys(false)) {
                double value = maxConfig.getDouble(maxKey);
                this.maxProperties.put(maxKey.replace("|", "."), value);
            }
        }
        if ((tagList = ConfigurationUtils.getStringList(template, "tags")) != null && !tagList.isEmpty()) {
            if (this.tags == null) {
                this.tags = new HashSet<String>(tagList);
            } else {
                this.tags.addAll(tagList);
            }
        }
        if (this.levelMap == null) {
            this.levelMap = new TreeMap();
        }
        if (template.contains("levels")) {
            String[] levelStrings = StringUtils.split((String)template.getString("levels"), (char)',');
            this.levels = new int[levelStrings.length];
            for (int i = 0; i < this.levels.length; ++i) {
                this.levels[i] = Integer.parseInt(levelStrings[i]);
            }
        }
        if (this.levels == null) {
            this.levels = new int[1];
            this.levels[0] = 1;
        }
        for (int level = 1; level <= this.levels[this.levels.length - 1]; ++level) {
            int levelIndex;
            int nextLevelIndex = 0;
            float distance = 1.0f;
            for (levelIndex = 0; levelIndex < this.levels.length; ++levelIndex) {
                if (level == this.levels[levelIndex] || levelIndex == this.levels.length - 1) {
                    nextLevelIndex = levelIndex;
                    distance = 0.0f;
                    break;
                }
                if (level >= this.levels[levelIndex + 1]) continue;
                nextLevelIndex = levelIndex + 1;
                int previousLevel = this.levels[levelIndex];
                int nextLevel = this.levels[nextLevelIndex];
                distance = (float)(level - previousLevel) / (float)(nextLevel - previousLevel);
                break;
            }
            WandLevel wandLevel = this.levelMap.get(level);
            WandLevel newLevel = new WandLevel(this, controller, template, levelIndex, nextLevelIndex, distance);
            if (wandLevel == null) {
                wandLevel = newLevel;
            } else {
                newLevel.add(wandLevel);
                wandLevel = newLevel;
            }
            this.levelMap.put(level, wandLevel);
        }
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Nullable
    public WandLevel getLevel(int level) {
        if (this.levelMap == null) {
            return null;
        }
        if (!this.levelMap.containsKey(level)) {
            if (level > this.levelMap.lastKey()) {
                return this.levelMap.lastEntry().getValue();
            }
            return this.levelMap.firstEntry().getValue();
        }
        return this.levelMap.get(level);
    }

    @Nullable
    protected static WandUpgradePath getPath(MageController controller, String key, ConfigurationSection configuration) {
        resolvingKeys.clear();
        return WandUpgradePath.getPath(controller, key, configuration, resolvingKeys);
    }

    @Nullable
    protected static WandUpgradePath getPath(MageController controller, String key, ConfigurationSection configuration, Set<String> resolving) {
        if (resolving.contains(key)) {
            controller.getLogger().log(Level.WARNING, "Circular dependency detected in paths: " + StringUtils.join(resolving, (String)" -> ") + " -> " + key);
            return null;
        }
        resolving.add(key);
        WandUpgradePath path = paths.get(key);
        if (path == null) {
            ConfigurationSection parameters = configuration.getConfigurationSection(key);
            if (parameters == null) {
                return null;
            }
            if (!parameters.getBoolean("enabled", true)) {
                return null;
            }
            String inheritKey = parameters.getString("inherit");
            if (inheritKey != null && !inheritKey.isEmpty()) {
                WandUpgradePath inherit = WandUpgradePath.getPath(controller, inheritKey, configuration, resolving);
                if (inherit == null) {
                    Bukkit.getLogger().warning("Failed to load inherited path '" + inheritKey + "' for path: " + key);
                    return null;
                }
                path = new WandUpgradePath(controller, key, inherit, parameters);
            } else {
                path = new WandUpgradePath(controller, key, parameters);
            }
            paths.put(key, path);
        }
        return path;
    }

    public static WandUpgradePath getPath(String key) {
        return paths.get(key);
    }

    public static void loadPaths(MageController controller, ConfigurationSection configuration) {
        paths.clear();
        Set pathKeys = configuration.getKeys(false);
        for (String key : pathKeys) {
            WandUpgradePath.getPath(controller, key, configuration);
        }
    }

    public static Set<String> getPathKeys() {
        return paths.keySet();
    }

    public int getMaxLevel() {
        if (this.levels == null) {
            return 0;
        }
        return Math.min(this.levels[this.levels.length - 1], this.maxLevel);
    }

    @Nullable
    public Set<Integer> getLevels() {
        if (this.levelMap == null) {
            return null;
        }
        HashSet<Integer> filteredLevels = new HashSet<Integer>();
        for (Integer level : this.levelMap.keySet()) {
            if (level < this.minLevel || level > this.maxLevel) continue;
            filteredLevels.add(level);
        }
        return filteredLevels;
    }

    public int getMaxUses() {
        return this.maxUses;
    }

    public int getMaxMaxMana() {
        return this.maxMaxMana;
    }

    public int getMaxManaRegeneration() {
        return this.maxManaRegeneration;
    }

    public double getMaxProperty(String propertyKey) {
        Double maxValue = this.maxProperties.get(propertyKey);
        return maxValue == null ? 1.0 : maxValue;
    }

    public int getMinLevel() {
        return this.minLevel;
    }

    @Override
    public Set<String> getTags() {
        return this.tags;
    }

    @Override
    public boolean hasTag(String tag) {
        return this.tags != null && this.tags.contains(tag);
    }

    @Override
    public boolean hasAnyTag(Collection<String> tagSet) {
        return this.tags != null && !Collections.disjoint(tagSet, this.tags);
    }

    @Override
    public boolean hasAllTags(Collection<String> tagSet) {
        return this.tags != null && this.tags.containsAll(tagSet);
    }

    @Override
    public Set<String> getMissingTags(Collection<String> tagSet) {
        Set<String> tags = this.getTags();
        if (tags != null) {
            HashSet<String> s = new HashSet<String>(tagSet);
            s.removeAll(tags);
            tags = s;
        } else {
            tags = new HashSet<String>(tagSet);
        }
        return tags;
    }

    @Override
    public Collection<String> getSpells() {
        return new ArrayList<String>(this.allSpells);
    }

    @Override
    public Collection<String> getExtraSpells() {
        return new ArrayList<String>(this.allExtraSpells);
    }

    @Override
    public Collection<String> getRequiredSpells() {
        return new ArrayList<String>(this.allRequiredSpells);
    }

    @Override
    public boolean requiresSpell(String spellKey) {
        return this.requiredSpellKeys.contains(spellKey);
    }

    @Override
    public boolean hasSpell(String spellKey) {
        return this.spells.contains(spellKey);
    }

    @Override
    public boolean containsSpell(String spellKey) {
        return this.allSpells.contains(spellKey) || this.allExtraSpells.contains(spellKey);
    }

    @Override
    public boolean hasBrush(String brushKey) {
        return this.brushes.contains(brushKey);
    }

    @Override
    public boolean containsBrush(String brushKey) {
        return this.allBrushes.contains(brushKey);
    }

    @Override
    public boolean hasExtraSpell(String spellKey) {
        return this.extraSpells.contains(spellKey);
    }

    @Override
    public String getName() {
        return this.name == null || this.name.isEmpty() ? this.key : this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    protected void playEffects(Mage mage, String effectType) {
        Collection<EffectPlayer> players = this.effects.get(effectType);
        if (players == null || mage == null) {
            return;
        }
        Entity sourceEntity = mage.getEntity();
        Location mageLocation = mage.getEyeLocation();
        for (EffectPlayer player : players) {
            player.setColor(mage.getEffectColor());
            player.start(mageLocation, sourceEntity, null, null);
        }
    }

    public void enchanted(Mage mage) {
        this.playEffects(mage, "enchant");
    }

    @Override
    public void checkMigration(Wand wand) {
        if (this.icon != null && this.migrateIcon != null && this.migrateIcon.equals(wand.getIcon())) {
            wand.setIcon(this.icon);
        } else if (this.parent != null) {
            this.parent.checkMigration(wand);
        }
        int manaRegeneration = wand.getManaRegeneration();
        if (this.manaRegeneration > 0 && this.maxManaRegeneration == 0 && this.manaRegeneration > manaRegeneration) {
            wand.setManaRegeneration(this.manaRegeneration);
        }
        int manaMax = wand.getManaMax();
        if (this.maxMana > 0 && this.maxMaxMana == 0 && this.maxMaxMana > manaMax) {
            wand.setManaMax(this.maxMana);
        }
    }

    @Override
    public MaterialAndData getIcon() {
        return this.icon;
    }

    public void upgraded(MageController controller, Wand wand, Mage mage) {
        Wand upgradeWand;
        boolean shouldRunCommands;
        ConsoleCommandSender sender = Bukkit.getConsoleSender();
        Location location = null;
        if (mage != null) {
            this.playEffects(mage, "upgrade");
            location = mage.getLocation();
        }
        Player player = mage != null ? mage.getPlayer() : null;
        boolean bl = shouldRunCommands = player == null || !player.hasPermission("Magic.bypass_upgrade_commands");
        if (this.upgradeCommands != null && shouldRunCommands) {
            for (String command : this.upgradeCommands) {
                if (command.contains("@uuid") || command.contains("@pn") || command.contains("@pd")) {
                    if (mage == null) continue;
                    command = command.replace("@uuid", mage.getId()).replace("@pn", mage.getName()).replace("@pd", mage.getDisplayName());
                }
                if (location != null) {
                    command = command.replace("@world", location.getWorld().getName()).replace("@x", Double.toString(location.getX())).replace("@y", Double.toString(location.getY())).replace("@z", Double.toString(location.getZ()));
                }
                WandUpgradePath upgrade = WandUpgradePath.getPath(this.upgradeKey);
                command = command.replace("$path", upgrade.getName());
                command = ChatColor.translateAlternateColorCodes((char)'&', (String)command);
                controller.getPlugin().getServer().dispatchCommand((CommandSender)sender, command);
            }
        }
        if (this.upgradeItemKey != null && !this.upgradeItemKey.isEmpty() && (upgradeWand = controller.createWand(this.upgradeItemKey)) != null) {
            if (wand != null) {
                wand.add(upgradeWand);
            } else if (mage != null) {
                mage.getActiveProperties().add(upgradeWand);
            }
        }
    }

    @Override
    public boolean hasUpgrade() {
        return this.upgradeKey != null && !this.upgradeKey.isEmpty();
    }

    @Override
    @Nullable
    public WandUpgradePath getUpgrade() {
        return WandUpgradePath.getPath(this.upgradeKey);
    }

    @Override
    @Nullable
    public ProgressionPath getNextPath() {
        return this.getUpgrade();
    }

    public boolean getMatchSpellMana() {
        return this.matchSpellMana;
    }

    @Override
    public boolean canProgress(CasterProperties properties) {
        if (this.levelMap == null) {
            return false;
        }
        WandLevel maxLevel = this.levelMap.get(this.levels[this.levels.length - 1]);
        Deque<WeightedPair<String>> remainingSpells = maxLevel.getRemainingSpells(properties);
        Mage mage = properties.getMage();
        if (mage != null && mage.getDebugLevel() > 0) {
            mage.sendDebugMessage("Spells remaining: " + remainingSpells.size());
        }
        return remainingSpells.size() > 0;
    }

    @Override
    public boolean canEnchant(Wand apiWand) {
        return this.canProgress(apiWand);
    }

    public boolean hasSpells() {
        WandLevel maxLevel = this.levelMap.get(this.levels[this.levels.length - 1]);
        return maxLevel.getSpellProbabilityCount() > 0;
    }

    public boolean hasMaterials() {
        WandLevel maxLevel = this.levelMap.get(this.levels[this.levels.length - 1]);
        return maxLevel.getMaterialProbabilityCount() > 0;
    }

    private String getMessage(Messages messages, String messageKey) {
        String message = messages.get("spell." + messageKey);
        message = messages.get("wand." + messageKey, message);
        message = messages.get("path." + messageKey, message);
        return messages.get("paths." + this.key + "." + messageKey, message);
    }

    @Override
    public boolean checkUpgradeRequirements(Wand wand, Mage mage) {
        return this.checkUpgradeRequirements(wand == null ? mage.getActiveProperties() : wand, mage == null);
    }

    @Override
    public boolean checkUpgradeRequirements(CasterProperties caster, boolean quiet) {
        if (this.requiredSpells == null || this.requiredSpells.isEmpty()) {
            return true;
        }
        if (caster == null) {
            return false;
        }
        MageController controller = caster.getController();
        Mage mage = caster.getMage();
        for (PrerequisiteSpell prereq : this.requiredSpells) {
            SpellTemplate spell;
            if (!caster.hasSpell(prereq.getSpellKey().getKey())) {
                spell = controller.getSpellTemplate(prereq.getSpellKey().getKey());
                if (spell == null) {
                    controller.getLogger().warning("Invalid spell required for upgrade: " + prereq.getSpellKey().getKey());
                    return false;
                }
                if (mage != null && !quiet) {
                    String requiredSpellMessage = this.getMessage(controller.getMessages(), "required_spell");
                    String message = requiredSpellMessage.replace("$spell", spell.getName());
                    WandUpgradePath upgradePath = this.getUpgrade();
                    if (upgradePath != null) {
                        message = message.replace("$path", upgradePath.getName());
                    }
                    mage.sendMessage(message);
                }
                return false;
            }
            spell = caster.getSpell(prereq.getSpellKey().getKey());
            if (PrerequisiteSpell.isSpellSatisfyingPrerequisite((Spell)spell, prereq)) continue;
            if (mage != null && !quiet) {
                String message = this.getMessage(controller.getMessages(), "spell.prerequisite_spell_level").replace("$name", spell.getName()).replace("$level", Integer.toString(prereq.getSpellKey().getLevel()));
                if (prereq.getProgressLevel() > 1L) {
                    message = message + this.getMessage(controller.getMessages(), "spell.prerequisite_spell_progress_level").replace("$level", Long.toString(prereq.getProgressLevel())).replace("$max_level", Long.toString(Math.max(1L, spell.getMaxProgressLevel())));
                }
                mage.sendMessage(message);
            }
            return false;
        }
        return true;
    }

    public float getBonusLevelMultiplier() {
        return this.bonusLevelMultiplier;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public boolean hasPath(String pathName) {
        if (this.key.equalsIgnoreCase(pathName)) {
            return true;
        }
        if (this.followsPath != null && this.followsPath.equalsIgnoreCase(pathName)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.hasPath(pathName);
        }
        return false;
    }

    @Override
    public String translatePath(String pathKey) {
        if (this.followsPath != null) {
            if (this.followsPath.equalsIgnoreCase(pathKey)) {
                return this.key;
            }
            if (this.upgradeKey != null) {
                return this.getUpgrade().translatePath(pathKey);
            }
        }
        return pathKey;
    }

    protected void upgradeTo(CasterProperties properties) {
        properties.setPath(this.getKey());
        boolean addedProperties = false;
        MemoryConfiguration wandProperties = new MemoryConfiguration();
        int manaRegeneration = properties.getManaRegeneration();
        if (this.manaRegeneration > 0 && this.maxManaRegeneration == 0 && this.manaRegeneration > manaRegeneration) {
            addedProperties = true;
            wandProperties.set("mana_regeneration", (Object)this.manaRegeneration);
        }
        int manaMax = properties.getManaMax();
        if (this.maxMana > 0 && this.maxMaxMana == 0 && this.maxMana > manaMax) {
            addedProperties = true;
            wandProperties.set("mana_max", (Object)this.maxMana);
        }
        if (addedProperties) {
            properties.upgrade((ConfigurationSection)wandProperties);
        }
    }

    private void upgrade(@Nonnull Mage mage, @Nonnull WandUpgradePath newPath) {
        Wand wand = mage.getActiveWand();
        MageController controller = mage.getController();
        String message = this.getMessage(controller.getMessages(), "level_up").replace("$path", newPath.getName());
        if (wand != null) {
            message = message.replace("$wand", wand.getName());
        }
        mage.sendMessage(message);
        WandUpgradeEvent legacyEvent = new WandUpgradeEvent(mage, wand, this, newPath);
        Bukkit.getPluginManager().callEvent((Event)legacyEvent);
        MageClass mageClass = wand == null ? mage.getActiveClass() : wand.getMageClass();
        PathUpgradeEvent upgradeEvent = new PathUpgradeEvent(mage, wand, mageClass, this, newPath);
        Bukkit.getPluginManager().callEvent((Event)upgradeEvent);
    }

    private void upgrade(@Nonnull Wand wand, @Nonnull WandUpgradePath newPath) {
        MaterialAndData newIcon;
        if (this.icon != null && this.icon.equals(wand.getIcon()) && (newIcon = newPath.getIcon()) != null) {
            wand.setIcon(newIcon);
        }
    }

    @Override
    public void upgrade(@Nonnull Mage mage, @Nullable Wand wand) {
        this.doUpgrade(mage, wand);
    }

    @Override
    public void upgrade(Wand wand, Mage mage) {
        this.doUpgrade(mage, wand);
    }

    private void doUpgrade(@Nullable Mage mage, @Nullable Wand wand) {
        WandUpgradePath newPath = this.getUpgrade();
        MageController controller = null;
        if (mage != null) {
            controller = mage.getController();
        }
        if (controller == null && wand != null) {
            controller = wand.getController();
        }
        if (controller == null) {
            return;
        }
        if (newPath == null) {
            if (mage != null) {
                mage.sendMessage("Configuration issue, please check logs");
            }
            controller.getLogger().warning("Invalid upgrade path: " + this.getUpgrade());
            return;
        }
        if (wand != null) {
            this.upgrade(wand, newPath);
        }
        if (mage != null) {
            this.upgrade(mage, newPath);
        }
        this.upgraded(controller, wand, mage);
        newPath.upgradeTo(mage != null ? mage.getActiveProperties() : wand);
    }

    @Override
    public boolean earnsSP() {
        return this.earnsSP;
    }
}

