/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MageParameters;
import com.elmakers.mine.bukkit.magic.TemplateProperties;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.configuration.ConfigurationSection;

public class ModifierTemplate
extends TemplateProperties
implements com.elmakers.mine.bukkit.api.magic.ModifierTemplate {
    private ModifierTemplate parent;
    private String name;
    private String description;

    public ModifierTemplate(@Nonnull MageController controller, @Nonnull String key, @Nonnull ConfigurationSection configuration) {
        super(controller, key, configuration);
        Preconditions.checkNotNull((Object)configuration, (Object)"configuration");
        this.clearProperty("parent");
        this.clearProperty("enabled");
        this.clearProperty("inherit");
        this.name = controller.getMessages().get("modifiers." + key + ".name", key);
        this.description = controller.getMessages().get("modifiers." + key + ".description", "");
        this.name = configuration.getString("name", this.name);
        this.description = configuration.getString("description", this.description);
    }

    private ModifierTemplate(ModifierTemplate copy, ConfigurationSection configuration) {
        super(copy.controller, copy.getKey(), configuration);
        this.name = copy.name;
        this.description = copy.description;
        this.parent = copy.parent;
    }

    public ModifierTemplate getModifierTemplate(Mage mage) {
        MageParameters parameters = new MageParameters(mage, "Modifier " + this.getKey());
        ConfigurationUtils.addConfigurations((ConfigurationSection)parameters, this.configuration);
        return new ModifierTemplate(this, (ConfigurationSection)parameters);
    }

    @Override
    @Nullable
    public ModifierTemplate getParent() {
        return this.parent;
    }

    public void setParent(@Nullable ModifierTemplate parent) {
        this.parent = parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public ModifierTemplate getMageTemplate(Mage mage) {
        MageParameters parameters = new MageParameters(mage, "Mage modifier " + this.getKey());
        ConfigurationUtils.addConfigurations((ConfigurationSection)parameters, this.configuration);
        return new ModifierTemplate(this, (ConfigurationSection)parameters);
    }
}

