/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.spell.SpellKey;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.MagicPlugin;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class ConfigurationLoadTask
implements Runnable {
    private final MagicController controller;
    private final File configFolder;
    private final Plugin plugin;
    private final CommandSender sender;
    private static final String[] CONFIG_FILES = new String[]{"messages", "materials", "attributes", "effects", "spells", "paths", "classes", "wands", "items", "crafting", "mobs", "automata", "modifiers"};
    private static final ImmutableSet<String> DEFAULT_ON = ImmutableSet.of((Object)"messages", (Object)"materials");
    private final Map<String, ConfigurationSection> loadedConfigurations = new HashMap<String, ConfigurationSection>();
    private final Map<String, ConfigurationSection> spellConfigurations = new HashMap<String, ConfigurationSection>();
    private final Map<String, ConfigurationSection> baseSpellConfigurations = new HashMap<String, ConfigurationSection>();
    private static final Object loadLock = new Object();
    private boolean allPvpRestricted = false;
    private boolean noPvpRestricted = false;
    private boolean saveDefaultConfigs = true;
    private boolean spellUpgradesEnabled = true;
    private String exampleDefaults = null;
    private String languageOverride = null;
    private Collection<String> addExamples = null;
    private ConfigurationSection mainConfiguration;
    private Set<String> resolvingKeys = new LinkedHashSet<String>();
    private boolean success;

    public ConfigurationLoadTask(MagicController controller, CommandSender sender) {
        this.controller = controller;
        this.sender = sender;
        this.plugin = controller.getPlugin();
        this.configFolder = controller.getConfigFolder();
    }

    private Logger getLogger() {
        return this.controller.getLogger();
    }

    private void loadInitialProperties(ConfigurationSection properties) {
        this.spellUpgradesEnabled = properties.getBoolean("enable_spell_upgrades", true);
        this.allPvpRestricted = properties.getBoolean("pvp_restricted", false);
        this.noPvpRestricted = properties.getBoolean("allow_pvp_restricted", false);
        this.saveDefaultConfigs = properties.getBoolean("save_default_configs", true);
        this.exampleDefaults = properties.getString("example", this.exampleDefaults);
        this.addExamples = properties.getStringList("add_examples");
        if (this.addExamples.isEmpty()) {
            this.addExamples = properties.getStringList("examples");
        }
        this.languageOverride = properties.getString("language");
    }

    private void info(String message) {
        this.controller.info(message);
    }

    private ConfigurationSection loadMainConfiguration() throws InvalidConfigurationException, IOException {
        ConfigurationSection configuration = this.loadMainConfiguration("config");
        this.loadInitialProperties(configuration);
        boolean reloadConfig = false;
        if (this.addExamples != null && this.addExamples.size() > 0) {
            this.info("Adding examples: " + StringUtils.join(this.addExamples, (String)","));
            reloadConfig = true;
        }
        if (this.exampleDefaults != null && this.exampleDefaults.length() > 0) {
            this.info("Overriding configuration with example: " + this.exampleDefaults);
            reloadConfig = true;
        }
        if (reloadConfig) {
            configuration = this.loadMainConfiguration("config");
        }
        return configuration;
    }

    private ConfigurationSection loadMainConfiguration(String fileName) throws InvalidConfigurationException, IOException {
        Object input;
        ConfigurationSection overrides = this.loadOverrides(fileName);
        boolean usingExample = this.exampleDefaults != null && this.exampleDefaults.length() > 0;
        String examplesFileName = usingExample ? "examples/" + this.exampleDefaults + "/" + fileName + ".yml" : null;
        String defaultsFileName = "defaults/" + fileName + ".defaults.yml";
        YamlConfiguration config = CompatibilityUtils.loadConfiguration(this.plugin.getResource(defaultsFileName));
        this.info(" Based on defaults " + defaultsFileName);
        if (usingExample && (input = this.plugin.getResource(examplesFileName)) != null) {
            YamlConfiguration exampleConfig = CompatibilityUtils.loadConfiguration((InputStream)input);
            ConfigurationUtils.addConfigurations((ConfigurationSection)config, (ConfigurationSection)exampleConfig);
            this.info(" Using " + examplesFileName);
            List<String> inherits = ConfigurationUtils.getStringList((ConfigurationSection)exampleConfig, "inherit");
            if (inherits != null) {
                for (String inheritFrom : inherits) {
                    String inheritFileName = "examples/" + inheritFrom + "/" + fileName + ".yml";
                    InputStream inheritInput = this.plugin.getResource(inheritFileName);
                    if (inheritInput == null) continue;
                    YamlConfiguration inheritedConfig = CompatibilityUtils.loadConfiguration(inheritInput);
                    ConfigurationUtils.addConfigurations((ConfigurationSection)config, (ConfigurationSection)inheritedConfig, false);
                    this.info("  Inheriting from " + inheritFrom);
                }
            }
        }
        if (this.addExamples != null && this.addExamples.size() > 0) {
            for (String example : this.addExamples) {
                examplesFileName = "examples/" + example + "/" + fileName + ".yml";
                InputStream input2 = this.plugin.getResource(examplesFileName);
                if (input2 == null) continue;
                YamlConfiguration exampleConfig = CompatibilityUtils.loadConfiguration(input2);
                ConfigurationUtils.addConfigurations((ConfigurationSection)config, (ConfigurationSection)exampleConfig, false);
                this.info(" Added " + examplesFileName);
            }
        }
        this.addVersionConfigs((ConfigurationSection)config, fileName);
        ConfigurationUtils.addConfigurations((ConfigurationSection)config, overrides);
        File configSubFolder = new File(this.configFolder, fileName);
        this.loadConfigFolder((ConfigurationSection)config, configSubFolder, false);
        if (this.saveDefaultConfigs) {
            try {
                this.plugin.saveResource(defaultsFileName, true);
            }
            catch (Exception ex) {
                this.getLogger().warning("Couldn't write defaults file: " + defaultsFileName);
            }
        } else {
            this.deleteDefaults(defaultsFileName);
        }
        return config;
    }

    private ConfigurationSection loadOverrides(String fileName) throws IOException, InvalidConfigurationException {
        String configFileName = fileName + ".yml";
        File configFile = new File(this.configFolder, configFileName);
        if (!configFile.exists()) {
            this.info("Saving template " + configFileName + ", edit to customize configuration.");
            this.plugin.saveResource(configFileName, false);
        }
        this.info("Loading " + configFile.getName());
        return CompatibilityUtils.loadConfiguration(configFile);
    }

    private ConfigurationSection loadConfigFile(String fileName, ConfigurationSection mainConfiguration) throws IOException, InvalidConfigurationException {
        String languageFileName;
        InputStream input;
        boolean loadAllDefaults = mainConfiguration.getBoolean("load_default_configs", true);
        if (DEFAULT_ON.contains((Object)fileName)) {
            loadAllDefaults = true;
        }
        boolean loadDefaults = mainConfiguration.getBoolean("load_default_" + fileName, loadAllDefaults);
        boolean disableDefaults = mainConfiguration.getBoolean("disable_default_" + fileName, false);
        ConfigurationSection mainSection = mainConfiguration.getConfigurationSection(fileName);
        ConfigurationSection overrides = this.loadOverrides(fileName);
        boolean usingExample = this.exampleDefaults != null && this.exampleDefaults.length() > 0;
        String examplesFileName = usingExample ? "examples/" + this.exampleDefaults + "/" + fileName + ".yml" : null;
        String defaultsFileName = "defaults/" + fileName + ".defaults.yml";
        YamlConfiguration config = new YamlConfiguration();
        YamlConfiguration defaultConfig = CompatibilityUtils.loadConfiguration(this.plugin.getResource(defaultsFileName));
        String header = defaultConfig.options().header();
        if (loadDefaults) {
            this.info(" Based on defaults " + defaultsFileName);
            if (disableDefaults) {
                this.disableAll((ConfigurationSection)defaultConfig);
            }
            ConfigurationUtils.addConfigurations((ConfigurationSection)config, (ConfigurationSection)defaultConfig);
        }
        boolean disableInherited = false;
        if (usingExample && loadDefaults) {
            List<String> skip;
            List<String> inherits = ConfigurationUtils.getStringList(mainConfiguration, "inherit");
            if (!(inherits == null || (skip = ConfigurationUtils.getStringList(mainConfiguration, "skip_inherited")) != null && skip.contains(fileName))) {
                for (String inheritFrom : inherits) {
                    String inheritFileName = "examples/" + inheritFrom + "/" + fileName + ".yml";
                    InputStream input2 = this.plugin.getResource(inheritFileName);
                    if (input2 == null) continue;
                    List<String> disable = ConfigurationUtils.getStringList(mainConfiguration, "disable_inherited");
                    YamlConfiguration inheritedConfig = CompatibilityUtils.loadConfiguration(input2);
                    if (disable != null && disable.contains(fileName)) {
                        disableInherited = true;
                        this.disableAll((ConfigurationSection)inheritedConfig);
                    }
                    ConfigurationUtils.addConfigurations((ConfigurationSection)config, (ConfigurationSection)inheritedConfig);
                    this.info(" Inheriting from " + inheritFrom);
                }
            }
            if ((input = this.plugin.getResource(examplesFileName)) != null) {
                YamlConfiguration exampleConfig = CompatibilityUtils.loadConfiguration(input);
                if (disableDefaults) {
                    this.disableAll((ConfigurationSection)exampleConfig);
                } else if (disableInherited) {
                    this.enableAll((ConfigurationSection)exampleConfig);
                }
                ConfigurationUtils.addConfigurations((ConfigurationSection)config, (ConfigurationSection)exampleConfig);
                this.info(" Using " + examplesFileName);
            }
        }
        if (mainSection != null) {
            ConfigurationUtils.addConfigurations(overrides, mainSection);
        }
        if (disableDefaults || disableInherited) {
            this.enableAll(overrides);
        }
        if (this.addExamples != null && this.addExamples.size() > 0) {
            for (String example : this.addExamples) {
                examplesFileName = "examples/" + example + "/" + fileName + ".yml";
                InputStream input3 = this.plugin.getResource(examplesFileName);
                if (input3 == null) continue;
                YamlConfiguration exampleConfig = CompatibilityUtils.loadConfiguration(input3);
                if (disableDefaults || disableInherited) {
                    this.enableAll((ConfigurationSection)exampleConfig);
                }
                ConfigurationUtils.addConfigurations((ConfigurationSection)config, (ConfigurationSection)exampleConfig, false);
                this.info(" Added " + examplesFileName);
            }
        }
        this.addVersionConfigs((ConfigurationSection)config, fileName);
        if (fileName.equals("messages") && this.languageOverride != null && (input = this.plugin.getResource(languageFileName = "examples/localizations/messages." + this.languageOverride + ".yml")) != null) {
            YamlConfiguration languageConfig = CompatibilityUtils.loadConfiguration(input);
            ConfigurationUtils.addConfigurations((ConfigurationSection)config, (ConfigurationSection)languageConfig);
            this.info(" Using " + languageFileName);
        }
        ConfigurationUtils.addConfigurations((ConfigurationSection)config, overrides);
        File configSubFolder = new File(this.configFolder, fileName);
        this.loadConfigFolder((ConfigurationSection)config, configSubFolder, disableDefaults || disableInherited);
        File savedDefaults = new File(this.configFolder, defaultsFileName);
        if (this.saveDefaultConfigs) {
            try {
                config.options().header(header);
                config.save(savedDefaults);
            }
            catch (Exception ex) {
                this.getLogger().warning("Couldn't write defaults file: " + defaultsFileName);
            }
        } else {
            this.deleteDefaults(defaultsFileName);
        }
        return config;
    }

    private void addVersionConfigs(ConfigurationSection config, String fileName) throws InvalidConfigurationException, IOException {
        int[] serverVersion = CompatibilityUtils.getServerVersion();
        int majorVersion = serverVersion[0];
        int minorVersion = serverVersion[1];
        String versionExample = majorVersion + "." + minorVersion;
        String versionFileName = "examples/" + versionExample + "/" + fileName + ".yml";
        InputStream versionInput = this.plugin.getResource(versionFileName);
        if (versionInput != null) {
            YamlConfiguration versionConfig = CompatibilityUtils.loadConfiguration(versionInput);
            ConfigurationUtils.addConfigurations(config, (ConfigurationSection)versionConfig, true, true);
            this.getLogger().info(" Using compatibility configs: " + versionFileName);
        }
    }

    private void deleteDefaults(String defaultsFileName) {
        File savedDefaults = new File(this.configFolder, defaultsFileName);
        if (savedDefaults.exists()) {
            try {
                savedDefaults.delete();
                this.getLogger().info("Deleting defaults file: " + defaultsFileName + ", save_default_configs is false");
            }
            catch (Exception ex) {
                this.getLogger().warning("Couldn't delete defaults file: " + defaultsFileName + ", contents may be outdated");
            }
        }
    }

    private void enableAll(ConfigurationSection rootSection, boolean enabled) {
        Set keys = rootSection.getKeys(false);
        for (String key : keys) {
            ConfigurationSection section = rootSection.getConfigurationSection(key);
            if (section.isSet("enabled")) continue;
            section.set("enabled", (Object)enabled);
        }
    }

    private void enableAll(ConfigurationSection rootSection) {
        this.enableAll(rootSection, true);
    }

    private void disableAll(ConfigurationSection rootSection) {
        this.enableAll(rootSection, false);
    }

    private ConfigurationSection loadConfigFolder(ConfigurationSection config, File configSubFolder, boolean setEnabled) throws IOException, InvalidConfigurationException {
        if (configSubFolder.exists()) {
            ArrayList<File> priorityFiles = new ArrayList<File>();
            File[] files = configSubFolder.listFiles();
            for (File file : files) {
                if (file.getName().startsWith(".")) continue;
                if (file.isDirectory()) {
                    config = this.loadConfigFolder(config, file, setEnabled);
                    continue;
                }
                if (file.getName().startsWith("_")) {
                    priorityFiles.add(file);
                    continue;
                }
                this.info("  Loading " + file.getName());
                ConfigurationSection fileOverrides = CompatibilityUtils.loadConfiguration(file);
                if (setEnabled) {
                    this.enableAll(fileOverrides);
                }
                config = ConfigurationUtils.addConfigurations(config, fileOverrides);
            }
            for (File file : priorityFiles) {
                this.info("  Loading " + file.getName());
                ConfigurationSection fileOverrides = CompatibilityUtils.loadConfiguration(file);
                if (setEnabled) {
                    this.enableAll(fileOverrides);
                }
                config = ConfigurationUtils.addConfigurations(config, fileOverrides);
            }
        } else {
            configSubFolder.mkdir();
        }
        return config;
    }

    private ConfigurationSection mapSpells(ConfigurationSection spellConfiguration) throws InvalidConfigurationException, IOException {
        MemoryConfiguration spellConfigs = new MemoryConfiguration();
        if (spellConfiguration == null) {
            return spellConfigs;
        }
        this.spellConfigurations.clear();
        this.baseSpellConfigurations.clear();
        Set spellKeys = spellConfiguration.getKeys(false);
        for (String key : spellKeys) {
            ConfigurationSection spellNode;
            if (key.equals("default") || key.equals("override") || (spellNode = this.getSpellConfig(key, spellConfiguration)) == null || !spellNode.getBoolean("enabled", true)) continue;
            if (this.noPvpRestricted) {
                spellNode.set("pvp_restricted", (Object)false);
            } else if (this.allPvpRestricted) {
                spellNode.set("pvp_restricted", (Object)true);
            }
            spellConfigs.set(key, (Object)spellNode);
        }
        return spellConfigs;
    }

    @Nullable
    private ConfigurationSection getSpellConfig(String key, ConfigurationSection config) {
        return this.getSpellConfig(key, config, true);
    }

    @Nullable
    private ConfigurationSection getSpellConfig(String key, ConfigurationSection config, boolean addInherited) {
        this.resolvingKeys.clear();
        return this.getSpellConfig(key, config, addInherited, this.resolvingKeys);
    }

    @Nullable
    private ConfigurationSection getSpellConfig(String key, ConfigurationSection config, boolean addInherited, Set<String> resolving) {
        boolean processInherited;
        ConfigurationSection built;
        if (this.resolvingKeys.contains(key)) {
            this.getLogger().log(Level.WARNING, "Circular dependency detected in spell configs: " + StringUtils.join(this.resolvingKeys, (String)" -> ") + " -> " + key);
            return config;
        }
        this.resolvingKeys.add(key);
        if (addInherited ? (built = this.spellConfigurations.get(key)) != null : (built = this.baseSpellConfigurations.get(key)) != null) {
            return built;
        }
        ConfigurationSection spellNode = config.getConfigurationSection(key);
        if (spellNode == null) {
            this.getLogger().warning("Spell " + key + " not known");
            return null;
        }
        spellNode = ConfigurationUtils.cloneConfiguration(spellNode);
        SpellKey spellKey = new SpellKey(key);
        String inheritFrom = spellNode.getString("inherit");
        if (inheritFrom != null && inheritFrom.equalsIgnoreCase("false")) {
            inheritFrom = null;
        }
        String upgradeInheritsFrom = null;
        if (spellKey.isVariant()) {
            if (!this.spellUpgradesEnabled) {
                return null;
            }
            int level = spellKey.getLevel();
            upgradeInheritsFrom = spellKey.getBaseKey();
            if (level != 2) {
                upgradeInheritsFrom = upgradeInheritsFrom + "|" + (level - 1);
            }
        }
        boolean bl = processInherited = addInherited && inheritFrom != null;
        if (processInherited || upgradeInheritsFrom != null) {
            if (processInherited && key.equals(inheritFrom)) {
                this.getLogger().warning("Spell " + key + " inherits from itself");
            } else if (processInherited) {
                ConfigurationSection inheritConfig = this.getSpellConfig(inheritFrom, config, true, resolving);
                if (inheritConfig != null) {
                    spellNode = ConfigurationUtils.addConfigurations(spellNode, inheritConfig, false);
                } else {
                    this.getLogger().warning("Spell " + key + " inherits from unknown ancestor " + inheritFrom);
                }
            }
            if (upgradeInheritsFrom != null) {
                if (config.contains(upgradeInheritsFrom)) {
                    ConfigurationSection baseInheritConfig = this.getSpellConfig(upgradeInheritsFrom, config, inheritFrom == null, resolving);
                    spellNode = ConfigurationUtils.addConfigurations(spellNode, baseInheritConfig, inheritFrom != null);
                } else {
                    this.getLogger().warning("Spell upgrade " + key + " inherits from unknown level " + upgradeInheritsFrom);
                }
            }
        } else {
            ConfigurationSection defaults = config.getConfigurationSection("default");
            if (defaults != null) {
                spellNode = ConfigurationUtils.addConfigurations(spellNode, defaults, false);
            }
        }
        if (addInherited) {
            this.spellConfigurations.put(key, spellNode);
        } else {
            this.baseSpellConfigurations.put(key, spellNode);
        }
        ConfigurationSection override = config.getConfigurationSection("override");
        if (override != null) {
            spellNode = ConfigurationUtils.addConfigurations(spellNode, override, true);
        }
        return spellNode;
    }

    private void run(boolean synchronous) {
        this.success = true;
        Logger logger = this.controller.getLogger();
        try {
            this.mainConfiguration = this.loadMainConfiguration();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error loading config.yml", ex);
            this.success = false;
        }
        this.loadedConfigurations.clear();
        for (String configurationFile : CONFIG_FILES) {
            try {
                ConfigurationSection configuration = this.loadConfigFile(configurationFile, this.mainConfiguration);
                if (configurationFile.equals("spells")) {
                    configuration = this.mapSpells(configuration);
                }
                this.loadedConfigurations.put(configurationFile, configuration);
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, "Error loading " + configurationFile, ex);
                this.loadedConfigurations.put(configurationFile, (ConfigurationSection)new MemoryConfiguration());
                this.success = false;
            }
        }
        if (synchronous) {
            this.controller.finalizeLoad(this, this.sender);
        } else {
            MagicPlugin plugin = this.controller.getPlugin();
            final ConfigurationLoadTask result = this;
            plugin.getServer().getScheduler().runTask((Plugin)plugin, new Runnable(){

                @Override
                public void run() {
                    ConfigurationLoadTask.this.controller.finalizeLoad(result, ConfigurationLoadTask.this.sender);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = loadLock;
        synchronized (object) {
            this.run(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runNow() {
        Object object = loadLock;
        synchronized (object) {
            this.run(true);
        }
    }

    public ConfigurationSection getMainConfiguration() {
        return this.mainConfiguration;
    }

    public ConfigurationSection getMessages() {
        return this.loadedConfigurations.get("messages");
    }

    public ConfigurationSection getMaterials() {
        return this.loadedConfigurations.get("materials");
    }

    public ConfigurationSection getWands() {
        return this.loadedConfigurations.get("wands");
    }

    public ConfigurationSection getPaths() {
        return this.loadedConfigurations.get("paths");
    }

    public ConfigurationSection getCrafting() {
        return this.loadedConfigurations.get("crafting");
    }

    public ConfigurationSection getMobs() {
        return this.loadedConfigurations.get("mobs");
    }

    public ConfigurationSection getItems() {
        return this.loadedConfigurations.get("items");
    }

    public ConfigurationSection getClasses() {
        return this.loadedConfigurations.get("classes");
    }

    public ConfigurationSection getModifiers() {
        return this.loadedConfigurations.get("modifiers");
    }

    public ConfigurationSection getAttributes() {
        return this.loadedConfigurations.get("attributes");
    }

    public ConfigurationSection getAutomata() {
        return this.loadedConfigurations.get("automata");
    }

    public ConfigurationSection getEffects() {
        return this.loadedConfigurations.get("effects");
    }

    public ConfigurationSection getSpells() {
        return this.loadedConfigurations.get("spells");
    }

    public boolean isSuccessful() {
        return this.success;
    }

    public String getExampleDefaults() {
        return this.exampleDefaults;
    }

    public Collection<String> getAddExamples() {
        return this.addExamples;
    }
}

