/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.economy;

import com.elmakers.mine.bukkit.api.magic.CasterProperties;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.economy.BaseMagicCurrency;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import org.bukkit.configuration.ConfigurationSection;

public class CustomCurrency
extends BaseMagicCurrency {
    private final double defaultValue;
    private final double maxValue;
    private final MaterialAndData icon;

    public CustomCurrency(MageController controller, String key, ConfigurationSection configuration) {
        super(key, configuration.getDouble("worth", 1.0), controller.getMessages().get("currency." + key + ".name", key), controller.getMessages().get("currency." + key + ".amount", key));
        this.defaultValue = configuration.getDouble("default", 0.0);
        this.maxValue = configuration.getDouble("max", -1.0);
        this.icon = ConfigurationUtils.getMaterialAndData(configuration, "icon");
    }

    @Override
    public double getBalance(Mage mage, CasterProperties caster) {
        return mage.getCurrency(this.key);
    }

    @Override
    public boolean has(Mage mage, CasterProperties caster, double amount) {
        return mage.getCurrency(this.key) >= amount;
    }

    @Override
    public void deduct(Mage mage, CasterProperties caster, double amount) {
        mage.removeCurrency(this.key, amount);
    }

    @Override
    public boolean give(Mage mage, CasterProperties caster, double amount) {
        if (mage.isAtMaxCurrency(this.key)) {
            return false;
        }
        mage.addCurrency(this.key, amount);
        return true;
    }

    @Override
    public double getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public double getMaxValue() {
        return this.maxValue;
    }

    @Override
    public boolean hasMaxValue() {
        return this.maxValue >= 0.0;
    }

    @Override
    public MaterialAndData getIcon() {
        return this.icon;
    }
}

