/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.block;

import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.batch.Batch;
import com.elmakers.mine.bukkit.api.block.ModifyType;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MageModifier;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.batch.UndoBatch;
import com.elmakers.mine.bukkit.block.BlockComparator;
import com.elmakers.mine.bukkit.block.BlockData;
import com.elmakers.mine.bukkit.block.BlockList;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.block.UndoQueue;
import com.elmakers.mine.bukkit.block.UndoRegistry;
import com.elmakers.mine.bukkit.entity.EntityData;
import com.elmakers.mine.bukkit.magic.MaterialSets;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.DeprecatedUtils;
import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Hanging;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;

public class UndoList
extends BlockList
implements com.elmakers.mine.bukkit.api.block.UndoList {
    @Nonnull
    public static MaterialSet attachables = MaterialSets.empty();
    @Nonnull
    public static MaterialSet attachablesWall = MaterialSets.empty();
    @Nonnull
    public static MaterialSet attachablesDouble = MaterialSets.empty();
    protected static final UndoRegistry registry = new UndoRegistry();
    protected static BlockComparator blockComparator = new BlockComparator();
    protected Map<Long, com.elmakers.mine.bukkit.api.block.BlockData> watching;
    private Set<String> worlds = new HashSet<String>();
    private boolean loading = false;
    protected Set<Entity> entities;
    protected Deque<Runnable> runnables;
    protected HashMap<UUID, EntityData> modifiedEntities;
    protected WeakReference<CastContext> context;
    protected Mage owner;
    protected Plugin plugin;
    protected boolean undone = false;
    protected boolean finished = false;
    protected int timeToLive = 0;
    protected ModifyType modifyType = ModifyType.NO_PHYSICS;
    protected boolean bypass = false;
    protected boolean hasBeenScheduled = false;
    protected final long createdTime;
    protected long modifiedTime;
    protected long scheduledTime;
    protected double speed = 0.0;
    protected Spell spell;
    protected Batch batch;
    protected UndoQueue undoQueue;
    protected UndoList next;
    protected UndoList previous;
    protected String name;
    private boolean consumed = false;
    private boolean undoEntityEffects = true;
    private Set<EntityType> undoEntityTypes = null;
    protected boolean undoBreakable = false;
    protected boolean undoReflective = false;
    protected boolean sorted = true;
    protected boolean reverse = true;
    protected boolean unbreakable = false;

    public UndoList(Mage mage, String name) {
        this(mage);
        this.name = name;
    }

    public UndoList(@Nonnull MageController controller) {
        this.plugin = controller.getPlugin();
        this.modifiedTime = this.createdTime = System.currentTimeMillis();
    }

    public UndoList(Mage mage) {
        this.setMage(mage);
        this.modifiedTime = this.createdTime = System.currentTimeMillis();
    }

    public void setMage(Mage mage) {
        this.owner = mage;
        if (mage != null) {
            this.plugin = mage.getController().getPlugin();
        }
    }

    @Override
    public void setBatch(Batch batch) {
        this.batch = batch;
    }

    @Override
    public void setSpell(Spell spell) {
        this.spell = spell;
        this.context = spell == null ? null : new WeakReference<CastContext>(spell.getCurrentCast());
    }

    @Override
    public boolean isEmpty() {
        return !(this.blockList != null && !this.blockList.isEmpty() || this.entities != null && !this.entities.isEmpty() || this.runnables != null && !this.runnables.isEmpty());
    }

    @Override
    public void setScheduleUndo(int ttl) {
        this.timeToLive = ttl;
        this.updateScheduledUndo();
    }

    @Override
    public void updateScheduledUndo() {
        if (this.timeToLive > 0) {
            this.scheduledTime = System.currentTimeMillis() + (long)this.timeToLive;
        }
    }

    @Override
    public int getScheduledUndo() {
        return this.timeToLive;
    }

    @Override
    public boolean hasChanges() {
        return this.size() > 0 || this.runnables != null && !this.runnables.isEmpty() || this.entities != null && !this.entities.isEmpty() || this.undoEntityEffects && this.modifiedEntities != null && !this.modifiedEntities.isEmpty();
    }

    @Override
    public void clearAttachables(Block block) {
        this.clearAttachables(block, BlockFace.NORTH, attachablesWall);
        this.clearAttachables(block, BlockFace.SOUTH, attachablesWall);
        this.clearAttachables(block, BlockFace.EAST, attachablesWall);
        this.clearAttachables(block, BlockFace.WEST, attachablesWall);
        this.clearAttachables(block, BlockFace.UP, attachables);
        this.clearAttachables(block, BlockFace.DOWN, attachablesDouble);
    }

    protected boolean clearAttachables(Block block, BlockFace direction, @Nonnull MaterialSet materials) {
        Block testBlock = block.getRelative(direction);
        long blockId = BlockData.getBlockId(testBlock);
        if (!materials.testBlock(testBlock)) {
            return false;
        }
        if (this.blockIdMap != null && this.blockIdMap.containsKey(blockId)) {
            return false;
        }
        this.add(testBlock);
        MaterialAndData.clearItems(testBlock.getState());
        DeprecatedUtils.setTypeAndData(testBlock, Material.AIR, (byte)0, false);
        return true;
    }

    @Override
    public boolean add(com.elmakers.mine.bukkit.api.block.BlockData blockData) {
        com.elmakers.mine.bukkit.api.block.BlockData attachedBlock;
        if (this.finished && this.spell != null) {
            this.spell.getController().getLogger().warning("Trying to add to a finished UndoList, this may result in blocks that don't get cleaned up: " + this.name);
            Thread.dumpStack();
        }
        if (this.bypass) {
            return true;
        }
        if (!super.add(blockData)) {
            return false;
        }
        this.worlds.add(blockData.getWorldName());
        this.modifiedTime = System.currentTimeMillis();
        if (this.watching != null && (attachedBlock = this.watching.remove(blockData.getId())) != null) {
            UndoList.removeFromWatched(attachedBlock);
        }
        UndoList.register(blockData);
        blockData.setUndoList(this);
        if (this.loading) {
            return true;
        }
        this.addAttachable(blockData, BlockFace.NORTH, attachablesWall);
        this.addAttachable(blockData, BlockFace.SOUTH, attachablesWall);
        this.addAttachable(blockData, BlockFace.EAST, attachablesWall);
        this.addAttachable(blockData, BlockFace.WEST, attachablesWall);
        this.addAttachable(blockData, BlockFace.UP, attachables);
        this.addAttachable(blockData, BlockFace.DOWN, attachablesDouble);
        return true;
    }

    @Override
    public void add(Entity entity) {
        if (entity == null) {
            return;
        }
        if (this.entities == null) {
            this.entities = new HashSet<Entity>();
        }
        if (this.worldName != null && !entity.getWorld().getName().equals(this.worldName)) {
            return;
        }
        this.entities.add(entity);
        if (this.isScheduled()) {
            entity.setMetadata("temporary", (MetadataValue)new FixedMetadataValue(this.plugin, (Object)true));
        }
        this.watch(entity);
        this.contain(entity.getLocation().toVector());
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void add(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        if (this.runnables == null) {
            this.runnables = new ArrayDeque<Runnable>();
        }
        this.runnables.add(runnable);
        this.modifiedTime = System.currentTimeMillis();
    }

    protected boolean addAttachable(com.elmakers.mine.bukkit.api.block.BlockData block, BlockFace direction, @Nonnull MaterialSet materials) {
        BlockData newBlock;
        Preconditions.checkNotNull((Object)block, (Object)"block");
        Preconditions.checkNotNull((Object)direction, (Object)"direction");
        Block baseBlock = block.getBlock();
        if (baseBlock == null) {
            return false;
        }
        Block testBlock = baseBlock.getRelative(direction);
        Long blockId = BlockData.getBlockId(testBlock);
        if (this.blockIdMap != null && this.blockIdMap.containsKey(blockId)) {
            return false;
        }
        if (this.watching != null && this.watching.containsKey(blockId)) {
            return false;
        }
        if (materials.testBlock(testBlock) && this.contain(newBlock = new BlockData(testBlock))) {
            this.registerWatched(newBlock);
            newBlock.setUndoList(this);
            if (attachablesDouble.testBlock(testBlock)) {
                if (direction != BlockFace.UP) {
                    this.add(newBlock);
                    this.addAttachable(newBlock, BlockFace.DOWN, materials);
                } else if (direction != BlockFace.DOWN) {
                    this.add(newBlock);
                    this.addAttachable(newBlock, BlockFace.UP, materials);
                }
            }
            return true;
        }
        return false;
    }

    public static com.elmakers.mine.bukkit.api.block.BlockData register(Block block) {
        BlockData blockData = new BlockData(block);
        registry.registerModified(blockData);
        return blockData;
    }

    public static void register(com.elmakers.mine.bukkit.api.block.BlockData blockData) {
        registry.registerModified(blockData);
    }

    public void registerWatched(com.elmakers.mine.bukkit.api.block.BlockData blockData) {
        registry.registerWatched(blockData);
        if (this.watching == null) {
            this.watching = new HashMap<Long, com.elmakers.mine.bukkit.api.block.BlockData>();
        }
        this.watching.put(blockData.getId(), blockData);
    }

    @Override
    public void commit() {
        this.unlink();
        this.unregisterWatched();
        if (this.blockList == null) {
            return;
        }
        for (com.elmakers.mine.bukkit.api.block.BlockData block : this.blockList) {
            UndoList.commit(block);
        }
        this.clear();
    }

    public static void commit(com.elmakers.mine.bukkit.api.block.BlockData block) {
        registry.commit(block);
    }

    public static void commitAll() {
        registry.commitAll();
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof com.elmakers.mine.bukkit.api.block.BlockData) {
            com.elmakers.mine.bukkit.api.block.BlockData block = (com.elmakers.mine.bukkit.api.block.BlockData)o;
            UndoList.removeFromModified(block);
        }
        return super.remove(o);
    }

    @Override
    public void remove(Entity entity) {
        entity.removeMetadata("MagicBlockList", this.plugin);
        if (this.entities != null) {
            this.entities.remove(entity);
        }
        UUID entityId = entity.getUniqueId();
        if (this.modifiedEntities != null) {
            this.modifiedEntities.remove(entityId);
        }
        this.modifiedTime = System.currentTimeMillis();
    }

    protected static void removeFromModified(com.elmakers.mine.bukkit.api.block.BlockData block) {
        registry.removeFromModified(block);
    }

    protected static void removeFromModified(com.elmakers.mine.bukkit.api.block.BlockData block, com.elmakers.mine.bukkit.api.block.BlockData priorState) {
        registry.removeFromModified(block, priorState);
    }

    protected static void removeFromWatched(com.elmakers.mine.bukkit.api.block.BlockData block) {
        registry.removeFromWatched(block);
    }

    @Override
    @Nullable
    public com.elmakers.mine.bukkit.api.block.BlockData undoNext(boolean applyPhysics) {
        if (this.blockList.size() == 0) {
            return null;
        }
        com.elmakers.mine.bukkit.api.block.BlockData blockData = (com.elmakers.mine.bukkit.api.block.BlockData)this.blockList.removeFirst();
        BlockState currentState = blockData.getBlock().getState();
        if (this.undo(blockData, applyPhysics)) {
            Block block;
            CastContext context;
            this.blockIdMap.remove(blockData.getId());
            if (this.consumed && !this.isScheduled() && currentState.getType() != Material.AIR && this.owner != null) {
                this.owner.giveItem(new ItemStack(currentState.getType(), 1, (short)DeprecatedUtils.getRawData(currentState)));
            }
            if ((context = this.getContext()) != null && context.hasEffects("undo_block") && (block = blockData.getBlock()).getType() != currentState.getType()) {
                context.playEffects("undo_block", 1.0f, null, null, block.getLocation(), null, block);
            }
            return blockData;
        }
        this.blockList.addFirst(blockData);
        return null;
    }

    private boolean undo(com.elmakers.mine.bukkit.api.block.BlockData undoBlock, boolean applyPhysics) {
        com.elmakers.mine.bukkit.api.block.BlockData priorState = undoBlock.getPriorState();
        if (this.undoBreakable) {
            registry.removeBreakable(undoBlock);
        }
        if (this.undoReflective) {
            registry.removeReflective(undoBlock);
        }
        if (undoBlock.undo(applyPhysics ? ModifyType.NORMAL : this.modifyType)) {
            UndoList.removeFromModified(undoBlock, priorState);
            this.registerWatched(undoBlock);
            Double remainingDamage = registry.removeDamage(undoBlock);
            if (remainingDamage != null) {
                if (remainingDamage <= 0.0) {
                    CompatibilityUtils.clearBreaking(undoBlock.getBlock());
                } else {
                    CompatibilityUtils.setBreaking(undoBlock.getBlock(), remainingDamage);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void undo() {
        this.undo(false);
    }

    @Override
    public void undo(boolean blocking) {
        if (this.spell != null) {
            this.spell.cancel();
        }
        this.undo(blocking, true);
    }

    public void undo(boolean blocking, boolean undoEntities) {
        if (this.undone) {
            return;
        }
        this.undone = true;
        if (this.batch != null && !this.batch.isFinished()) {
            this.batch.finish();
        }
        if (undoEntities) {
            this.speed = 0.0;
        }
        this.undoEntityEffects = this.undoEntityEffects || undoEntities;
        this.unlink();
        CastContext context = this.getContext();
        if (context != null) {
            context.cancelEffects();
        }
        if (this.runnables != null) {
            for (Runnable runnable : this.runnables) {
                runnable.run();
            }
            this.runnables = null;
        }
        if (this.blockList == null) {
            this.undoEntityEffects();
            return;
        }
        UndoBatch batch = new UndoBatch(this);
        if (blocking) {
            while (!batch.isFinished()) {
                batch.process(1000);
            }
        } else {
            this.owner.addUndoBatch(batch);
        }
    }

    public void undoEntityEffects() {
        if (this.entities != null || this.modifiedEntities != null) {
            if (this.entities != null) {
                for (Entity entity : this.entities) {
                    if (entity == null) continue;
                    if (!entity.isValid()) {
                        if (!entity.getLocation().getChunk().isLoaded()) {
                            entity.getLocation().getChunk().load();
                        }
                        entity = CompatibilityUtils.getEntity(entity.getWorld(), entity.getUniqueId());
                    }
                    if (entity == null || !entity.isValid()) continue;
                    CastContext context = this.getContext();
                    if (context != null && context.hasEffects("undo_entity")) {
                        context.playEffects("undo_entity", 1.0f, null, null, entity.getLocation(), entity, null);
                    }
                    UndoList.setUndoList(this.plugin, entity, null);
                    entity.remove();
                }
                this.entities = null;
            }
            if (this.modifiedEntities != null) {
                for (EntityData data : this.modifiedEntities.values()) {
                    Entity entity = data.getEntity();
                    if (entity != null) {
                        UndoList.setUndoList(this.plugin, entity, null);
                    }
                    if (!this.undoEntityEffects && this.undoEntityTypes != null && !this.undoEntityTypes.contains(data.getType())) continue;
                    CastContext context = this.getContext();
                    if (context != null && entity != null && context.hasEffects("undo_entity")) {
                        context.playEffects("undo_entity", 1.0f, null, null, entity.getLocation(), entity, null);
                    }
                    data.undo();
                    if (entity != null || context == null || (entity = data.getEntity()) == null || !context.hasEffects("undo_entity")) continue;
                    context.playEffects("undo_entity", 1.0f, null, null, entity.getLocation(), entity, null);
                }
                this.modifiedEntities = null;
            }
        }
    }

    @Override
    public boolean isUndone() {
        return this.undone;
    }

    @Override
    public boolean isUnbreakable() {
        return this.unbreakable;
    }

    @Override
    public void setUnbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
    }

    @Override
    public void undoScheduled(boolean blocking) {
        this.undo(blocking, false);
        if (this.isScheduled()) {
            this.owner.getController().cancelScheduledUndo(this);
        }
    }

    @Override
    public void undoScheduled() {
        this.undo(false, false);
    }

    public void unregisterWatched() {
        if (this.watching != null) {
            for (com.elmakers.mine.bukkit.api.block.BlockData block : this.watching.values()) {
                UndoList.removeFromWatched(block);
            }
            this.watching = null;
        }
    }

    public void finish() {
        this.finished = true;
    }

    @Override
    public void load(ConfigurationSection node) {
        this.loading = true;
        super.load(node);
        this.loading = false;
        this.timeToLive = node.getInt("time_to_live", this.timeToLive);
        this.name = node.getString("name", this.name);
        String typeName = node.getString("mode", "");
        if (!typeName.isEmpty()) {
            try {
                this.modifyType = ModifyType.valueOf(typeName);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.consumed = node.getBoolean("consumed", this.consumed);
    }

    @Override
    public void save(ConfigurationSection node) {
        super.save(node);
        node.set("time_to_live", (Object)this.timeToLive);
        node.set("name", (Object)this.name);
        if (this.modifyType != ModifyType.NORMAL) {
            node.set("mode", (Object)this.modifyType.name());
        }
        if (this.consumed) {
            node.set("consumed", (Object)true);
        }
    }

    public void watch(Entity entity) {
        if (entity == null) {
            return;
        }
        if (this.worldName != null && !entity.getWorld().getName().equals(this.worldName)) {
            return;
        }
        if (this.worldName == null) {
            this.worldName = entity.getWorld().getName();
        }
        if (!entity.hasMetadata("MagicBlockList")) {
            UndoList.setUndoList(this.plugin, entity, this);
        }
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    @Nullable
    public EntityData modify(Entity entity) {
        EntityData entityData = null;
        if (entity == null || entity.hasMetadata("notarget")) {
            return entityData;
        }
        if (this.worldName != null && !entity.getWorld().getName().equals(this.worldName)) {
            return entityData;
        }
        if (this.worldName == null) {
            this.worldName = entity.getWorld().getName();
        }
        if (this.entities != null && this.entities.contains(entity) && !entity.isValid()) {
            this.entities.remove(entity);
        } else if (entity.isValid()) {
            UUID entityId;
            if (this.modifiedEntities == null) {
                this.modifiedEntities = new HashMap();
            }
            if ((entityData = this.modifiedEntities.get(entityId = entity.getUniqueId())) == null) {
                entityData = new EntityData(entity);
                this.modifiedEntities.put(entityId, entityData);
                this.watch(entity);
            }
        }
        this.modifiedTime = System.currentTimeMillis();
        return entityData;
    }

    @Override
    @Nullable
    public EntityData damage(Entity entity) {
        EntityData data = this.modify(entity);
        if (this.undoEntityTypes != null && this.undoEntityTypes.contains(entity.getType()) && entity instanceof Hanging) {
            entity.remove();
        }
        if (data != null) {
            data.setRespawn(true);
            data.setDamaged(true);
        }
        return data;
    }

    @Override
    public void move(Entity entity) {
        EntityData entityData = this.modify(entity);
        if (entityData != null) {
            entityData.setHasMoved(true);
        }
    }

    @Override
    public void modifyVelocity(Entity entity) {
        EntityData entityData = this.modify(entity);
        if (entityData != null) {
            entityData.setHasVelocity(true);
        }
    }

    @Override
    public void addPotionEffects(Entity entity) {
        EntityData entityData = this.modify(entity);
        if (entityData != null) {
            entityData.setHasPotionEffects(true);
        }
    }

    @Override
    public void addPotionEffectForRemoval(Entity entity, PotionEffectType potionEffectType) {
        EntityData entityData = this.modify(entity);
        if (entityData != null) {
            entityData.addPotionEffectForRemoval(potionEffectType);
        }
    }

    @Override
    public void addModifier(Entity entity, MageModifier modifier) {
        EntityData entityData = this.modify(entity);
        if (entityData != null) {
            entityData.addModifier(modifier);
        }
    }

    @Override
    public void addModifierForRemoval(Entity entity, String modifierKey) {
        EntityData entityData = this.modify(entity);
        if (entityData != null) {
            entityData.addModifierForRemoval(modifierKey);
        }
    }

    @Override
    public void convert(Entity fallingBlock, Block block) {
        this.remove(fallingBlock);
        this.add(block);
    }

    @Override
    public void fall(Entity fallingBlock, Block block) {
        if (this.isScheduled() && fallingBlock instanceof FallingBlock) {
            ((FallingBlock)fallingBlock).setDropItem(false);
        }
        this.add(fallingBlock);
        this.add(block);
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void explode(Entity explodingEntity, List<Block> blocks) {
        for (Block block : blocks) {
            this.add(block);
        }
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void finalizeExplosion(Entity explodingEntity, List<Block> blocks) {
        this.remove(explodingEntity);
        if (this.isScheduled()) {
            for (Block block : blocks) {
                BlockState state = block.getState();
                if (state instanceof InventoryHolder) {
                    InventoryHolder holder = (InventoryHolder)state;
                    holder.getInventory().clear();
                    state.update();
                }
                block.setType(Material.AIR);
            }
        }
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public void cancelExplosion(Entity explodingEntity) {
        this.remove(explodingEntity);
    }

    @Override
    public boolean bypass() {
        return this.bypass;
    }

    @Override
    public void setBypass(boolean bypass) {
        this.bypass = bypass;
    }

    @Override
    public long getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public long getModifiedTime() {
        return this.modifiedTime;
    }

    @Override
    public boolean contains(Location location, int threshold) {
        if (location == null || this.area == null || this.worldName == null) {
            return false;
        }
        if (!location.getWorld().getName().equals(this.worldName)) {
            return false;
        }
        return this.area.contains(location.toVector(), threshold);
    }

    @Override
    public void prune() {
        if (this.blockList == null) {
            return;
        }
        Iterator<com.elmakers.mine.bukkit.api.block.BlockData> iterator = this.iterator();
        while (iterator.hasNext()) {
            com.elmakers.mine.bukkit.api.block.BlockData block = iterator.next();
            if (block.isDifferent()) continue;
            this.removeFromMap(block);
            iterator.remove();
        }
        this.modifiedTime = System.currentTimeMillis();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Spell getSpell() {
        return this.spell;
    }

    @Override
    public Mage getOwner() {
        return this.owner;
    }

    @Override
    @Nullable
    public CastContext getContext() {
        return this.context == null ? null : (CastContext)this.context.get();
    }

    @Override
    public long getScheduledTime() {
        return this.scheduledTime;
    }

    @Override
    public boolean isScheduled() {
        return this.timeToLive > 0;
    }

    @Override
    public int compareTo(com.elmakers.mine.bukkit.api.block.UndoList o) {
        return Long.compare(this.scheduledTime, o.getScheduledTime());
    }

    @Override
    public boolean hasBeenScheduled() {
        return this.hasBeenScheduled;
    }

    @Override
    public void setHasBeenScheduled() {
        this.hasBeenScheduled = true;
    }

    @Override
    public void setEntityUndo(boolean undoEntityEffects) {
        this.undoEntityEffects = undoEntityEffects;
    }

    @Override
    public void setSorted(boolean sorted) {
        this.sorted = sorted;
    }

    @Override
    public void setReversed(boolean reverse) {
        this.reverse = reverse;
    }

    @Override
    public void setEntityUndoTypes(Set<EntityType> undoTypes) {
        this.undoEntityTypes = undoTypes;
    }

    public void setNext(UndoList next) {
        this.next = next;
    }

    public void setPrevious(UndoList previous) {
        this.previous = previous;
    }

    public void setUndoQueue(com.elmakers.mine.bukkit.api.block.UndoQueue undoQueue) {
        if (undoQueue != null && undoQueue instanceof UndoQueue) {
            this.undoQueue = (UndoQueue)undoQueue;
        }
    }

    public boolean hasUndoQueue() {
        return this.undoQueue != null;
    }

    public void unlink() {
        if (this.undoQueue != null) {
            this.undoQueue.removed(this);
            this.undoQueue = null;
        }
        if (this.next != null) {
            this.next.previous = this.previous;
        }
        if (this.previous != null) {
            this.previous.next = this.next;
        }
        this.previous = null;
        this.next = null;
    }

    public UndoList getNext() {
        return this.next;
    }

    public UndoList getPrevious() {
        return this.previous;
    }

    @Override
    public void setApplyPhysics(boolean applyPhysics) {
        if (applyPhysics) {
            this.modifyType = ModifyType.NORMAL;
        } else if (this.modifyType != ModifyType.FAST) {
            this.modifyType = ModifyType.NO_PHYSICS;
        }
    }

    @Override
    public boolean getApplyPhysics() {
        return this.modifyType == ModifyType.NORMAL;
    }

    @Override
    public void setModifyType(ModifyType modifyType) {
        this.modifyType = modifyType;
    }

    @Override
    public ModifyType getModifyType() {
        return this.modifyType;
    }

    @Nullable
    public static com.elmakers.mine.bukkit.api.block.UndoList getUndoList(Entity entity) {
        Location entityLocation;
        com.elmakers.mine.bukkit.api.block.UndoList blockList = null;
        if (entity != null && entity.hasMetadata("MagicBlockList")) {
            List values = entity.getMetadata("MagicBlockList");
            for (MetadataValue metadataValue : values) {
                Object value = metadataValue.value();
                if (!(value instanceof com.elmakers.mine.bukkit.api.block.UndoList)) continue;
                blockList = (com.elmakers.mine.bukkit.api.block.UndoList)value;
            }
        } else if (entity != null && entity instanceof FallingBlock && (blockList = UndoList.getUndoList(entityLocation = entity.getLocation())) == null) {
            entityLocation.setY(entityLocation.getY() - 1.0);
            blockList = UndoList.getUndoList(entityLocation);
        }
        return blockList;
    }

    @Nullable
    public static com.elmakers.mine.bukkit.api.block.UndoList getUndoList(Location location) {
        com.elmakers.mine.bukkit.api.block.BlockData blockData = UndoList.getBlockData(location);
        return blockData == null ? null : blockData.getUndoList();
    }

    public static void setUndoList(Plugin plugin, Entity entity, com.elmakers.mine.bukkit.api.block.UndoList list) {
        if (entity != null) {
            if (list != null) {
                entity.setMetadata("MagicBlockList", (MetadataValue)new FixedMetadataValue(plugin, (Object)list));
            } else {
                entity.removeMetadata("MagicBlockList", plugin);
            }
        }
    }

    @Override
    public EntityData getEntityData(Entity entity) {
        return this.modifiedEntities.get(entity.getUniqueId());
    }

    @Nullable
    public static com.elmakers.mine.bukkit.api.block.BlockData getBlockData(Location location) {
        return registry.getBlockData(location);
    }

    public static UndoRegistry getRegistry() {
        return registry;
    }

    @Override
    public void setUndoBreakable(boolean breakable) {
        this.undoBreakable = breakable;
    }

    @Override
    public void setUndoReflective(boolean reflective) {
        this.undoReflective = reflective;
    }

    @Override
    @Deprecated
    public void setUndoBreaking(boolean breaking) {
    }

    @Override
    public void addDamage(Block block, double damage) {
        com.elmakers.mine.bukkit.api.block.BlockData blockData = this.get(block);
        blockData.addDamage(damage);
    }

    @Override
    public Collection<Entity> getAllEntities() {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        if (this.entities != null) {
            for (Entity entity : this.entities) {
                if (entity == null) continue;
                entities.add(entity);
            }
        }
        if (this.modifiedEntities != null) {
            for (EntityData entityData : this.modifiedEntities.values()) {
                Entity entity = entityData.getEntity();
                if (entity == null) continue;
                entities.add(entity);
            }
        }
        return entities;
    }

    public void sort(MaterialSet attachables) {
        if (this.blockList == null) {
            return;
        }
        ArrayList sortedList = new ArrayList(this.blockList);
        this.blockList.clear();
        if (this.reverse) {
            Collections.reverse(sortedList);
        }
        if (attachables != null && this.sorted) {
            blockComparator.setAttachables(attachables);
            Collections.sort(sortedList, blockComparator);
        }
        this.blockList.addAll(sortedList);
    }

    public double getUndoSpeed() {
        return this.speed;
    }

    @Override
    public void setUndoSpeed(double speed) {
        this.speed = speed;
    }

    @Override
    public boolean isConsumed() {
        return this.consumed;
    }

    @Override
    public void setConsumed(boolean consumed) {
        this.consumed = consumed;
    }

    public void removeFromMap(com.elmakers.mine.bukkit.api.block.BlockData blockData) {
        UndoList.removeFromModified(blockData);
        this.blockIdMap.remove(blockData.getId());
    }

    @Override
    public int getRunnableCount() {
        return this.runnables == null ? 0 : this.runnables.size();
    }

    @Override
    @Nullable
    public Runnable undoNextRunnable() {
        Runnable undone = null;
        if (this.runnables != null && !this.runnables.isEmpty()) {
            undone = this.runnables.pop();
            undone.run();
        }
        return undone;
    }

    @Override
    public boolean isUndoType(EntityType entityType) {
        return this.undoEntityTypes != null && this.undoEntityTypes.contains(entityType);
    }

    @Override
    public boolean affectsWorld(@Nonnull World world) {
        Preconditions.checkNotNull((Object)world);
        return this.worlds.contains(world.getName());
    }
}

