/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageModifier;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BaseSpell;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class ModifierAction
extends BaseSpellAction {
    private List<String> removeModifiers;
    private Map<String, ConfigurationSection> addModifiers;
    private int duration;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.removeModifiers = parameters.getStringList("remove_modifiers");
        ConfigurationSection addSection = parameters.getConfigurationSection("add_modifiers");
        if (addSection == null) {
            List<String> addList = ConfigurationUtils.getStringList(parameters, "add_modifiers");
            if (addList != null) {
                this.addModifiers = new HashMap<String, ConfigurationSection>();
                for (String addKey : addList) {
                    this.addModifiers.put(addKey, null);
                }
            }
        } else {
            this.addModifiers = new HashMap<String, ConfigurationSection>();
            for (String addKey : addSection.getKeys(false)) {
                this.addModifiers.put(addKey, addSection.getConfigurationSection(addKey));
            }
        }
        this.duration = parameters.getInt("duration");
        if (parameters.contains("duration_multiplier")) {
            this.duration = (int)Math.ceil(parameters.getDouble("duration_multiplier") * (double)this.duration);
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        Entity targetEntity = context.getTargetEntity();
        Mage targetMage = context.getController().getMage(targetEntity);
        boolean effected = false;
        if (this.removeModifiers != null) {
            for (String remove : this.removeModifiers) {
                MageModifier removed = targetMage.removeModifier(remove);
                if (removed == null) continue;
                context.registerModifier(targetEntity, removed);
                effected = true;
            }
        }
        if (this.addModifiers != null && !this.addModifiers.isEmpty()) {
            effected = true;
            for (String key : this.addModifiers.keySet()) {
                int duration = this.duration;
                ConfigurationSection configuration = this.addModifiers.get(key);
                if (configuration != null) {
                    duration = configuration.getInt("duration", duration);
                }
                if (!targetMage.addModifier(key, duration, configuration)) continue;
                context.registerModifierForRemoval(targetEntity, key);
                effected = true;
            }
        }
        return effected ? SpellResult.CAST : SpellResult.NO_TARGET;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public boolean requiresTargetEntity() {
        return true;
    }

    @Override
    public void getParameterNames(Spell spell, Collection<String> parameters) {
        super.getParameterNames(spell, parameters);
        parameters.add("duration");
    }

    @Override
    public void getParameterOptions(Spell spell, String parameterKey, Collection<String> examples) {
        if (parameterKey.equals("duration")) {
            examples.addAll(Arrays.asList(BaseSpell.EXAMPLE_DURATIONS));
        } else {
            super.getParameterOptions(spell, parameterKey, examples);
        }
    }
}

