/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utility;

import com.elmakers.mine.bukkit.block.Schematic;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.util.Vector;

public class SchematicUtils
extends CompatibilityUtils {
    public static boolean loadSchematic(File inputFile, Schematic schematic) {
        if (inputFile == null || !inputFile.exists() || schematic == null) {
            return false;
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(inputFile);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return SchematicUtils.loadSchematic(inputStream, schematic);
    }

    public static boolean loadSchematic(InputStream input, Schematic schematic) {
        if (input == null || schematic == null || class_NBTCompressedStreamTools_loadFileMethod == null) {
            return false;
        }
        try {
            int i;
            int size;
            Object nbtData = class_NBTCompressedStreamTools_loadFileMethod.invoke(null, input);
            if (nbtData == null) {
                return false;
            }
            String materials = (String)class_NBTTagCompound_getStringMethod.invoke(nbtData, "Materials");
            if (!materials.equals("Alpha")) {
                Bukkit.getLogger().warning("Schematic is not in Alpha format");
                return false;
            }
            short width = (Short)class_NBTTagCompound_getShortMethod.invoke(nbtData, "Width");
            short height = (Short)class_NBTTagCompound_getShortMethod.invoke(nbtData, "Height");
            short length = (Short)class_NBTTagCompound_getShortMethod.invoke(nbtData, "Length");
            byte[] blockIds = (byte[])class_NBTTagCompound_getByteArrayMethod.invoke(nbtData, "Blocks");
            short[] blocks = new short[blockIds.length];
            byte[] addBlocks = new byte[]{};
            if (((Boolean)class_NBTTagCompound_hasKeyMethod.invoke(nbtData, "AddBlocks")).booleanValue()) {
                addBlocks = (byte[])class_NBTTagCompound_getByteArrayMethod.invoke(nbtData, "AddBlocks");
            }
            for (int index = 0; index < blocks.length; ++index) {
                blocks[index] = index >> 1 >= addBlocks.length ? (short)(blockIds[index] & 0xFF) : ((index & 1) == 0 ? (short)(((addBlocks[index >> 1] & 0xF) << 8) + (blockIds[index] & 0xFF)) : (short)(((addBlocks[index >> 1] & 0xF0) << 4) + (blockIds[index] & 0xFF)));
            }
            byte[] data = (byte[])class_NBTTagCompound_getByteArrayMethod.invoke(nbtData, "Data");
            ArrayList<Object> tileEntityData = new ArrayList<Object>();
            ArrayList<Object> entityData = new ArrayList<Object>();
            Object entityList = class_NBTTagCompound_getListMethod.invoke(nbtData, "Entities", 10);
            Object tileEntityList = class_NBTTagCompound_getListMethod.invoke(nbtData, "TileEntities", 10);
            if (entityList != null) {
                size = (Integer)class_NBTTagList_sizeMethod.invoke(entityList, new Object[0]);
                for (i = 0; i < size; ++i) {
                    Object entity = class_NBTTagList_getMethod.invoke(entityList, i);
                    entityData.add(entity);
                }
            }
            if (tileEntityList != null) {
                size = (Integer)class_NBTTagList_sizeMethod.invoke(tileEntityList, new Object[0]);
                for (i = 0; i < size; ++i) {
                    Object tileEntity = class_NBTTagList_getMethod.invoke(tileEntityList, i);
                    tileEntityData.add(tileEntity);
                }
            }
            int originX = (Integer)class_NBTTagCompound_getIntMethod.invoke(nbtData, "WEOriginX");
            int originY = (Integer)class_NBTTagCompound_getIntMethod.invoke(nbtData, "WEOriginY");
            int originZ = (Integer)class_NBTTagCompound_getIntMethod.invoke(nbtData, "WEOriginZ");
            int offsetX = (Integer)class_NBTTagCompound_getIntMethod.invoke(nbtData, "WEOffsetX");
            int offsetY = (Integer)class_NBTTagCompound_getIntMethod.invoke(nbtData, "WEOffsetY");
            int offsetZ = (Integer)class_NBTTagCompound_getIntMethod.invoke(nbtData, "WEOffsetZ");
            schematic.load(width, height, length, blocks, data, tileEntityData, entityData, new Vector(originX, originY, originZ), new Vector(offsetX, offsetY, offsetZ));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }
}

