/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.effect.EffectPlayer;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.Trigger;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import com.elmakers.mine.bukkit.utility.WeightedPair;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class MobTrigger
extends Trigger {
    protected Deque<WeightedPair<String>> spells;
    protected Collection<EffectPlayer> effects;
    protected List<String> commands;

    public MobTrigger(@Nonnull MageController controller, @Nonnull String key, @Nonnull ConfigurationSection configuration) {
        super(controller, configuration, key);
        if (configuration.contains("cast")) {
            this.spells = new ArrayDeque<WeightedPair<String>>();
            RandomUtils.populateStringProbabilityMap(this.spells, configuration, "cast");
        }
        this.commands = ConfigurationUtils.getStringList(configuration, "commands");
        if (configuration.contains("effects")) {
            this.effects = controller.loadEffects(configuration, "effects");
        }
    }

    private void cast(Mage mage, String castSpell) {
        if (castSpell.length() > 0) {
            double bowpull;
            String[] parameters = null;
            MageSpell spell = null;
            if (!castSpell.equalsIgnoreCase("none")) {
                if (castSpell.contains(" ")) {
                    parameters = StringUtils.split((String)castSpell, (char)' ');
                    castSpell = parameters[0];
                    parameters = Arrays.copyOfRange(parameters, 1, parameters.length);
                }
                spell = mage.getSpell(castSpell);
            }
            if ((bowpull = mage.getLastBowPull()) > 0.0) {
                if (parameters == null) {
                    parameters = new String[]{"bowpull", Double.toString(bowpull)};
                } else {
                    String[] existing = parameters;
                    parameters = new String[existing.length + 2];
                    System.arraycopy(existing, 0, parameters, 0, existing.length);
                    parameters[existing.length - 2] = "bowpull";
                    parameters[existing.length - 1] = Double.toString(bowpull);
                }
            }
            if (spell != null) {
                spell.cast(parameters);
            }
        }
    }

    public boolean execute(Mage mage) {
        if (!this.isValid(mage)) {
            return false;
        }
        this.triggered();
        if (this.effects != null) {
            for (EffectPlayer player : this.effects) {
                player.start(mage.getEffectContext());
            }
        }
        if (this.spells != null && !this.spells.isEmpty()) {
            String spell = (String)RandomUtils.weightedRandom(this.spells);
            this.cast(mage, spell);
        }
        if (this.commands != null) {
            Entity topDamager = mage.getTopDamager();
            Entity killer = mage.getLastDamager();
            Collection<Entity> damagers = mage.getDamagers();
            Location location = mage.getLocation();
            for (String command : this.commands) {
                boolean allDamagers;
                if (command.contains("@killer")) {
                    if (killer == null) continue;
                    command = command.replace("@killer", killer.getName());
                }
                if ((allDamagers = command.contains("@damagers")) && damagers == null) continue;
                if (!allDamagers && command.contains("@damager")) {
                    if (topDamager == null) continue;
                    command = command.replace("@damager", topDamager.getName());
                }
                command = command.replace("@name", mage.getName()).replace("@world", location.getWorld().getName()).replace("@x", Double.toString(location.getX())).replace("@y", Double.toString(location.getY())).replace("@z", Double.toString(location.getZ()));
                if (allDamagers) {
                    for (Entity damager : damagers) {
                        String damagerCommand = command.replace("@damagers", damager.getName());
                        mage.getController().getPlugin().getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), damagerCommand);
                    }
                    continue;
                }
                mage.getController().getPlugin().getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), command);
            }
        }
        return true;
    }
}

