/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.automata;

import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.effect.EffectPlayer;
import com.elmakers.mine.bukkit.automata.AutomatonTemplate;
import com.elmakers.mine.bukkit.block.BlockData;
import com.elmakers.mine.bukkit.effect.EffectContext;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;

public class Automaton {
    @Nonnull
    private final MagicController controller;
    @Nullable
    private AutomatonTemplate template;
    @Nullable
    private ConfigurationSection parameters;
    private String templateKey;
    @Nonnull
    private final Location location;
    private long createdAt;
    private String creatorId;
    private String creatorName;
    private long nextTick;
    private List<WeakReference<Entity>> spawned;
    private EffectContext effectContext;
    private boolean isActive;
    private Mage mage;

    public Automaton(@Nonnull MagicController controller, @Nonnull ConfigurationSection node) {
        World world;
        this.controller = controller;
        this.templateKey = node.getString("template");
        this.parameters = ConfigurationUtils.getConfigurationSection(node, "parameters");
        if (this.templateKey != null) {
            this.setTemplate(controller.getAutomatonTemplate(this.templateKey));
        }
        if (this.template == null) {
            controller.getLogger().warning("Automaton missing template: " + this.templateKey);
        }
        this.createdAt = node.getLong("created", 0L);
        this.creatorId = node.getString("creator");
        this.creatorName = node.getString("creator_name");
        double x = node.getDouble("x");
        double y = node.getDouble("y");
        double z = node.getDouble("z");
        float yaw = (float)node.getDouble("yaw");
        float pitch = (float)node.getDouble("pitch");
        String worldName = node.getString("world");
        if (worldName == null || worldName.isEmpty()) {
            worldName = "world";
            controller.getLogger().warning("Automaton missing world name, defaulting to 'world'");
        }
        if ((world = Bukkit.getWorld((String)worldName)) == null) {
            controller.getLogger().warning("Automaton has unknown world: " + worldName + ", will be removed!");
        }
        this.location = new Location(world, x, y, z, yaw, pitch);
    }

    public Automaton(@Nonnull MagicController controller, @Nonnull Location location, @Nonnull String templateKey, String creatorId, String creatorName, @Nullable ConfigurationSection parameters) {
        this.controller = controller;
        this.templateKey = templateKey;
        this.parameters = parameters;
        this.location = location;
        this.setTemplate(controller.getAutomatonTemplate(templateKey));
        this.createdAt = System.currentTimeMillis();
        this.creatorId = creatorId;
        this.creatorName = creatorName;
    }

    private void setTemplate(AutomatonTemplate template) {
        this.template = template;
        if (template != null) {
            if (this.parameters != null) {
                this.template = template.getVariant(this.parameters);
            }
            this.nextTick = 0L;
        }
    }

    public void reload() {
        if (this.template != null) {
            this.setTemplate(this.controller.getAutomatonTemplate(this.template.getKey()));
        }
    }

    public void save(ConfigurationSection node) {
        node.set("created", (Object)this.createdAt);
        node.set("creator", (Object)this.creatorId);
        node.set("creatorName", (Object)this.creatorName);
        node.set("template", (Object)this.templateKey);
        node.set("world", (Object)this.location.getWorld().getName());
        node.set("x", (Object)this.location.getX());
        node.set("y", (Object)this.location.getY());
        node.set("z", (Object)this.location.getZ());
        node.set("yaw", (Object)Float.valueOf(this.location.getYaw()));
        node.set("pitch", (Object)Float.valueOf(this.location.getPitch()));
        node.set("parameters", (Object)this.parameters);
    }

    public long getCreatedTime() {
        return this.createdAt;
    }

    public void pause() {
        this.deactivate();
    }

    public void resume() {
        if (this.template == null) {
            return;
        }
        this.tick();
    }

    public void activate() {
        this.isActive = true;
        Collection<EffectPlayer> effects = this.template.getEffects();
        if (effects != null) {
            for (EffectPlayer player : effects) {
                player.start(this.getEffectContext());
            }
        }
    }

    public void deactivate() {
        this.isActive = false;
        if (this.spawned != null) {
            for (WeakReference<Entity> mobReference : this.spawned) {
                Entity mob = (Entity)mobReference.get();
                if (mob == null || !mob.isValid()) continue;
                mob.remove();
            }
        }
        if (this.effectContext != null) {
            this.effectContext.cancelEffects();
            this.effectContext = null;
        }
        if (this.mage != null) {
            this.mage.deactivate();
            this.mage.undoScheduled();
            if (this.template != null && this.template.isUndoAll()) {
                UndoList undone = this.mage.undo();
                while (undone != null) {
                    undone = this.mage.undo();
                }
            }
            this.controller.forgetMage(this.mage);
            this.mage = null;
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public Location getLocation() {
        return this.location;
    }

    public void track(List<Entity> entities) {
        if (this.spawned == null) {
            this.spawned = new ArrayList<WeakReference<Entity>>();
        }
        for (Entity entity : entities) {
            this.spawned.add(new WeakReference<Entity>(entity));
        }
    }

    public void checkEntities() {
        if (this.spawned == null) {
            return;
        }
        Iterator<WeakReference<Entity>> iterator = this.spawned.iterator();
        while (iterator.hasNext()) {
            WeakReference<Entity> mobReference = iterator.next();
            Entity mob = (Entity)mobReference.get();
            if (mob != null && mob.isValid()) continue;
            iterator.remove();
        }
    }

    public void tick() {
        if (this.template == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now < this.nextTick) {
            return;
        }
        this.template.tick(this);
        this.nextTick = now + (long)this.template.getInterval();
    }

    public long getId() {
        return BlockData.getBlockId(this.getLocation());
    }

    public boolean isValid() {
        return this.location.getWorld() != null;
    }

    @Nonnull
    public String getTemplateKey() {
        return this.templateKey;
    }

    @Nonnull
    private EffectContext getEffectContext() {
        if (this.effectContext == null) {
            this.effectContext = new EffectContext(this.controller, this.location);
        }
        return this.effectContext;
    }

    @Nullable
    public ConfigurationSection getParameters() {
        return this.parameters;
    }

    public void setParameters(@Nullable ConfigurationSection parameters) {
        this.parameters = parameters;
    }

    @Nullable
    public String getCreatorName() {
        return this.creatorName;
    }

    @Nonnull
    public Mage getMage() {
        if (this.mage == null) {
            String automatonId = UUID.randomUUID().toString();
            this.mage = this.controller.getAutomaton(automatonId, this.template.getName());
            this.mage.setLocation(this.location);
        }
        return this.mage;
    }
}

