/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.VariableScope;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.api.spell.Spell;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;

public class ModifyVariableAction
extends BaseSpellAction {
    private String key;
    private boolean hasValue;
    private double value;
    private boolean clear;
    private VariableScope scope = VariableScope.CAST;

    private void checkDefaults(ConfigurationSection variables, ConfigurationSection parameters) {
        if (!this.clear && !variables.contains(this.key)) {
            double defaultValue = parameters.getDouble("default", 0.0);
            variables.set(this.key, (Object)defaultValue);
        } else if (this.clear && variables.contains(this.key)) {
            variables.set(this.key, null);
        }
    }

    private void parseScope(ConfigurationSection parameters, Logger logger) {
        this.scope = ConfigurationUtils.parseScope(parameters.getString("scope"), this.scope, logger);
    }

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        this.key = parameters.getString("variable", "");
        this.clear = parameters.getBoolean("clear");
        this.parseScope(parameters, spell.getController().getLogger());
        switch (this.scope) {
            case SPELL: {
                this.checkDefaults(spell.getVariables(), parameters);
                break;
            }
            case MAGE: {
                Mage mage;
                if (!(spell instanceof MageSpell) || (mage = ((MageSpell)spell).getMage()) == null) break;
                this.checkDefaults(mage.getVariables(), parameters);
                break;
            }
        }
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        this.parseScope(parameters, context.getLogger());
        this.key = parameters.getString("variable", "");
        this.clear = parameters.getBoolean("clear");
        this.checkDefaults(context.getVariables(this.scope), parameters);
        String testValue = parameters.getString("value");
        boolean bl = this.hasValue = testValue != null && !testValue.isEmpty();
        if (this.hasValue) {
            this.value = parameters.getDouble("value", 0.0);
        }
    }

    @Override
    public SpellResult perform(CastContext context) {
        if (!this.hasValue) {
            return SpellResult.NO_ACTION;
        }
        ConfigurationSection variables = context.getVariables(this.scope);
        if (this.clear) {
            if (!variables.contains(this.key)) {
                return SpellResult.NO_TARGET;
            }
            variables.set(this.key, null);
        } else {
            if (variables.contains(this.key) && variables.getDouble(this.key) == this.value) {
                return SpellResult.NO_TARGET;
            }
            variables.set(this.key, (Object)this.value);
        }
        context.getSpell().reloadParameters(context);
        return SpellResult.CAST;
    }
}

