/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.wand;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.MagicPropertyType;
import com.elmakers.mine.bukkit.magic.BaseMagicConfigurable;
import com.elmakers.mine.bukkit.magic.BaseMagicProperties;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MageClass;
import com.elmakers.mine.bukkit.magic.TemplatedProperties;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.wand.WandTemplate;
import javax.annotation.Nullable;
import org.bukkit.configuration.ConfigurationSection;

public abstract class WandProperties
extends TemplatedProperties {
    protected BaseMagicProperties wandTemplate;
    protected MageClass mageClass;

    public WandProperties(MageController controller) {
        super(MagicPropertyType.WAND, controller);
    }

    public void setWandTemplate(WandTemplate template) {
        Mage mage = this.getMage();
        if (mage != null) {
            template = template.getMageTemplate(mage);
        }
        this.wandTemplate = template;
    }

    public void setMageClass(MageClass mageClass) {
        this.mageClass = mageClass;
    }

    @Override
    public void clear() {
        super.clear();
        this.wandTemplate = null;
    }

    @Override
    public boolean hasProperty(String key) {
        BaseMagicConfigurable storage = this.getStorage(key);
        if (storage != null) {
            return storage.hasOwnProperty(key);
        }
        return this.hasOwnProperty(key) || this.wandTemplate != null && this.wandTemplate.hasProperty(key);
    }

    @Override
    public boolean hasOwnProperty(String key) {
        return super.hasOwnProperty(key) || this.wandTemplate != null && this.wandTemplate.hasOwnProperty(key);
    }

    @Override
    protected void migrateProperty(String key, MagicPropertyType propertyType) {
        super.migrateProperty(key, propertyType, this.wandTemplate);
    }

    @Override
    @Nullable
    public Object getInheritedProperty(String key) {
        Object value = super.getProperty(key);
        if (value == null && this.wandTemplate != null) {
            value = this.wandTemplate.getProperty(key);
        }
        if (value == null && this.mageClass != null) {
            value = this.mageClass.getInheritedProperty(key);
        }
        return value;
    }

    @Override
    @Nullable
    public ConfigurationSection getPropertyConfiguration(String key) {
        BaseMagicConfigurable storage = this.getStorage(key);
        if (storage != null && storage != this) {
            return storage.getPropertyConfiguration(key);
        }
        if (this.configuration.contains(key)) {
            return this.configuration;
        }
        return this.wandTemplate == null ? this.configuration : this.wandTemplate.getConfiguration();
    }

    public ConfigurationSection getEffectiveConfiguration() {
        ConfigurationSection effectiveConfiguration = ConfigurationUtils.cloneConfiguration(this.getConfiguration());
        if (this.wandTemplate != null) {
            ConfigurationSection parentConfiguration = this.wandTemplate.getConfiguration();
            ConfigurationUtils.overlayConfigurations(effectiveConfiguration, parentConfiguration);
        }
        if (this.mageClass != null) {
            ConfigurationSection classConfiguration = this.mageClass.getConfiguration();
            ConfigurationUtils.overlayConfigurations(effectiveConfiguration, classConfiguration);
        }
        return effectiveConfiguration;
    }
}

