/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.magic.MageParameters;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bukkit.configuration.ConfigurationSection;

public class SpellParameters
extends MageParameters {
    @Nonnull
    private ConfigurationSection castVariables;
    @Nonnull
    private ConfigurationSection spellVariables;
    @Nonnull
    private ConfigurationSection mageVariables;
    @Nonnull
    private final Set<String> allParameters = new HashSet<String>();
    @Nonnull
    private final MageSpell spell;

    public SpellParameters(MageSpell spell) {
        super(spell.getMage(), "Spell: " + spell.getKey());
        this.spell = spell;
        this.spellVariables = spell.getVariables();
        this.mageVariables = spell.getMage() != null ? spell.getMage().getVariables() : null;
        Set<String> superParameters = super.getParameters();
        if (superParameters != null) {
            this.allParameters.addAll(superParameters);
        }
    }

    public SpellParameters(MageSpell spell, CastContext context) {
        this(spell);
        this.castVariables = context.getVariables();
    }

    public SpellParameters(MageSpell spell, ConfigurationSection config) {
        this(spell);
        this.wrap(config);
    }

    public SpellParameters(SpellParameters copy) {
        super(copy);
        this.spell = copy.spell;
        this.castVariables = copy.castVariables;
        this.spellVariables = copy.spellVariables;
        this.mageVariables = copy.mageVariables;
        this.allParameters.addAll(copy.allParameters);
    }

    @Override
    protected double getParameter(String parameter) {
        if (this.castVariables != null && this.castVariables.contains(parameter)) {
            return this.castVariables.getDouble(parameter);
        }
        if (this.spellVariables != null && this.spellVariables.contains(parameter)) {
            return this.spellVariables.getDouble(parameter);
        }
        if (this.mageVariables != null && this.mageVariables.contains(parameter)) {
            return this.mageVariables.getDouble(parameter);
        }
        Double value = this.spell.getAttribute(parameter);
        return value == null || Double.isNaN(value) || Double.isInfinite(value) ? 0.0 : value;
    }

    @Override
    protected Set<String> getParameters() {
        if (this.castVariables != null) {
            this.allParameters.addAll(this.castVariables.getKeys(false));
        }
        if (this.spellVariables != null) {
            this.allParameters.addAll(this.spellVariables.getKeys(false));
        }
        if (this.mageVariables != null) {
            this.allParameters.addAll(this.mageVariables.getKeys(false));
        }
        return this.allParameters;
    }

    public void setMageVariables(@Nonnull ConfigurationSection variables) {
        this.mageVariables = variables;
    }

    public void setSpellVariables(@Nonnull ConfigurationSection variables) {
        this.spellVariables = variables;
    }
}

