/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.magic.MagicPropertyType;
import com.elmakers.mine.bukkit.magic.BaseMagicConfigurable;
import com.elmakers.mine.bukkit.magic.CasterProperties;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MageClass;
import com.elmakers.mine.bukkit.utility.ColorHD;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.bukkit.Color;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MageProperties
extends CasterProperties {
    private final Mage mage;
    private ColorHD effectColor = null;

    public MageProperties(Mage mage) {
        super(MagicPropertyType.MAGE, mage.getController());
        this.mage = mage;
    }

    @Override
    public void loadProperties() {
        super.loadProperties();
        if (this.hasProperty("effect_color")) {
            this.setEffectColor(this.getString("effect_color"));
        }
    }

    @Override
    public void updated() {
        this.updateMaxMana(this.mage);
        Wand activeWand = this.mage.getActiveWand();
        if (activeWand != null) {
            activeWand.updated();
        }
        this.mage.updatePassiveEffects();
    }

    public void setEffectColor(String hexColor) {
        if (hexColor == null || hexColor.length() == 0 || hexColor.equals("none")) {
            this.effectColor = null;
            return;
        }
        this.effectColor = new ColorHD(hexColor);
        if (hexColor.equals("random")) {
            this.setProperty("effect_color", this.effectColor.toString());
        }
    }

    @Override
    public void describe(CommandSender sender, @Nullable Set<String> ignoreProperties, @Nullable Set<String> overriddenProperties) {
        MageClass activeClass = this.mage.getActiveClass();
        if (activeClass != null) {
            if (overriddenProperties == null) {
                overriddenProperties = new HashSet<String>();
            }
            overriddenProperties.addAll(activeClass.getEffectiveConfiguration(false).getKeys(false));
        }
        super.describe(sender, ignoreProperties, overriddenProperties);
    }

    @Override
    public boolean isPlayer() {
        return this.mage.isPlayer();
    }

    @Override
    @Nullable
    public Player getPlayer() {
        return this.mage.getPlayer();
    }

    @Override
    public Mage getMage() {
        return this.mage;
    }

    @Nullable
    public Color getEffectColor() {
        return this.effectColor == null ? null : this.effectColor.getColor();
    }

    @Override
    @Nullable
    public BaseMagicConfigurable getStorage(MagicPropertyType propertyType) {
        switch (propertyType) {
            case WAND: {
                return this.mage.getActiveWand();
            }
            case CLASS: 
            case SUBCLASS: {
                return this.mage.getActiveClass().getStorage(propertyType);
            }
            case MAGE: {
                return this;
            }
        }
        return null;
    }
}

