/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.data;

import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.data.BrushData;
import com.elmakers.mine.bukkit.api.data.MageData;
import com.elmakers.mine.bukkit.api.data.MageDataStore;
import com.elmakers.mine.bukkit.api.data.SpellData;
import com.elmakers.mine.bukkit.api.data.UndoData;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.inventory.ItemStack;

public abstract class ConfigurationMageDataStore
implements MageDataStore {
    protected MageController controller;

    @Override
    public void initialize(MageController controller, ConfigurationSection configuration) {
        this.controller = controller;
    }

    public void save(MageData mage, ConfigurationSection saveFile) {
        ConfigurationMageDataStore.save(this.controller, mage, saveFile);
    }

    public static void save(MageController controller, MageData mage, ConfigurationSection saveFile) {
        Map<String, ConfigurationSection> classProperties;
        ConfigurationSection variables;
        ConfigurationSection configurationSection;
        List<ItemStack> list;
        Map<Integer, ItemStack> respawnInventory;
        Map<Integer, ItemStack> respawnArmor;
        Map<String, ItemStack> boundWands;
        Map<String, UndoData> externalUndo;
        saveFile.set("id", (Object)mage.getId());
        saveFile.set("name", (Object)mage.getName());
        saveFile.set("created", (Object)mage.getCreatedTime());
        saveFile.set("last_cast", (Object)mage.getLastCast());
        saveFile.set("cooldown_expiration", (Object)mage.getCooldownExpiration());
        saveFile.set("last_death_location", (Object)ConfigurationUtils.fromLocation(mage.getLastDeathLocation()));
        Location location = mage.getLocation();
        if (location != null) {
            saveFile.set("location", (Object)ConfigurationUtils.fromLocation(location));
        }
        saveFile.set("destination_warp", (Object)mage.getDestinationWarp());
        saveFile.set("fall_protection_count", (Object)mage.getFallProtectionCount());
        saveFile.set("fall_protection", (Object)mage.getFallProtectionDuration());
        BrushData brush = mage.getBrushData();
        if (brush != null) {
            ConfigurationSection brushNode = saveFile.createSection("brush");
            try {
                Location materialTarget;
                Location cloneTarget;
                Location cloneSource = brush.getCloneLocation();
                if (cloneSource != null) {
                    brushNode.set("clone_location", (Object)ConfigurationUtils.fromLocation(cloneSource));
                }
                if ((cloneTarget = brush.getCloneTarget()) != null) {
                    brushNode.set("clone_target", (Object)ConfigurationUtils.fromLocation(cloneTarget));
                }
                if ((materialTarget = brush.getMaterialTarget()) != null) {
                    brushNode.set("material_target", (Object)ConfigurationUtils.fromLocation(materialTarget));
                }
                brushNode.set("map_id", (Object)brush.getMapId());
                brushNode.set("material", (Object)ConfigurationUtils.fromMaterial(brush.getMaterial()));
                brushNode.set("data", (Object)brush.getMaterialData());
                brushNode.set("schematic", (Object)brush.getSchematicName());
                brushNode.set("scale", (Object)brush.getScale());
                brushNode.set("erase", (Object)brush.isFillWithAir());
            }
            catch (Exception ex) {
                controller.getLogger().warning("Failed to save brush data: " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        HashMap<String, List<Map<String, Object>>> allUndoLists = new HashMap<String, List<Map<String, Object>>>();
        UndoData undoData = mage.getUndoData();
        if (undoData != null) {
            List worlds = controller.getPlugin().getServer().getWorlds();
            String serverId = worlds == null || worlds.isEmpty() ? "common" : ((World)worlds.get(0)).getUID().toString();
            allUndoLists.put(serverId, ConfigurationMageDataStore.saveUndoData(undoData));
        }
        if ((externalUndo = mage.getExternalUndoData()) != null && !externalUndo.isEmpty()) {
            for (Map.Entry entry : externalUndo.entrySet()) {
                allUndoLists.put((String)entry.getKey(), ConfigurationMageDataStore.saveUndoData((UndoData)entry.getValue()));
            }
        }
        if (!allUndoLists.isEmpty()) {
            saveFile.set("undo", allUndoLists);
        }
        ConfigurationSection spellNode = saveFile.createSection("spells");
        Collection<SpellData> collection = mage.getSpellData();
        if (collection != null) {
            for (SpellData spell : collection) {
                ConfigurationSection node = spellNode.createSection(spell.getKey().getKey());
                ConfigurationSection configurationSection2 = spell.getVariables();
                if (configurationSection2 != null) {
                    ConfigurationUtils.addConfigurations(node, configurationSection2);
                }
                node.set("cast_count", (Object)spell.getCastCount());
                node.set("last_cast", (Object)spell.getLastCast());
                node.set("last_earn", (Object)spell.getLastEarn());
                node.set("cooldown_expiration", (Object)spell.getCooldownExpiration());
                node.set("active", (Object)(spell.isActive() ? Boolean.valueOf(true) : null));
                node.set("enabled", (Object)(spell.isEnabled() ? null : Boolean.valueOf(false)));
            }
        }
        if ((boundWands = mage.getBoundWands()) != null && boundWands.size() > 0) {
            ConfigurationSection wandSection = saveFile.createSection("wands");
            for (Map.Entry entry : boundWands.entrySet()) {
                String string = (String)entry.getKey();
                if (string == null || string.isEmpty()) continue;
                controller.serialize(wandSection, string, (ItemStack)entry.getValue());
            }
        }
        if ((respawnArmor = mage.getRespawnArmor()) != null) {
            ConfigurationSection armorSection = saveFile.createSection("respawn_armor");
            for (Map.Entry<Integer, ItemStack> entry : respawnArmor.entrySet()) {
                controller.serialize(armorSection, Integer.toString(entry.getKey()), entry.getValue());
            }
        }
        if ((respawnInventory = mage.getRespawnInventory()) != null) {
            ConfigurationSection configurationSection3 = saveFile.createSection("respawn_inventory");
            for (Map.Entry<Integer, ItemStack> entry : respawnInventory.entrySet()) {
                controller.serialize(configurationSection3, Integer.toString(entry.getKey()), entry.getValue());
            }
        }
        if ((list = mage.getStoredInventory()) != null) {
            saveFile.set("inventory", list);
        }
        saveFile.set("experience", (Object)mage.getStoredExperience());
        saveFile.set("level", (Object)mage.getStoredLevel());
        saveFile.set("open_wand", (Object)mage.isOpenWand());
        saveFile.set("gave_welcome_wand", (Object)mage.getGaveWelcomeWand());
        ConfigurationSection configurationSection4 = mage.getExtraData();
        if (configurationSection4 != null) {
            ConfigurationSection configurationSection5 = saveFile.createSection("data");
            ConfigurationUtils.addConfigurations(configurationSection5, configurationSection4);
        }
        if ((configurationSection = mage.getProperties()) != null) {
            ConfigurationSection propertiesSection = saveFile.createSection("properties");
            ConfigurationUtils.addConfigurations(propertiesSection, configurationSection);
        }
        if ((variables = mage.getVariables()) != null && !variables.getKeys(false).isEmpty()) {
            saveFile.set("variables", (Object)variables);
        }
        if ((classProperties = mage.getClassProperties()) != null) {
            ConfigurationSection classesSection = saveFile.createSection("classes");
            for (Map.Entry<String, ConfigurationSection> entry : classProperties.entrySet()) {
                ConfigurationSection classSection = classesSection.createSection(entry.getKey());
                ConfigurationUtils.addConfigurations(classSection, entry.getValue());
            }
        }
        saveFile.set("active_class", (Object)mage.getActiveClass());
        saveFile.set("health", (Object)mage.getHealth());
    }

    @Override
    public void save(Collection<MageData> mages) {
        for (MageData data : mages) {
            this.save(data, null, false);
        }
    }

    private static List<Map<String, Object>> saveUndoData(UndoData undoData) {
        ArrayList<Map<String, Object>> nodeList = new ArrayList<Map<String, Object>>();
        List<UndoList> undoList = undoData.getBlockList();
        for (UndoList list : undoList) {
            MemoryConfiguration listNode = new MemoryConfiguration();
            list.save((ConfigurationSection)listNode);
            nodeList.add(listNode.getValues(true));
        }
        return nodeList;
    }

    public MageData load(String id, ConfigurationSection saveFile) {
        return ConfigurationMageDataStore.load(this.controller, id, saveFile);
    }

    public static MageData load(MageController controller, String id, ConfigurationSection saveFile) {
        ConfigurationSection respawnArmorData;
        ConfigurationSection respawnData;
        MageData data = new MageData(id);
        ConfigurationSection brushConfig = saveFile.getConfigurationSection("brush");
        if (brushConfig != null) {
            BrushData brushData = new BrushData();
            try {
                brushData.setCloneLocation(ConfigurationUtils.getLocation(brushConfig, "clone_location"));
                brushData.setCloneTarget(ConfigurationUtils.getLocation(brushConfig, "clone_target"));
                brushData.setMaterialTarget(ConfigurationUtils.getLocation(brushConfig, "material_target"));
                brushData.setSchematicName(brushConfig.getString("schematic", ""));
                brushData.setMapId((short)brushConfig.getInt("map_id", -1));
                brushData.setMaterial(ConfigurationUtils.getMaterial(brushConfig, "material", Material.AIR));
                brushData.setMaterialData((short)brushConfig.getInt("data", 0));
                brushData.setScale(brushConfig.getDouble("scale", 1.0));
                brushData.setFillWithAir(brushConfig.getBoolean("erase", true));
                data.setBrushData(brushData);
            }
            catch (Exception ex) {
                controller.getLogger().warning("Failed to load brush data: " + ex.getMessage());
                ex.printStackTrace();
            }
        }
        if (saveFile.contains("wands")) {
            HashMap<String, ItemStack> boundWands = new HashMap<String, ItemStack>();
            ConfigurationSection wands = saveFile.getConfigurationSection("wands");
            Set keys = wands.getKeys(false);
            for (String key : keys) {
                ItemStack boundWand = controller.deserialize(wands, key);
                if (boundWand == null) {
                    controller.getLogger().warning("Error loading bound wand: " + key);
                    continue;
                }
                boundWands.put(key, boundWand);
            }
            data.setBoundWands(boundWands);
        }
        data.setProperties(saveFile.getConfigurationSection("properties"));
        data.setVariables(saveFile.getConfigurationSection("variables"));
        HashMap<String, ConfigurationSection> classProperties = new HashMap<String, ConfigurationSection>();
        ConfigurationSection classes = saveFile.getConfigurationSection("classes");
        if (classes != null) {
            Set classKeys = classes.getKeys(false);
            for (String classKey : classKeys) {
                classProperties.put(classKey, classes.getConfigurationSection(classKey));
            }
        }
        data.setClassProperties(classProperties);
        data.setActiveClass(saveFile.getString("active_class"));
        data.setExtraData(saveFile.getConfigurationSection("data"));
        data.setFallProtectionCount(saveFile.getLong("fall_protection_count", 0L));
        data.setFallProtectionDuration(saveFile.getLong("fall_protection", 0L));
        data.setName(saveFile.getString("name", ""));
        data.setLastDeathLocation(ConfigurationUtils.getLocation(saveFile, "last_death_location"));
        data.setLocation(ConfigurationUtils.getLocation(saveFile, "location"));
        data.setLastCast(saveFile.getLong("last_cast", 0L));
        data.setCreatedTime(saveFile.getLong("created", 0L));
        data.setCooldownExpiration(saveFile.getLong("cooldown_expiration", 0L));
        data.setDestinationWarp(saveFile.getString("destination_warp"));
        HashMap<Object, UndoData> externalUndoData = null;
        UndoData undoData = new UndoData();
        ConfigurationSection undoMap = ConfigurationUtils.getConfigurationSection(saveFile, "undo");
        if (undoMap == null) {
            Collection<ConfigurationSection> nodeList = ConfigurationUtils.getNodeList(saveFile, "undo");
            ConfigurationMageDataStore.loadUndoData(controller, undoData, nodeList);
        } else {
            List worlds = controller.getPlugin().getServer().getWorlds();
            String serverId = worlds == null || worlds.isEmpty() ? "common" : ((World)worlds.get(0)).getUID().toString();
            for (Object key : undoMap.getKeys(false)) {
                Collection<ConfigurationSection> nodeList = ConfigurationUtils.getNodeList(undoMap, (String)key);
                if (((String)key).equals(serverId)) {
                    ConfigurationMageDataStore.loadUndoData(controller, undoData, nodeList);
                    continue;
                }
                if (externalUndoData == null) {
                    externalUndoData = new HashMap<Object, UndoData>();
                }
                UndoData external = new UndoData();
                ConfigurationMageDataStore.loadUndoData(controller, external, nodeList);
                externalUndoData.put(key, external);
            }
        }
        data.setExternalUndoData(externalUndoData);
        data.setUndoData(undoData);
        ConfigurationSection spellSection = saveFile.getConfigurationSection("spells");
        if (spellSection != null) {
            Set keys = spellSection.getKeys(false);
            HashMap<Object, SpellData> spellDataMap = new HashMap<Object, SpellData>();
            for (Object key : keys) {
                ConfigurationSection node = spellSection.getConfigurationSection((String)key);
                SpellData spellData = (SpellData)spellDataMap.get(key);
                if (spellData == null) {
                    spellData = new SpellData((String)key);
                    spellDataMap.put(key, spellData);
                }
                spellData.setIsEnabled(node.getBoolean("enabled", true));
                spellData.setCastCount(spellData.getCastCount() + node.getLong("cast_count", 0L));
                spellData.setLastCast(Math.max(spellData.getLastCast(), node.getLong("last_cast", 0L)));
                spellData.setLastEarn(Math.max(spellData.getLastEarn(), node.getLong("last_earn", 0L)));
                spellData.setCooldownExpiration(Math.max(spellData.getCooldownExpiration(), node.getLong("cooldown_expiration", 0L)));
                node.set("cast_count", null);
                node.set("last_cast", null);
                node.set("last_earn", null);
                node.set("cooldown_expiration", null);
                node.set("active", null);
                node.set("enabled", null);
                spellData.setVariables(node);
            }
            data.setSpellData(spellDataMap.values());
        }
        if ((respawnData = saveFile.getConfigurationSection("respawn_inventory")) != null) {
            Set keys = respawnData.getKeys(false);
            HashMap<Integer, ItemStack> respawnInventory = new HashMap<Integer, ItemStack>();
            for (String key : keys) {
                try {
                    int index = Integer.parseInt(key);
                    ItemStack item = controller.deserialize(respawnData, key);
                    respawnInventory.put(index, item);
                }
                catch (Exception ex) {
                    controller.getLogger().log(Level.WARNING, "Error loading respawn inventory for " + id, ex);
                }
            }
            data.setRespawnInventory(respawnInventory);
        }
        if ((respawnArmorData = saveFile.getConfigurationSection("respawn_armor")) != null) {
            Set keys = respawnArmorData.getKeys(false);
            HashMap<Integer, ItemStack> respawnArmor = new HashMap<Integer, ItemStack>();
            for (String key : keys) {
                try {
                    int index = Integer.parseInt(key);
                    ItemStack item = controller.deserialize(respawnArmorData, key);
                    respawnArmor.put(index, item);
                }
                catch (Exception ex) {
                    controller.getLogger().log(Level.WARNING, "Error loading respawn armor inventory for " + id, ex);
                }
            }
            data.setRespawnArmor(respawnArmor);
        }
        if (saveFile.contains("brush")) {
            try {
                ConfigurationSection node = saveFile.getConfigurationSection("brush");
                BrushData brushData = new BrushData();
                brushData.setCloneLocation(ConfigurationUtils.getLocation(node, "clone_location"));
                brushData.setCloneTarget(ConfigurationUtils.getLocation(node, "clone_target"));
                brushData.setMaterialTarget(ConfigurationUtils.getLocation(node, "material_target"));
                brushData.setSchematicName(node.getString("schematic"));
                brushData.setMapId((short)node.getInt("map_id"));
                brushData.setMaterial(ConfigurationUtils.getMaterial(node, "material"));
                brushData.setMaterialData((short)node.getInt("data"));
                brushData.setScale(node.getDouble("scale"));
                brushData.setFillWithAir(node.getBoolean("erase"));
                data.setBrushData(brushData);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                controller.getLogger().warning("Failed to load brush data: " + ex.getMessage());
            }
        }
        if (saveFile.contains("inventory")) {
            List inventory = saveFile.getList("inventory");
            data.setStoredInventory(inventory);
        }
        if (saveFile.contains("experience")) {
            data.setStoredExperience(Float.valueOf((float)saveFile.getDouble("experience")));
        }
        if (saveFile.contains("level")) {
            data.setStoredLevel(saveFile.getInt("level"));
        }
        data.setOpenWand(saveFile.getBoolean("open_wand", false));
        data.setGaveWelcomeWand(saveFile.getBoolean("gave_welcome_wand", false));
        data.setHealth(saveFile.getDouble("health"));
        return data;
    }

    private static void loadUndoData(MageController controller, UndoData undoData, Collection<ConfigurationSection> nodeList) {
        if (nodeList == null) {
            return;
        }
        for (ConfigurationSection listNode : nodeList) {
            com.elmakers.mine.bukkit.block.UndoList list = new com.elmakers.mine.bukkit.block.UndoList(controller);
            list.load(listNode);
            undoData.getBlockList().add(list);
        }
    }
}

