/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.automata;

import com.elmakers.mine.bukkit.api.effect.EffectPlayer;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.automata.Automaton;
import com.elmakers.mine.bukkit.automata.Caster;
import com.elmakers.mine.bukkit.automata.Spawner;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class AutomatonTemplate {
    @Nonnull
    private final MageController controller;
    @Nonnull
    private final ConfigurationSection configuration;
    @Nonnull
    private final String key;
    @Nullable
    private String name;
    private int interval;
    @Nullable
    private Spawner spawner;
    @Nullable
    private Caster caster;
    @Nullable
    private Collection<EffectPlayer> effects;
    private final int playerRange;
    private final int minPlayers;
    private final Integer minTimeOfDay;
    private final Integer maxTimeOfDay;
    private final Integer minPhaseOfMoon;
    private final Integer maxPhaseOfMoon;

    public AutomatonTemplate(@Nonnull MageController controller, @Nonnull String key, @Nonnull ConfigurationSection configuration) {
        this.key = (String)Preconditions.checkNotNull((Object)key);
        this.controller = controller;
        this.configuration = configuration;
        this.name = configuration.getString("name");
        this.interval = configuration.getInt("interval", 0);
        if (configuration.isList("effects")) {
            this.effects = controller.loadEffects(configuration, "effects");
        } else {
            String effectKey = configuration.getString("effects");
            if (effectKey != null) {
                this.effects = controller.getEffects(effectKey);
                if (this.effects.isEmpty()) {
                    this.effects = null;
                }
            }
        }
        if (configuration.contains("spawn")) {
            this.spawner = new Spawner(controller, this, configuration.getConfigurationSection("spawn"));
        }
        if (configuration.contains("cast")) {
            this.caster = new Caster(this, configuration.getConfigurationSection("cast"));
        }
        this.playerRange = configuration.getInt("player_range", 64);
        this.minPlayers = configuration.getInt("min_players", 0);
        this.minTimeOfDay = this.parseTime(configuration, "min_time", controller.getLogger());
        this.maxTimeOfDay = this.parseTime(configuration, "max_time", controller.getLogger());
        if (configuration.contains("moon_phase")) {
            this.minPhaseOfMoon = this.maxPhaseOfMoon = this.parseMoonPhase(configuration, "moon_phase", controller.getLogger());
        } else {
            this.minPhaseOfMoon = this.parseMoonPhase(configuration, "min_moon_phase", controller.getLogger());
            this.maxPhaseOfMoon = this.parseMoonPhase(configuration, "max_moon_phase", controller.getLogger());
        }
    }

    @Nullable
    private Integer parseTime(ConfigurationSection configuration, String key, Logger log) {
        Integer time = null;
        if (configuration.contains(key)) {
            if (configuration.isInt(key)) {
                time = configuration.getInt(key);
            } else {
                String timeString = configuration.getString(key);
                if (timeString.equalsIgnoreCase("day")) {
                    time = 0;
                } else if (timeString.equalsIgnoreCase("night")) {
                    time = 13000;
                } else if (timeString.equalsIgnoreCase("dusk") || timeString.equalsIgnoreCase("sunset")) {
                    time = 12000;
                } else if (timeString.equalsIgnoreCase("dawn") || timeString.equalsIgnoreCase("sunrise")) {
                    time = 23000;
                } else if (timeString.equalsIgnoreCase("noon") || timeString.equalsIgnoreCase("midday")) {
                    time = 6000;
                } else if (timeString.equalsIgnoreCase("midnight")) {
                    time = 18000;
                } else {
                    log.warning("Invalid time in automata config: " + timeString);
                }
            }
        }
        return time;
    }

    @Nullable
    private Integer parseMoonPhase(ConfigurationSection configuration, String key, Logger log) {
        Integer phase = null;
        if (configuration.contains(key)) {
            if (configuration.isInt(key)) {
                phase = configuration.getInt(key);
            } else {
                String phaseString = configuration.getString(key);
                if (phaseString.equalsIgnoreCase("new")) {
                    phase = 4;
                } else if (phaseString.equalsIgnoreCase("full")) {
                    phase = 0;
                } else {
                    log.warning("Invalid phase of moon in automata config: " + phaseString);
                }
            }
        }
        return phase;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public String getName() {
        String name = this.name;
        return name == null ? this.key : name;
    }

    public int getInterval() {
        return this.interval;
    }

    public void tick(Automaton instance) {
        boolean isActive = this.checkActive(instance.getLocation());
        boolean firstActivate = false;
        if (isActive) {
            if (!instance.isActive()) {
                firstActivate = true;
                instance.activate();
            }
        } else {
            if (instance.isActive()) {
                instance.deactivate();
            }
            return;
        }
        if (this.spawner != null) {
            List<Entity> entities = this.spawner.spawn(instance.getLocation());
            if (entities != null && !entities.isEmpty()) {
                instance.track(entities);
            }
            instance.checkEntities();
        }
        if (this.caster != null && (this.caster.isRecast() || firstActivate)) {
            this.caster.cast(instance.getMage());
        }
    }

    public AutomatonTemplate getVariant(ConfigurationSection parameters) {
        ConfigurationSection mergedConfiguration = ConfigurationUtils.cloneConfiguration(this.configuration);
        mergedConfiguration = ConfigurationUtils.addConfigurations(mergedConfiguration, parameters);
        return new AutomatonTemplate(this.controller, this.key, mergedConfiguration);
    }

    @Nullable
    public Collection<EffectPlayer> getEffects() {
        return this.effects;
    }

    private boolean checkRange(Integer min, Integer max, int value) {
        if (min != null && (max != null && max < min ? value < min && value > max : value < min)) {
            return false;
        }
        return max == null || value <= max || min != null && min > max;
    }

    public boolean checkActive(Location location) {
        if (!this.checkRange(this.minTimeOfDay, this.maxTimeOfDay, (int)location.getWorld().getTime())) {
            return false;
        }
        if (!this.checkRange(this.minPhaseOfMoon, this.maxPhaseOfMoon, (int)(location.getWorld().getFullTime() / 24000L % 8L))) {
            return false;
        }
        if (this.minPlayers >= 0 && this.playerRange > 0) {
            int playerCount = 0;
            int rangeSquared = this.playerRange * this.playerRange;
            List players = location.getWorld().getPlayers();
            for (Player player : players) {
                if (!(player.getLocation().distanceSquared(location) <= (double)rangeSquared)) continue;
                ++playerCount;
            }
            if (playerCount < this.minPlayers) {
                return false;
            }
        }
        return true;
    }

    public boolean isUndoAll() {
        return this.caster != null && this.caster.isUndoAll();
    }
}

