/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.block.UndoList;
import com.elmakers.mine.bukkit.api.item.ItemUpdatedCallback;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.BlockSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.DeprecatedUtils;
import com.elmakers.mine.bukkit.utility.Target;
import javax.annotation.Nullable;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Zombie;
import org.bukkit.inventory.ItemStack;

@Deprecated
public class ShrinkSpell
extends BlockSpell {
    private static final int DEFAULT_PLAYER_DAMAGE = 1;
    private static final int DEFAULT_ENTITY_DAMAGE = 100;

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        String giveName = parameters.getString("name");
        if (giveName != null) {
            String itemName = giveName + "'s Head";
            this.dropHead(this.controller, this.getLocation(), giveName, itemName);
            return SpellResult.CAST;
        }
        Target target = this.getTarget();
        if (target.hasEntity()) {
            Entity targetEntity = target.getEntity();
            if (this.controller.isElemental(targetEntity)) {
                double elementalSize = this.controller.getElementalScale(targetEntity);
                if (elementalSize < 0.1) {
                    int elementalDamage = parameters.getInt("elemental_damage", 100);
                    this.controller.damageElemental(targetEntity, elementalDamage, 0, this.mage.getCommandSender());
                } else {
                    this.controller.setElementalScale(targetEntity, elementalSize /= 2.0);
                }
                return SpellResult.CAST;
            }
            if (!(targetEntity instanceof LivingEntity)) {
                return SpellResult.NO_TARGET;
            }
            this.registerForUndo();
            int damage = parameters.getInt("entity_damage", 100);
            LivingEntity li = (LivingEntity)targetEntity;
            boolean alreadyDead = li.isDead() || li.getHealth() <= 0.0;
            String itemName = DeprecatedUtils.getDisplayName((Entity)li) + " Head";
            if (li instanceof Player) {
                damage = parameters.getInt("player_damage", 1);
            }
            Location targetLocation = targetEntity.getLocation();
            if (li instanceof Player) {
                CompatibilityUtils.magicDamage((Damageable)li, damage, this.mage.getEntity());
                if (li.isDead() && !alreadyDead) {
                    this.dropHead(this.controller, targetEntity, itemName);
                }
            } else if (li.getType() == EntityType.GIANT) {
                UndoList spawnedList = com.elmakers.mine.bukkit.block.UndoList.getUndoList((Entity)li);
                this.registerModified((Entity)li);
                li.remove();
                Entity zombie = targetLocation.getWorld().spawnEntity(targetLocation, EntityType.ZOMBIE);
                if (zombie instanceof Zombie) {
                    ((Zombie)zombie).setBaby(false);
                }
                this.registerForUndo(zombie);
                if (spawnedList != null) {
                    spawnedList.add(zombie);
                }
            } else if (li instanceof Ageable && ((Ageable)li).isAdult() && !(li instanceof Player)) {
                this.registerModified((Entity)li);
                ((Ageable)li).setBaby();
            } else if (li instanceof Zombie && !((Zombie)li).isBaby()) {
                this.registerModified((Entity)li);
                ((Zombie)li).setBaby(true);
            } else if (li instanceof PigZombie && !((PigZombie)li).isBaby()) {
                this.registerModified((Entity)li);
                ((PigZombie)li).setBaby(true);
            } else if (li instanceof Slime && ((Slime)li).getSize() > 1) {
                this.registerModified((Entity)li);
                Slime slime = (Slime)li;
                slime.setSize(slime.getSize() - 1);
            } else {
                CompatibilityUtils.magicDamage((Damageable)li, damage, this.mage.getEntity());
                if ((li.isDead() || li.getHealth() == 0.0) && !alreadyDead) {
                    this.dropHead(this.controller, targetEntity, itemName);
                }
            }
        } else {
            Block targetBlock = target.getBlock();
            if (targetBlock == null) {
                return SpellResult.NO_TARGET;
            }
            String blockSkin = this.getBlockSkin(targetBlock.getType());
            if (blockSkin == null) {
                return SpellResult.NO_TARGET;
            }
            if (!this.hasBreakPermission(targetBlock)) {
                return SpellResult.INSUFFICIENT_PERMISSION;
            }
            if (this.mage.isIndestructible(targetBlock)) {
                return SpellResult.NO_TARGET;
            }
            this.registerForUndo(targetBlock);
            this.registerForUndo();
            this.dropHead(this.controller, targetBlock.getLocation(), blockSkin, targetBlock.getType().name());
            targetBlock.setType(Material.AIR);
        }
        return SpellResult.CAST;
    }

    protected void dropHead(MageController controller, final Entity entity, String itemName) {
        controller.getSkull(entity, itemName, new ItemUpdatedCallback(){

            @Override
            public void updated(@Nullable ItemStack itemStack) {
                if (!CompatibilityUtils.isEmpty(itemStack)) {
                    Location location = entity instanceof LivingEntity ? ((LivingEntity)entity).getEyeLocation() : entity.getLocation();
                    location.getWorld().dropItemNaturally(location, itemStack);
                }
            }
        });
    }

    protected void dropHead(MageController controller, final Location location, String ownerName, String itemName) {
        controller.getSkull(ownerName, itemName, new ItemUpdatedCallback(){

            @Override
            public void updated(@Nullable ItemStack itemStack) {
                if (!CompatibilityUtils.isEmpty(itemStack)) {
                    location.setX(location.getX() + 0.5);
                    location.setY(location.getY() + 0.5);
                    location.setZ(location.getZ() + 0.5);
                    location.getWorld().dropItemNaturally(location, itemStack);
                }
            }
        });
    }
}

