/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.effect.EffectPlayer;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.magic.Trigger;
import com.elmakers.mine.bukkit.api.spell.MageSpell;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.RandomUtils;
import com.elmakers.mine.bukkit.utility.WeightedPair;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Entity;

public class MobTrigger
extends Trigger {
    protected Deque<WeightedPair<String>> spells;
    protected Deque<WeightedPair<ConfigurationSection>> spellsWithParameters;
    protected Collection<EffectPlayer> effects;
    protected List<String> commands;

    public MobTrigger(@Nonnull MageController controller, @Nonnull String key, @Nonnull ConfigurationSection configuration) {
        super(controller, configuration, key);
        List checkList;
        if (configuration.isConfigurationSection("cast")) {
            this.spells = new ArrayDeque<WeightedPair<String>>();
            RandomUtils.populateStringProbabilityMap(this.spells, configuration, "cast");
        }
        if (configuration.isList("cast") && !(checkList = configuration.getList("cast")).isEmpty()) {
            Object first = checkList.get(0);
            if (first instanceof String) {
                List stringList = checkList;
                RandomUtils.populateStringProbabilityList(this.spells, stringList);
            } else if (first instanceof ConfigurationSection || first instanceof Map) {
                float currentThreshold = 0.0f;
                this.spellsWithParameters = new ArrayDeque<WeightedPair<ConfigurationSection>>();
                for (Object configGeneric : checkList) {
                    String spellKey;
                    ConfigurationSection config = null;
                    if (configGeneric instanceof ConfigurationSection) {
                        config = (ConfigurationSection)configGeneric;
                    }
                    if (configGeneric instanceof Map) {
                        Map configMap = (Map)configGeneric;
                        config = ConfigurationUtils.toConfigurationSection(configMap);
                    }
                    if ((spellKey = config.getString("spell")) == null || spellKey.isEmpty()) {
                        controller.getLogger().warning("Trigger spell config missing 'spell' key");
                        continue;
                    }
                    this.spellsWithParameters.add(new WeightedPair<ConfigurationSection>(Float.valueOf(currentThreshold += (float)config.getDouble("probability", 1.0)), config));
                }
            }
        }
        this.commands = ConfigurationUtils.getStringList(configuration, "commands");
        if (configuration.contains("effects")) {
            this.effects = controller.loadEffects(configuration, "effects");
        }
    }

    private void cast(Mage mage, String castSpell) {
        this.cast(mage, castSpell, null);
    }

    private void cast(Mage mage, String castSpell, ConfigurationSection parameters) {
        if (castSpell.isEmpty() || castSpell.equalsIgnoreCase("none")) {
            return;
        }
        if (parameters != null) {
            parameters = ConfigurationUtils.cloneConfiguration(parameters);
        }
        MageSpell spell = null;
        if (castSpell.contains(" ")) {
            String[] additionalParameters = StringUtils.split((String)castSpell, (char)' ');
            castSpell = additionalParameters[0];
            additionalParameters = Arrays.copyOfRange(additionalParameters, 1, additionalParameters.length);
            if (parameters == null) {
                parameters = new MemoryConfiguration();
            }
            ConfigurationUtils.addParameters(additionalParameters, parameters);
        }
        if ((spell = mage.getSpell(castSpell)) == null) {
            mage.getController().getLogger().warning("Unknown spell in mob trigger: " + castSpell + " from mob " + mage.getName());
            return;
        }
        double bowpull = mage.getLastBowPull();
        if (bowpull > 0.0) {
            if (parameters == null) {
                parameters = new MemoryConfiguration();
            }
            parameters.set("bowpull", (Object)Double.toString(bowpull));
        }
        spell.cast(parameters);
    }

    public boolean execute(Mage mage) {
        String spell;
        if (!this.isValid(mage)) {
            return false;
        }
        this.triggered();
        if (this.effects != null) {
            for (EffectPlayer player : this.effects) {
                player.start(mage.getEffectContext());
            }
        }
        if (this.spells != null && !this.spells.isEmpty()) {
            spell = (String)RandomUtils.weightedRandom(this.spells);
            this.cast(mage, spell);
        }
        if (this.spellsWithParameters != null && !this.spellsWithParameters.isEmpty()) {
            spell = (ConfigurationSection)RandomUtils.weightedRandom(this.spellsWithParameters);
            this.cast(mage, spell.getString("spell"), (ConfigurationSection)spell);
        }
        if (this.commands != null) {
            Entity topDamager = mage.getTopDamager();
            Entity killer = mage.getLastDamager();
            Collection<Entity> damagers = mage.getDamagers();
            Location location = mage.getLocation();
            for (String command : this.commands) {
                boolean allDamagers;
                if (command.contains("@killer")) {
                    if (killer == null) continue;
                    command = command.replace("@killer", killer.getName());
                }
                if ((allDamagers = command.contains("@damagers")) && damagers == null) continue;
                if (!allDamagers && command.contains("@damager")) {
                    if (topDamager == null) continue;
                    command = command.replace("@damager", topDamager.getName());
                }
                command = command.replace("@name", mage.getName()).replace("@world", location.getWorld().getName()).replace("@x", Double.toString(location.getX())).replace("@y", Double.toString(location.getY())).replace("@z", Double.toString(location.getZ()));
                if (allDamagers) {
                    for (Entity damager : damagers) {
                        String damagerCommand = command.replace("@damagers", damager.getName());
                        mage.getController().getPlugin().getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), damagerCommand);
                    }
                    continue;
                }
                mage.getController().getPlugin().getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), command);
            }
        }
        return true;
    }
}

