/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.effect.builtin;

import com.elmakers.mine.bukkit.effect.EffectPlayer;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.bukkit.Color;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public class EffectVariable
extends EffectPlayer {
    private Map<Double, Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer>> brightnessMap = new TreeMap<Double, Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer>>();
    private Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> playing = new ArrayList<com.elmakers.mine.bukkit.api.effect.EffectPlayer>();

    @Override
    public void cancel() {
        super.cancel();
        for (com.elmakers.mine.bukkit.api.effect.EffectPlayer player : this.playing) {
            player.cancel();
        }
    }

    @Override
    public void load(Plugin plugin, ConfigurationSection configuration) {
        super.load(plugin, configuration);
        this.playAtOrigin = false;
        this.playAtTarget = false;
        this.playAtAllTargets = false;
        ConfigurationSection brightness = ConfigurationUtils.getConfigurationSection(configuration, "brightness");
        Set keys = brightness.getKeys(false);
        for (String key : keys) {
            try {
                double level = Double.parseDouble(key);
                Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> childPlayers = EffectPlayer.loadEffects(plugin, brightness, key);
                this.brightnessMap.put(level, childPlayers);
                for (com.elmakers.mine.bukkit.api.effect.EffectPlayer childPlayer : childPlayers) {
                    this.playAtOrigin |= childPlayer.playsAtOrigin();
                    this.playAtAllTargets |= childPlayer.playsAtAllTargets();
                    this.playAtTarget |= childPlayer.playsAtTarget();
                }
            }
            catch (Exception exception) {
            }
        }
    }

    @Override
    public void play() {
        this.playing.clear();
        if (this.brightnessMap.size() > 0) {
            double brightness = 0.0;
            Color color = this.getColor1();
            if (color != null) {
                brightness = (double)color.getRed() / 255.0 + (double)color.getBlue() / 255.0 + (double)color.getGreen() / 255.0;
            }
            for (Map.Entry<Double, Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer>> entry : this.brightnessMap.entrySet()) {
                if (!(brightness < entry.getKey())) continue;
                for (com.elmakers.mine.bukkit.api.effect.EffectPlayer player : entry.getValue()) {
                    player.setScale(this.scale);
                    player.setMaterial(this.getWorkingMaterial());
                    player.setColor(this.getColor1());
                    player.setParticleOverride(this.particleOverride == null ? null : this.particleOverride.name());
                    player.start(this.getOrigin(), this.getOriginEntity(), this.getTarget(), this.getTargetEntity());
                    this.playing.add(player);
                }
            }
        }
    }
}

