/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseTeleportAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.action.GUIAction;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.api.wand.LostWand;
import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.DeprecatedUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.utility.SkinUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class RecallAction
extends BaseTeleportAction
implements GUIAction {
    private static final Material DefaultWaypointMaterial = Material.BEACON;
    private boolean allowCrossWorld = true;
    private List<RecallType> enabledTypes = new ArrayList<RecallType>();
    private List<Waypoint> options = new ArrayList<Waypoint>();
    private CastContext context;
    private ConfigurationSection parameters;
    private int protectionTime;
    private String markerKey = "recall_marker";
    private String unlockKey = "recall_warps";
    private String friendKey = "recall_friends";
    private int markerCount = 1;
    private static MaterialAndData defaultMaterial = new MaterialAndData(DefaultWaypointMaterial);

    private String getMarkerKey(int markerNumber) {
        String key = this.markerKey;
        if (markerNumber > 1) {
            key = key + markerNumber;
        }
        return key;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    public void deactivated() {
        if (this.context != null) {
            this.context.getMage().removeItemsWithTag("waypoint");
        }
    }

    @Override
    public void dragged(InventoryDragEvent event) {
        event.setCancelled(true);
    }

    @Override
    public void clicked(InventoryClickEvent event) {
        event.setCancelled(true);
        if (this.context == null) {
            event.getWhoClicked().closeInventory();
            return;
        }
        ItemStack item = event.getCurrentItem();
        if (InventoryUtils.hasMeta(item, "placeholder") || InventoryUtils.hasMeta(item, "unavailable")) {
            this.context.getMage().deactivateGUI();
            return;
        }
        if (InventoryUtils.hasMeta(item, "move_marker")) {
            int markerNumber = InventoryUtils.getMetaInt(item, "move_marker", 1);
            if (this.placeMarker(this.context.getLocation().getBlock(), markerNumber)) {
                this.context.sendMessageKey("target_selected");
            }
            this.context.getMage().deactivateGUI();
            return;
        }
        if (item == null || item.getType() == Material.AIR) {
            this.context.getMage().deactivateGUI();
        }
        int slot = event.getRawSlot();
        if (event.getSlotType() == InventoryType.SlotType.CONTAINER) {
            Waypoint waypoint;
            Waypoint waypoint2 = waypoint = slot < 0 || slot >= this.options.size() ? null : this.options.get(slot);
            if (waypoint != null) {
                Mage mage = this.context.getMage();
                Player player = mage.getPlayer();
                mage.deactivateGUI();
                this.tryTeleport(player, waypoint);
            }
        }
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.parameters = parameters;
        this.context = context;
        this.markerKey = parameters.getString("marker_key", "recall_marker");
        this.unlockKey = parameters.getString("unlock_key", "recall_warps");
        this.friendKey = parameters.getString("friend_key", "recall_friends");
        this.protectionTime = parameters.getInt("protection_duration", 0);
        this.markerCount = parameters.getInt("marker_count", 1);
        this.allowCrossWorld = parameters.getBoolean("allow_cross_world", true);
    }

    @Override
    public SpellResult perform(CastContext context) {
        this.context = context;
        this.enabledTypes.clear();
        this.options.clear();
        Mage mage = context.getMage();
        MageController controller = context.getController();
        Player player = mage.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        HashSet<String> unlockedWarps = new HashSet<String>();
        ConfigurationSection mageData = mage.getData();
        String unlockedString = mageData.getString(this.unlockKey);
        if (unlockedString != null && !unlockedString.isEmpty()) {
            unlockedWarps.addAll(Arrays.asList(StringUtils.split((String)unlockedString, (char)',')));
        }
        HashSet<String> friends = new HashSet<String>();
        String friendString = mageData.getString(this.friendKey);
        if (friendString != null && !friendString.isEmpty()) {
            friends.addAll(Arrays.asList(StringUtils.split((String)friendString, (char)',')));
        }
        ConfigurationSection warpConfig = null;
        if (this.parameters.contains("warps")) {
            warpConfig = ConfigurationUtils.getConfigurationSection(this.parameters, "warps");
        }
        ConfigurationSection commandConfig = null;
        if (this.parameters.contains("commands")) {
            commandConfig = ConfigurationUtils.getConfigurationSection(this.parameters, "commands");
        }
        if (this.parameters.contains("unlock")) {
            ConfigurationSection config;
            String unlockWarp = this.parameters.getString("unlock");
            if (unlockWarp == null || unlockWarp.isEmpty() || unlockedWarps.contains(unlockWarp)) {
                return SpellResult.NO_ACTION;
            }
            if (warpConfig == null && commandConfig == null) {
                return SpellResult.FAIL;
            }
            unlockedWarps.add(unlockWarp);
            unlockedString = StringUtils.join(unlockedWarps, (String)",");
            mageData.set(this.unlockKey, (Object)unlockedString);
            String warpName = unlockWarp;
            ConfigurationSection configurationSection = config = warpConfig == null ? null : warpConfig.getConfigurationSection(unlockWarp);
            if (config != null) {
                warpName = config.getString("name", warpName);
            } else {
                ConfigurationSection configurationSection2 = config = commandConfig == null ? null : commandConfig.getConfigurationSection(unlockWarp);
                if (config != null) {
                    warpName = config.getString("name", warpName);
                }
            }
            warpName = ChatColor.translateAlternateColorCodes((char)'&', (String)warpName);
            String unlockMessage = context.getMessage("unlock_warp").replace("$name", warpName);
            context.sendMessage(unlockMessage);
            return SpellResult.CAST;
        }
        if (this.parameters.contains("lock")) {
            String lockWarpString = this.parameters.getString("lock");
            String[] lockWarps = StringUtils.split((String)lockWarpString, (char)',');
            boolean locked = false;
            for (String lockWarp : lockWarps) {
                if (!unlockedWarps.contains(lockWarp)) continue;
                locked = true;
                unlockedWarps.remove(lockWarp);
            }
            if (locked) {
                unlockedString = StringUtils.join(unlockedWarps, (String)",");
                mageData.set(this.unlockKey, (Object)unlockedString);
            }
            return locked ? SpellResult.DEACTIVATE : SpellResult.NO_ACTION;
        }
        if (this.parameters.contains("addfriend")) {
            String friendName = this.parameters.getString("addfriend");
            if (friendName == null || friendName.isEmpty()) {
                return SpellResult.NO_ACTION;
            }
            Player online = DeprecatedUtils.getPlayer(friendName);
            if (online == null) {
                return SpellResult.FAIL;
            }
            String uuid = online.getUniqueId().toString();
            if (friends.contains(uuid)) {
                return SpellResult.NO_ACTION;
            }
            friends.add(uuid);
            friendString = StringUtils.join(friends, (String)",");
            mageData.set(this.friendKey, (Object)friendString);
            String message = context.getMessage("add_friend").replace("$name", online.getDisplayName());
            context.sendMessage(message);
            return SpellResult.CAST;
        }
        if (this.parameters.contains("removefriend")) {
            String friendName = this.parameters.getString("removefriend");
            Player online = DeprecatedUtils.getPlayer(friendName);
            if (online == null) {
                return SpellResult.FAIL;
            }
            String uuid = online.getUniqueId().toString();
            if (!friends.contains(uuid)) {
                return SpellResult.NO_ACTION;
            }
            friends.remove(uuid);
            friendString = StringUtils.join(friends, (String)",");
            mageData.set(this.friendKey, (Object)friendString);
            String message = context.getMessage("remove_friend").replace("$name", online.getDisplayName());
            context.sendMessage(message);
            return SpellResult.DEACTIVATE;
        }
        Location playerLocation = mage.getLocation();
        HashSet<RecallType> optionTypes = new HashSet<RecallType>();
        Collection<ConfigurationSection> optionConfiguration = ConfigurationUtils.getNodeList(this.parameters, "options");
        if (optionConfiguration != null) {
            for (ConfigurationSection optionConfig : optionConfiguration) {
                Waypoint newWaypoint = new Waypoint(context, optionConfig);
                this.options.add(newWaypoint);
                optionTypes.add(newWaypoint.type);
            }
        }
        block9: for (RecallType testType : RecallType.values()) {
            if (optionTypes.contains((Object)testType) || !this.parameters.getBoolean("allow_" + testType.name().toLowerCase(), true)) continue;
            switch (testType) {
                case FRIENDS: {
                    Object targetLocation;
                    for (String friendId : friends) {
                        targetLocation = this.getFriend(friendId);
                        if (targetLocation == null || !((Waypoint)targetLocation).isValid(this.allowCrossWorld, playerLocation)) continue;
                        this.options.add((Waypoint)targetLocation);
                    }
                    continue block9;
                }
                case WARP: {
                    if (warpConfig == null) continue block9;
                    Set warpKeys = warpConfig.getKeys(false);
                    for (String warpKey : warpKeys) {
                        ConfigurationSection configurationSection = warpConfig.getConfigurationSection(warpKey);
                        configurationSection.set("warp", (Object)warpKey);
                        Waypoint warp = new Waypoint(context, configurationSection);
                        this.options.add(warp);
                    }
                    continue block9;
                }
                case COMMAND: {
                    if (commandConfig == null) continue block9;
                    Set commandKeys = commandConfig.getKeys(false);
                    for (String commandKey : commandKeys) {
                        ConfigurationSection configurationSection = commandConfig.getConfigurationSection(commandKey);
                        Waypoint command = new Waypoint(context, configurationSection);
                        this.options.add(command);
                    }
                    continue block9;
                }
                case WAND: {
                    Object targetLocation;
                    List<LostWand> lostWands = mage.getLostWands();
                    for (int i = 0; i < lostWands.size(); ++i) {
                        targetLocation = this.getWaypoint(player, testType, i, this.parameters, context);
                        if (targetLocation == null || !((Waypoint)targetLocation).isValid(this.allowCrossWorld, playerLocation)) continue;
                        this.options.add((Waypoint)targetLocation);
                    }
                    continue block9;
                }
                case FIELDS: {
                    Map<String, Location> fields = controller.getHomeLocations(player);
                    if (fields == null) continue block9;
                    for (Map.Entry entry : fields.entrySet()) {
                        Location location = ((Location)entry.getValue()).clone();
                        location.setX(location.getX() + 0.5);
                        location.setZ(location.getZ() + 0.5);
                        this.options.add(new Waypoint(RecallType.FIELDS, location, (String)entry.getKey(), context.getMessage("cast_field"), context.getMessage("no_target_field"), context.getMessage("description_field", ""), RecallAction.getIcon(context, this.parameters, "icon_field"), true));
                    }
                    continue block9;
                }
                default: {
                    Object targetLocation = this.getWaypoint(player, testType, 0, this.parameters, context);
                    if (targetLocation == null || !((Waypoint)targetLocation).isValid(this.allowCrossWorld, playerLocation)) continue block9;
                    this.options.add((Waypoint)targetLocation);
                }
            }
        }
        if (this.parameters.contains("warp")) {
            String warpName = this.parameters.getString("warp");
            Waypoint waypoint = this.getWarp(warpName);
            if (this.tryTeleport(player, waypoint)) {
                return SpellResult.CAST;
            }
            return SpellResult.FAIL;
        }
        if (this.parameters.contains("type")) {
            RecallType recallType;
            Waypoint location;
            String typeString = this.parameters.getString("type", "");
            if (this.parameters.getBoolean("allow_marker", true)) {
                if (typeString.equalsIgnoreCase("remove")) {
                    if (this.removeMarker()) {
                        return SpellResult.TARGET_SELECTED;
                    }
                    return SpellResult.FAIL;
                }
                if (typeString.equalsIgnoreCase("place")) {
                    Block block = context.getLocation().getBlock();
                    if (this.parameters.getBoolean("marker_requires_build", true) && !context.hasBuildPermission(block)) {
                        return SpellResult.NO_TARGET;
                    }
                    if (this.hasMarker() && this.parameters.getBoolean("confirm_marker", true)) {
                        this.showMarkerConfirm(context);
                        return SpellResult.CAST;
                    }
                    if (this.placeMarker(block, 1)) {
                        return SpellResult.TARGET_SELECTED;
                    }
                    return SpellResult.FAIL;
                }
            }
            if (this.tryTeleport(player, location = this.getWaypoint(player, recallType = RecallType.valueOf(typeString.toUpperCase()), 0, this.parameters, context))) {
                return SpellResult.CAST;
            }
            return SpellResult.FAIL;
        }
        if (this.options.size() == 0) {
            return SpellResult.NO_TARGET;
        }
        String inventoryTitle = context.getMessage("title", "Recall");
        int invSize = (int)Math.ceil((float)this.options.size() / 9.0f) * 9;
        Inventory displayInventory = CompatibilityUtils.createInventory(null, invSize, inventoryTitle);
        int index = 0;
        for (Waypoint waypoint : this.options) {
            ItemMeta meta;
            if (waypoint.permission != null && !player.hasPermission(waypoint.permission)) continue;
            boolean isPlaceholder = waypoint.type == RecallType.PLACEHOLDER;
            boolean bl = !isPlaceholder && waypoint.isValid(this.allowCrossWorld, playerLocation);
            boolean isUnavailable = false;
            if (!isPlaceholder && !this.parameters.getBoolean("allow_" + waypoint.type.name().toLowerCase(), true)) {
                isUnavailable = true;
            }
            if (!(isUnavailable || !waypoint.locked || waypoint.warpName != null && unlockedWarps.contains(waypoint.warpName))) {
                if (!waypoint.showUnavailable) continue;
                isUnavailable = true;
            }
            if (!bl) {
                isUnavailable = true;
            }
            if (isUnavailable && !waypoint.showUnavailable) {
                isPlaceholder = true;
            }
            ItemStack waypointItem = null;
            if (isPlaceholder) {
                String iconPlaceholderKey = this.parameters.getString("placeholder_icon", "air");
                waypointItem = controller.createItem(iconPlaceholderKey);
                if (waypointItem == null) {
                    waypointItem = new ItemStack(DefaultWaypointMaterial);
                }
            } else if (isUnavailable) {
                if (waypoint.unavailableIcon != null) {
                    waypointItem = waypoint.unavailableIcon.getItemStack(1);
                } else if (waypoint.iconURL != null && !waypoint.iconURL.isEmpty()) {
                    waypointItem = controller.getURLSkull(waypoint.iconURL);
                } else if (waypoint.icon != null) {
                    waypointItem = waypoint.icon.getItemStack(1);
                }
            } else if (waypoint.iconURL != null && !waypoint.iconURL.isEmpty()) {
                waypointItem = controller.getURLSkull(waypoint.iconURL);
            } else if (waypoint.icon != null) {
                waypointItem = waypoint.icon.getItemStack(1);
            }
            ItemMeta itemMeta = meta = waypointItem == null ? null : waypointItem.getItemMeta();
            if (meta == null && !isPlaceholder) {
                waypointItem = new ItemStack(DefaultWaypointMaterial);
                meta = waypointItem.getItemMeta();
                controller.getLogger().warning("Invalid waypoint icon for " + waypoint.name);
            }
            if (meta != null) {
                List lore;
                String name = waypoint.name;
                if (!bl || isUnavailable || isPlaceholder) {
                    name = context.getMessage("unavailable_name").replace("$name", name);
                }
                meta.setDisplayName(name);
                if (waypoint.description != null && waypoint.description.length() > 0) {
                    ArrayList<String> lore2 = new ArrayList<String>();
                    InventoryUtils.wrapText(waypoint.description, lore2);
                    meta.setLore(lore2);
                }
                String invalidMessage = context.getMessage("invalid_description");
                if (!bl && invalidMessage != null) {
                    lore = meta.getLore();
                    if (lore == null) {
                        lore = new ArrayList();
                    }
                    InventoryUtils.wrapText(invalidMessage, lore);
                    meta.setLore(lore);
                } else if (isUnavailable && waypoint.unavailableMessage != null && waypoint.unavailableMessage.length() > 0) {
                    lore = meta.getLore();
                    if (lore == null) {
                        lore = new ArrayList();
                    }
                    InventoryUtils.wrapText(waypoint.unavailableMessage, lore);
                    meta.setLore(lore);
                }
                waypointItem.setItemMeta(meta);
                waypointItem = InventoryUtils.makeReal(waypointItem);
                InventoryUtils.hideFlags(waypointItem, 63);
                InventoryUtils.setMeta(waypointItem, "waypoint", "true");
                CompatibilityUtils.makeUnbreakable(waypointItem);
                if (isPlaceholder) {
                    InventoryUtils.setMetaBoolean(waypointItem, "placeholder", true);
                }
                if (isUnavailable) {
                    InventoryUtils.setMetaBoolean(waypointItem, "unavailable", true);
                }
            }
            displayInventory.setItem(index, waypointItem);
            ++index;
        }
        mage.activateGUI(this, displayInventory);
        return SpellResult.CAST;
    }

    protected void showMarkerConfirm(CastContext context) {
        this.options.clear();
        String inventoryTitle = context.getMessage("move_marker_title", "Move Marker");
        int invSize = (int)Math.ceil((float)this.markerCount / 9.0f) * 9;
        Inventory displayInventory = CompatibilityUtils.createInventory(null, invSize, inventoryTitle);
        MaterialAndData iconType = RecallAction.getIcon(context, this.parameters, "icon_move_marker");
        int startIndex = 0;
        if (this.markerCount < 8) {
            startIndex = (9 - this.markerCount) / 2;
        }
        for (int marker = 1; marker <= this.markerCount; ++marker) {
            int inventoryIndex = startIndex + marker - 1;
            ItemStack markerItem = iconType.getItemStack(1);
            ItemMeta meta = markerItem.getItemMeta();
            meta.setDisplayName(context.getMessage("title_move_marker").replace("$number", Integer.toString(marker)));
            String description = context.getMessage("description_move_marker");
            if (description != null && description.length() > 0) {
                ArrayList<String> lore = new ArrayList<String>();
                lore.add(description);
                meta.setLore(lore);
            }
            markerItem.setItemMeta(meta);
            markerItem = InventoryUtils.makeReal(markerItem);
            InventoryUtils.hideFlags(markerItem, 63);
            InventoryUtils.setMetaInt(markerItem, "move_marker", marker);
            displayInventory.setItem(inventoryIndex, markerItem);
            context.getMage().activateGUI(this, displayInventory);
        }
    }

    @Nullable
    protected Waypoint getFriend(String uuid) {
        Player onlinePlayer = Bukkit.getPlayer((UUID)UUID.fromString(uuid));
        if (onlinePlayer == null) {
            return null;
        }
        String playerName = onlinePlayer.getDisplayName();
        String castMessage = this.context.getMessage("cast_friend").replace("$name", playerName);
        String failMessage = this.context.getMessage("no_target_friend").replace("$name", playerName);
        String title = this.context.getMessage("title_friend", "$name").replace("$name", playerName);
        String iconURL = SkinUtils.getOnlineSkinURL(onlinePlayer);
        return new Waypoint(RecallType.WARP, onlinePlayer.getLocation(), title, castMessage, failMessage, "", null, iconURL);
    }

    @Nullable
    protected Waypoint getWarp(String warpName) {
        for (Waypoint waypoint : this.options) {
            if (waypoint.type != RecallType.WARP || !waypoint.warpName.equals(warpName)) continue;
            return waypoint;
        }
        return null;
    }

    @Nullable
    protected Waypoint getWaypoint(Player player, RecallType type, int index, ConfigurationSection parameters, CastContext context) {
        Mage mage = context.getMage();
        MageController controller = context.getController();
        switch (type) {
            case MARKER: {
                Location location = ConfigurationUtils.getLocation(mage.getData(), this.markerKey);
                return new Waypoint(type, location, context.getMessage("title_marker"), context.getMessage("cast_marker", "Market"), context.getMessage("no_target_marker"), context.getMessage("description_marker", ""), RecallAction.getIcon(context, parameters, "icon_marker"), true);
            }
            case DEATH: {
                Waypoint death = new Waypoint(type, mage.getLastDeathLocation(), "Last Death", context.getMessage("cast_death", "Last Death"), context.getMessage("no_target_death"), context.getMessage("description_death", ""), RecallAction.getIcon(context, parameters, "icon_death"), true);
                death.safe = false;
                return death;
            }
            case SPAWN: {
                return new Waypoint(type, context.getWorld().getSpawnLocation(), context.getMessage("title_spawn", "Spawn"), context.getMessage("cast_spawn"), context.getMessage("no_target_spawn"), context.getMessage("description_spawn", ""), RecallAction.getIcon(context, parameters, "icon_spawn"), false);
            }
            case TOWN: {
                return new Waypoint(type, controller.getTownLocation(player), context.getMessage("title_town", "Town"), context.getMessage("cast_town"), context.getMessage("no_target_town"), context.getMessage("description_town", ""), RecallAction.getIcon(context, parameters, "icon_town"), false);
            }
            case HOME: {
                Location bedLocation;
                Location location = bedLocation = player == null ? null : player.getBedSpawnLocation();
                if (bedLocation != null) {
                    bedLocation.setX(bedLocation.getX() + 0.5);
                    bedLocation.setZ(bedLocation.getZ() + 0.5);
                    bedLocation.setY(bedLocation.getY() + 1.0);
                }
                return new Waypoint(type, bedLocation, context.getMessage("title_home", "Home"), context.getMessage("cast_home"), context.getMessage("no_target_home"), context.getMessage("description_home", ""), RecallAction.getIcon(context, parameters, "icon_home"), false);
            }
            case WAND: {
                List<LostWand> lostWands = mage.getLostWands();
                if (lostWands == null || index < 0 || index >= lostWands.size()) {
                    return null;
                }
                return new Waypoint(type, lostWands.get(index).getLocation(), context.getMessage("title_wand", "Lost Wand"), context.getMessage("cast_wand"), context.getMessage("no_target_wand"), context.getMessage("description_wand", ""), RecallAction.getIcon(context, parameters, "icon_wand"), true);
            }
        }
        return null;
    }

    @Nullable
    protected static MaterialAndData getIcon(CastContext context, ConfigurationSection parameters, String key) {
        String iconKey = parameters.getString(key);
        if (iconKey == null || iconKey.isEmpty()) {
            return null;
        }
        MaterialAndData material = ConfigurationUtils.getMaterialAndData(parameters, key);
        if (material == null || !material.isValid() || material.getMaterial() == null) {
            context.getLogger().warning("Invalid material specified for " + context.getSpell().getKey() + " " + key + ": " + iconKey);
            return null;
        }
        return material;
    }

    protected boolean removeMarker() {
        Mage mage = this.context.getMage();
        ConfigurationSection mageData = mage.getData();
        Location location = ConfigurationUtils.getLocation(mageData, this.markerKey);
        if (location == null) {
            return false;
        }
        mageData.set(this.markerKey, null);
        return true;
    }

    protected boolean hasMarker() {
        Mage mage = this.context.getMage();
        ConfigurationSection mageData = mage.getData();
        Location location = ConfigurationUtils.getLocation(mageData, this.markerKey);
        return location != null;
    }

    protected boolean tryTeleport(Player player, Waypoint waypoint) {
        Mage mage = this.context.getMage();
        if (waypoint == null) {
            return false;
        }
        if (waypoint.isCommand()) {
            if (waypoint.asConsole) {
                try {
                    player.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), waypoint.command);
                }
                catch (Exception ex) {
                    this.context.getLogger().log(Level.WARNING, "Error running command as console " + waypoint.command, ex);
                }
            } else {
                CommandSender sender = mage.getCommandSender();
                boolean isOp = sender.isOp();
                if (waypoint.opPlayer && !isOp) {
                    sender.setOp(true);
                }
                try {
                    player.getServer().dispatchCommand(sender, waypoint.command);
                }
                catch (Exception ex) {
                    this.context.getLogger().log(Level.WARNING, "Error running command " + waypoint.command, ex);
                }
                if (waypoint.opPlayer && !isOp) {
                    sender.setOp(false);
                }
            }
            mage.enableSuperProtection(this.protectionTime);
            return true;
        }
        Location targetLocation = waypoint.location;
        if (targetLocation == null) {
            String serverName = waypoint.serverName;
            String warpName = waypoint.warpName;
            if (warpName != null && serverName != null) {
                this.context.getController().warpPlayerToServer(player, serverName, warpName);
            } else {
                this.context.sendMessage(waypoint.failMessage);
            }
            return false;
        }
        if (!this.allowCrossWorld && !mage.getLocation().getWorld().equals(targetLocation.getWorld())) {
            this.context.sendMessageKey("cross_world_disallowed");
            return false;
        }
        if (waypoint.maintainDirection) {
            Location playerLocation = player.getLocation();
            targetLocation.setYaw(playerLocation.getYaw());
            targetLocation.setPitch(playerLocation.getPitch());
        }
        mage.enableSuperProtection(this.protectionTime);
        if (this.context.teleport((Entity)player, targetLocation, this.verticalSearchDistance, waypoint.safe, waypoint.safe)) {
            this.context.castMessage(waypoint.message);
        } else {
            this.context.castMessage(waypoint.failMessage);
        }
        return true;
    }

    protected boolean placeMarker(Block target, int markerNumber) {
        if (target == null) {
            return false;
        }
        Mage mage = this.context.getMage();
        ConfigurationSection mageData = mage.getData();
        String markerKey = this.getMarkerKey(markerNumber);
        Location location = ConfigurationUtils.getLocation(mageData, markerKey);
        this.context.registerForUndo(new UndoMarkerMove(mage, location, markerKey));
        if (location != null) {
            this.context.sendMessageKey("cast_marker_move");
        } else {
            this.context.sendMessageKey("cast_marker_place");
        }
        location = this.context.getLocation();
        location.setX((double)target.getX() + 0.5);
        location.setY((double)target.getY());
        location.setZ((double)target.getZ() + 0.5);
        mageData.set(markerKey, (Object)ConfigurationUtils.fromLocation(location));
        return true;
    }

    private class Waypoint
    implements Comparable<Waypoint> {
        public final RecallType type;
        public final String name;
        public final String description;
        public final Location location;
        public final String message;
        public final String failMessage;
        public final MaterialAndData icon;
        public final String iconURL;
        public final String command;
        public final boolean opPlayer;
        public final boolean asConsole;
        public final boolean maintainDirection;
        public final String warpName;
        public final String serverName;
        public final int markerNumber;
        public boolean showUnavailable;
        public String unavailableMessage;
        public MaterialAndData unavailableIcon;
        public boolean safe = true;
        public boolean locked = false;
        public String permission;

        public Waypoint(RecallType type, Location location, String name, String message, String failMessage, String description, MaterialAndData icon, boolean maintainDirection) {
            this.name = ChatColor.translateAlternateColorCodes((char)'&', (String)name);
            this.type = type;
            this.location = location;
            this.message = message;
            this.description = description == null ? null : ChatColor.translateAlternateColorCodes((char)'&', (String)description);
            this.failMessage = failMessage;
            this.icon = icon == null ? defaultMaterial : icon;
            this.iconURL = null;
            this.command = null;
            this.opPlayer = false;
            this.asConsole = false;
            this.maintainDirection = maintainDirection;
            this.markerNumber = 0;
            this.serverName = null;
            this.warpName = null;
        }

        public Waypoint(RecallType type, Location location, String name, String message, String failMessage, String description, MaterialAndData icon, String iconURL) {
            this.name = ChatColor.translateAlternateColorCodes((char)'&', (String)name);
            this.type = type;
            this.location = location;
            this.message = message;
            this.description = description == null ? null : ChatColor.translateAlternateColorCodes((char)'&', (String)description);
            this.failMessage = failMessage;
            this.icon = icon == null ? defaultMaterial : icon;
            this.iconURL = iconURL;
            this.command = null;
            this.opPlayer = false;
            this.asConsole = false;
            this.maintainDirection = false;
            this.markerNumber = 0;
            this.serverName = null;
            this.warpName = null;
        }

        public Waypoint(RecallType type, String warpName, String serverName, String name, String message, String failMessage, String description, MaterialAndData icon, String iconURL) {
            this.name = ChatColor.translateAlternateColorCodes((char)'&', (String)name);
            this.type = type;
            this.location = null;
            this.warpName = warpName;
            this.serverName = serverName;
            this.message = message;
            this.description = description == null ? null : ChatColor.translateAlternateColorCodes((char)'&', (String)description);
            this.failMessage = failMessage;
            this.icon = icon == null ? defaultMaterial : icon;
            this.iconURL = iconURL;
            this.command = null;
            this.opPlayer = false;
            this.asConsole = false;
            this.maintainDirection = false;
            this.markerNumber = 0;
        }

        public Waypoint(RecallType type, String command, boolean opPlayer, boolean asConsole, String name, String message, String failMessage, String description, MaterialAndData icon, String iconURL) {
            this.name = ChatColor.translateAlternateColorCodes((char)'&', (String)name);
            this.type = type;
            this.location = null;
            this.message = message;
            this.description = description == null ? null : ChatColor.translateAlternateColorCodes((char)'&', (String)description);
            this.failMessage = failMessage;
            this.icon = icon == null ? defaultMaterial : icon;
            this.iconURL = iconURL;
            this.command = command;
            this.opPlayer = opPlayer;
            this.asConsole = asConsole;
            this.maintainDirection = false;
            this.markerNumber = 0;
            this.serverName = null;
            this.warpName = null;
        }

        public Waypoint(CastContext context, ConfigurationSection configuration) {
            this.warpName = configuration.getString("warp", "");
            this.command = configuration.getString("command");
            if (this.command != null) {
                this.type = RecallType.COMMAND;
                this.serverName = null;
            } else if (!this.warpName.isEmpty()) {
                this.type = RecallType.WARP;
                this.serverName = configuration.getString("server");
            } else {
                RecallType parsedType;
                try {
                    parsedType = RecallType.valueOf(configuration.getString("type", "placeholder").toUpperCase());
                }
                catch (Exception ex) {
                    parsedType = RecallType.PLACEHOLDER;
                }
                this.type = parsedType;
                this.serverName = null;
            }
            Mage mage = context.getMage();
            Player player = mage.getPlayer();
            MaterialAndData defaultIcon = null;
            String defaultTitle = "";
            String defaultMessage = "";
            String defaultFailMessage = "";
            String defaultDescription = "";
            String defaultUnavailableMessage = context.getMessage("unavailable_description", "");
            MaterialAndData defaultUnavailableIcon = ConfigurationUtils.getMaterialAndData(RecallAction.this.parameters, "unavailable_icon");
            boolean defaultShowUnavailable = RecallAction.this.parameters.getBoolean("show_unavailable", false);
            Location location = null;
            int markerNumber = 0;
            boolean defaultMaintainDirection = false;
            boolean defaultSafe = true;
            switch (this.type) {
                case COMMAND: {
                    defaultTitle = context.getMessage("title_warp", "$name").replace("$name", this.command);
                    defaultMessage = context.getMessage("cast_warp", "");
                    defaultFailMessage = context.getMessage("no_target_warp", "");
                    defaultUnavailableMessage = RecallAction.this.parameters.getString("unavailable_warp_description", "");
                    break;
                }
                case WARP: {
                    defaultTitle = context.getMessage("title_warp", "$name").replace("$name", this.warpName);
                    defaultMessage = context.getMessage("cast_warp", "");
                    defaultFailMessage = context.getMessage("no_target_warp", "");
                    defaultUnavailableMessage = context.getMessage("unavailable_warp_description", "");
                    location = context.getController().getWarp(this.warpName);
                    break;
                }
                case MARKER: {
                    markerNumber = configuration.getInt("marker", 1);
                    location = ConfigurationUtils.getLocation(mage.getData(), RecallAction.this.getMarkerKey(markerNumber));
                    defaultTitle = context.getMessage("title_marker", "Marker #$number").replace("$number", Integer.toString(markerNumber));
                    defaultMessage = context.getMessage("cast_marker", "").replace("$number", Integer.toString(markerNumber));
                    defaultFailMessage = context.getMessage("no_target_marker", "").replace("$number", Integer.toString(markerNumber));
                    defaultDescription = context.getMessage("description_marker", "").replace("$number", Integer.toString(markerNumber));
                    defaultIcon = RecallAction.getIcon(context, RecallAction.this.parameters, "icon_marker");
                    defaultMaintainDirection = true;
                    break;
                }
                case DEATH: {
                    location = mage.getLastDeathLocation();
                    defaultTitle = context.getMessage("title_death", "Last Death");
                    defaultMessage = context.getMessage("cast_death", "");
                    defaultFailMessage = context.getMessage("no_target_death", "");
                    defaultDescription = context.getMessage("description_death", "");
                    String iconString = RecallAction.this.parameters.getString("icon_death");
                    defaultIcon = iconString.equals("skull_item") ? DefaultMaterials.getSkeletonSkullItem() : RecallAction.getIcon(context, RecallAction.this.parameters, "icon_death");
                    defaultMaintainDirection = true;
                    defaultSafe = false;
                    break;
                }
                case SPAWN: {
                    location = context.getWorld().getSpawnLocation();
                    defaultTitle = context.getMessage("title_spawn", "Spawn");
                    defaultMessage = context.getMessage("cast_spawn", "");
                    defaultFailMessage = context.getMessage("no_target_spawn", "");
                    defaultDescription = context.getMessage("description_spawn", "");
                    defaultIcon = RecallAction.getIcon(context, RecallAction.this.parameters, "icon_spawn");
                    break;
                }
                case TOWN: {
                    location = player == null ? null : context.getController().getTownLocation(player);
                    defaultTitle = context.getMessage("title_town", "Town");
                    defaultMessage = context.getMessage("cast_town", "");
                    defaultFailMessage = context.getMessage("no_target_town", "");
                    defaultDescription = context.getMessage("description_town", "");
                    defaultIcon = RecallAction.getIcon(context, RecallAction.this.parameters, "icon_town");
                    break;
                }
                case HOME: {
                    Location bedLocation;
                    Location location2 = bedLocation = player == null ? null : player.getBedSpawnLocation();
                    if (bedLocation != null) {
                        bedLocation = bedLocation.clone();
                        bedLocation.setX(bedLocation.getX() + 0.5);
                        bedLocation.setZ(bedLocation.getZ() + 0.5);
                        bedLocation.setY(bedLocation.getY() + 1.0);
                    }
                    location = bedLocation;
                    defaultTitle = context.getMessage("title_home", "Home");
                    defaultMessage = context.getMessage("cast_home", "");
                    defaultFailMessage = context.getMessage("no_target_home", "");
                    defaultDescription = context.getMessage("description_home", "");
                    defaultIcon = RecallAction.getIcon(context, RecallAction.this.parameters, "icon_home");
                    break;
                }
            }
            String optionName = configuration.getString("name", defaultTitle);
            this.name = ChatColor.translateAlternateColorCodes((char)'&', (String)optionName);
            this.message = configuration.getString("message", defaultMessage).replace("$name", this.name);
            this.description = ChatColor.translateAlternateColorCodes((char)'&', (String)configuration.getString("description", defaultDescription));
            this.failMessage = configuration.getString("fail_message", defaultFailMessage).replace("$name", this.name);
            this.icon = ConfigurationUtils.getMaterialAndData(configuration, "icon", defaultIcon);
            this.iconURL = configuration.getString("icon_url");
            this.opPlayer = configuration.getBoolean("op");
            this.asConsole = configuration.getBoolean("console");
            this.maintainDirection = configuration.getBoolean("keep_direction", defaultMaintainDirection);
            this.safe = configuration.getBoolean("safe", defaultSafe);
            this.showUnavailable = configuration.getBoolean("show_unavailable", defaultShowUnavailable);
            this.unavailableIcon = ConfigurationUtils.getMaterialAndData(configuration, "icon_disabled", defaultUnavailableIcon);
            this.unavailableMessage = configuration.getString("unavailable_description", defaultUnavailableMessage);
            this.locked = configuration.getBoolean("locked", false);
            this.permission = configuration.getString("permission");
            this.location = location;
            this.markerNumber = markerNumber;
        }

        @Override
        public int compareTo(Waypoint o) {
            if (this.type != o.type) {
                if (this.type == RecallType.COMMAND) {
                    return -1;
                }
                if (o.type == RecallType.COMMAND) {
                    return 1;
                }
                if (this.type == RecallType.WARP) {
                    return -1;
                }
                if (o.type == RecallType.WARP) {
                    return 1;
                }
            }
            return this.name.compareTo(o.name);
        }

        public boolean isValid(boolean crossWorld, Location source) {
            if (this.isCommand()) {
                return true;
            }
            if (this.location == null || this.location.getWorld() == null) {
                return this.serverName != null && this.warpName != null;
            }
            return crossWorld || source.getWorld().equals(this.location.getWorld());
        }

        public boolean isCommand() {
            return this.command != null;
        }
    }

    private static enum RecallType {
        FIELDS,
        DEATH,
        SPAWN,
        TOWN,
        HOME,
        MARKER,
        WAND,
        COMMAND,
        WARP,
        FRIENDS,
        PLACEHOLDER;

    }

    private static class UndoMarkerMove
    implements Runnable {
        private final Location location;
        private final Mage mage;
        private final String markerKey;

        public UndoMarkerMove(Mage mage, Location currentLocation, String markerKey) {
            this.location = currentLocation;
            this.mage = mage;
            this.markerKey = markerKey;
        }

        @Override
        public void run() {
            this.mage.getData().set(this.markerKey, (Object)ConfigurationUtils.fromLocation(this.location));
        }
    }
}

