/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.command;

import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.api.wand.WandTemplate;
import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.magic.command.MagicTabExecutor;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class MagicConfigCommandExecutor
extends MagicTabExecutor {
    private static final String CUSTOM_FILE_NAME = "_customizations.yml";
    private static Set<String> availableFiles = ImmutableSet.of((Object)"spells", (Object)"wands", (Object)"automata", (Object)"classes", (Object)"config", (Object)"crafting", (Object[])new String[]{"effects", "items", "materials", "mobs", "paths", "attributes"});
    private static final Map<String, String> availableFileMap = ImmutableMap.builder().put((Object)"spell", (Object)"spells").put((Object)"wand", (Object)"wands").put((Object)"automaton", (Object)"automata").put((Object)"class", (Object)"classes").put((Object)"recipe", (Object)"crafting").put((Object)"effect", (Object)"effects").put((Object)"item", (Object)"items").put((Object)"material", (Object)"materials").put((Object)"mob", (Object)"mobs").put((Object)"path", (Object)"paths").put((Object)"attribute", (Object)"attributes").build();

    public MagicConfigCommandExecutor(MagicAPI api, MagicController controller) {
        super(api, "mconfig");
    }

    @Override
    public Collection<String> onTabComplete(CommandSender sender, String commandName, String[] args) {
        String fileType;
        HashSet<String> options = new HashSet<String>();
        if (!sender.hasPermission("Magic.commands.mconfig")) {
            return options;
        }
        if (args.length == 1) {
            this.addIfPermissible(sender, options, "Magic.commands.mconfig.clean", "clean");
            this.addIfPermissible(sender, options, "Magic.commands.mconfig.disable", "disable");
            this.addIfPermissible(sender, options, "Magic.commands.mconfig.enable", "enable");
            this.addIfPermissible(sender, options, "Magic.commands.mconfig.configure", "configure");
        }
        String subCommand = args[0];
        if (args.length == 2 && (subCommand.equals("disable") || subCommand.equals("enable") || subCommand.equals("configure"))) {
            options.addAll(availableFileMap.keySet());
        }
        if (args.length == 3 && (subCommand.equals("disable") || subCommand.equals("configure")) && (fileType = this.getFileParameter(args[1])) != null) {
            Collection<String> list;
            if (fileType.equals("spells")) {
                Collection<SpellTemplate> spellList = this.api.getController().getSpellTemplates(true);
                for (SpellTemplate spell : spellList) {
                    options.add(spell.getKey());
                }
            }
            if (fileType.equals("wands")) {
                Collection<WandTemplate> wandList = this.api.getController().getWandTemplates();
                for (WandTemplate wand : wandList) {
                    options.add(wand.getKey());
                }
            }
            if (fileType.equals("paths")) {
                Set<String> pathList = this.api.getController().getWandPathKeys();
                for (String path : pathList) {
                    options.add(path);
                }
            }
            if (fileType.equals("crafting")) {
                Collection<String> recipeList = this.api.getController().getRecipeKeys();
                for (String recipe : recipeList) {
                    options.add(recipe);
                }
            }
            if (fileType.equals("mobs")) {
                Set<String> mobList = this.api.getController().getMobKeys();
                for (String mob : mobList) {
                    options.add(mob);
                }
            }
            if (fileType.equals("items")) {
                Set<String> itemList = this.api.getController().getItemKeys();
                for (String item : itemList) {
                    options.add(item);
                }
            }
            if (fileType.equals("automata")) {
                list = this.api.getController().getAutomatonTemplateKeys();
                for (String key : list) {
                    options.add(key);
                }
            }
            if (fileType.equals("classes")) {
                list = this.api.getController().getMageClassKeys();
                for (String key : list) {
                    options.add(key);
                }
            }
            if (fileType.equals("attributes")) {
                list = this.api.getController().getAttributes();
                for (String key : list) {
                    options.add(key);
                }
            }
            if (fileType.equals("effects")) {
                list = this.api.getController().getEffectKeys();
                for (String key : list) {
                    options.add(key);
                }
            }
        }
        return options;
    }

    public boolean onCommand(CommandSender sender, Command command, String alias, String[] args) {
        if (!this.api.hasPermission(sender, this.getPermissionNode())) {
            this.sendNoPermission(sender);
            return true;
        }
        if (args.length == 0) {
            return false;
        }
        String subCommand = args[0];
        if (!this.api.hasPermission(sender, "Magic.commands.mconfig." + subCommand)) {
            this.sendNoPermission(sender);
            return true;
        }
        if (subCommand.equals("clean")) {
            this.onMagicClean(sender, args.length > 1 ? args[1] : "");
            return true;
        }
        String[] parameters = Arrays.copyOfRange(args, 1, args.length);
        if (subCommand.equals("enable")) {
            this.onMagicEnable(sender, parameters);
            return true;
        }
        if (subCommand.equals("disable")) {
            this.onMagicDisable(sender, parameters);
            return true;
        }
        if (subCommand.equals("configure")) {
            this.onMagicConfigure(sender, parameters);
            return true;
        }
        return false;
    }

    protected String getFileParameter(String fileKey) {
        if (availableFiles.contains(fileKey)) {
            return fileKey;
        }
        return availableFileMap.get(fileKey);
    }

    protected String escapeMessage(String message, String type, String key) {
        return this.escapeMessage(message, type, key, ' ');
    }

    protected String escapeMessage(String message, String type, String key, char delimiter) {
        return message.replace("$type", type).replace("$key", key).replace("$options", StringUtils.join(availableFileMap.keySet(), (char)delimiter));
    }

    @Nullable
    protected File getConfigFile(CommandSender sender, String command, String[] parameters) {
        if (parameters.length < 2) {
            sender.sendMessage(this.escapeMessage(this.controller.getMessages().get("commands.mconfig." + command + ".usage"), "", "", '|'));
            return null;
        }
        String fileKey = this.getFileParameter(parameters[0]);
        if (fileKey == null) {
            sender.sendMessage(this.escapeMessage(this.controller.getMessages().get("commands.mconfig." + command + ".nokey"), fileKey, "", ','));
            return null;
        }
        return new File(this.controller.getPlugin().getDataFolder() + File.separator + fileKey, CUSTOM_FILE_NAME);
    }

    protected void trySave(String command, CommandSender sender, File configFile, YamlConfiguration configuration, String fileKey, String key) {
        try {
            configuration.save(configFile);
            sender.sendMessage(this.escapeMessage(this.controller.getMessages().get("commands.mconfig." + command + ".success"), fileKey, key));
        }
        catch (Exception ex) {
            sender.sendMessage(this.controller.getMessages().get("commands.mconfig.write_failed").replace("$file", configFile.getName()));
            this.controller.getLogger().log(Level.SEVERE, "Could not write to file " + configFile.getAbsoluteFile(), ex);
        }
    }

    protected void setPath(ConfigurationSection config, String path, Object value) {
        String[] pieces = StringUtils.split((String)path);
        for (int i = 0; i < pieces.length - 1; ++i) {
            config = config.createSection(pieces[i]);
        }
        config.set(pieces[pieces.length - 1], value);
    }

    protected void onMagicDisable(CommandSender sender, String[] parameters) {
        File configFile = this.getConfigFile(sender, "disable", parameters);
        if (configFile == null) {
            return;
        }
        String key = parameters[1];
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)configFile);
        this.setPath((ConfigurationSection)configuration, key + ".enabled", false);
        this.trySave("disable", sender, configFile, configuration, parameters[0], key);
    }

    protected void onMagicEnable(CommandSender sender, String[] parameters) {
        File configFile = this.getConfigFile(sender, "enable", parameters);
        if (configFile == null) {
            return;
        }
        String key = parameters[1];
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)configFile);
        this.setPath((ConfigurationSection)configuration, key + ".enabled", true);
        this.trySave("enable", sender, configFile, configuration, parameters[0], key);
    }

    protected void onMagicConfigure(CommandSender sender, String[] parameters) {
        File configFile = this.getConfigFile(sender, "configure", parameters);
        if (configFile == null) {
            return;
        }
        if (parameters.length < 3) {
            sender.sendMessage(this.escapeMessage(this.controller.getMessages().get("commands.mconfig.configure.usage"), "", "", '|'));
            return;
        }
        String key = parameters[1];
        String path = key + "." + parameters[2];
        String value = "";
        if (parameters.length > 3) {
            value = StringUtils.join((Object[])Arrays.copyOfRange(parameters, 3, parameters.length), (char)' ');
        }
        YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)configFile);
        this.setPath((ConfigurationSection)configuration, path, value);
        this.trySave("configure", sender, configFile, configuration, parameters[0], key);
    }

    protected void onMagicClean(CommandSender sender, String configName) {
        ArrayList<String> configFiles = new ArrayList<String>();
        if (!configName.isEmpty()) {
            configFiles.add(configName);
        } else {
            configFiles.add("spells");
            configFiles.add("wands");
            configFiles.add("paths");
            configFiles.add("mobs");
            configFiles.add("items");
            configFiles.add("crafting");
            configFiles.add("materials");
            configFiles.add("messages");
        }
        File pluginFolder = this.api.getPlugin().getDataFolder();
        Collection<String> examples = this.controller.getLoadedExamples();
        Plugin plugin = this.controller.getPlugin();
        for (String configFileName : configFiles) {
            sender.sendMessage(ChatColor.AQUA + "Checking " + ChatColor.DARK_AQUA + configFileName);
            try {
                File defaultsFile = new File(pluginFolder, "defaults/" + configFileName + ".defaults.yml");
                File configFile = new File(pluginFolder, configFileName + ".yml");
                YamlConfiguration cleanConfig = new YamlConfiguration();
                YamlConfiguration currentConfig = new YamlConfiguration();
                currentConfig.load(configFile);
                YamlConfiguration defaultConfig = new YamlConfiguration();
                defaultConfig.load(defaultsFile);
                for (String string : examples) {
                    String examplesFileName = "examples/" + string + "/" + configFileName + ".yml";
                    InputStream input = plugin.getResource(examplesFileName);
                    if (input == null) continue;
                    YamlConfiguration exampleConfig = CompatibilityUtils.loadConfiguration(input);
                    ConfigurationUtils.addConfigurations((ConfigurationSection)defaultConfig, (ConfigurationSection)exampleConfig, false);
                }
                Set allKeys = currentConfig.getKeys(true);
                for (String key : allKeys) {
                    Object defaultValue = defaultConfig.get(key);
                    Object configValue = currentConfig.get(key);
                    if (configValue instanceof ConfigurationSection || !this.areDifferent(configValue, defaultValue)) continue;
                    cleanConfig.set(key, configValue);
                }
                int n = currentConfig.getKeys(false).size();
                int cleanTopSize = cleanConfig.getKeys(false).size();
                int cleanSize = cleanConfig.getKeys(true).size();
                int removedCount = allKeys.size() - cleanSize;
                if (removedCount > 0) {
                    int removedTopCount = n - cleanTopSize;
                    sender.sendMessage(ChatColor.LIGHT_PURPLE + "Removed " + ChatColor.GOLD + removedTopCount + ChatColor.LIGHT_PURPLE + " top-level sections and " + ChatColor.GOLD + removedCount + ChatColor.LIGHT_PURPLE + " total sections.");
                    File backupFile = new File(pluginFolder, configFileName + ".yml.bak");
                    if (backupFile.exists()) {
                        sender.sendMessage(ChatColor.YELLOW + "  Backup file exists, will not overwrite: " + backupFile.getName());
                    } else {
                        sender.sendMessage(ChatColor.DARK_PURPLE + "  Saved backup file to " + backupFile.getName() + ", delete this file if all looks good.");
                        Files.copy((File)configFile, (File)backupFile);
                    }
                    String[] lines = StringUtils.split((String)cleanConfig.saveToString(), (char)'\n');
                    PrintWriter out = new PrintWriter(configFile, "UTF-8");
                    out.println("#");
                    out.println("# Default options have been removed from the file via /mconfig clean");
                    out.println("#");
                    for (String line : lines) {
                        if (!line.startsWith(" ")) {
                            out.println("");
                        }
                        out.println(line);
                    }
                    out.close();
                    continue;
                }
                sender.sendMessage(ChatColor.GOLD + "Looks clean to me!");
            }
            catch (Exception ex) {
                sender.sendMessage(ChatColor.RED + "An error occurred, please check logs!");
                ex.printStackTrace();
            }
        }
    }

    private boolean areDifferent(Object configValue, Object defaultValue) {
        if (defaultValue == null) {
            return true;
        }
        if (configValue instanceof ConfigurationSection || configValue instanceof Map) {
            if (!(defaultValue instanceof ConfigurationSection) && !(defaultValue instanceof Map)) {
                return true;
            }
            Map<String, Object> configMap = configValue instanceof ConfigurationSection ? NMSUtils.getMap((ConfigurationSection)configValue) : (Map<String, Object>)configValue;
            Map<String, Object> defaultMap = defaultValue instanceof ConfigurationSection ? NMSUtils.getMap((ConfigurationSection)defaultValue) : (Map<String, Object>)defaultValue;
            return !configMap.equals(defaultMap);
        }
        if (configValue instanceof List) {
            if (!(defaultValue instanceof List)) {
                return true;
            }
            List configList = (List)configValue;
            List defaultList = (List)defaultValue;
            if (configList.size() != defaultList.size()) {
                return true;
            }
            for (int i = 0; i < configList.size(); ++i) {
                if (!this.areDifferent(configList.get(i), defaultList.get(i))) continue;
                return true;
            }
            return false;
        }
        return !defaultValue.equals(configValue);
    }
}

