/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.api.magic;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;

public class Trigger {
    @Nonnull
    private final String trigger;
    private final int interval;
    private final double maxHealth;
    private final double minHealth;
    private final double maxHealthPercentage;
    private final double minHealthPercentage;
    private final double maxDamage;
    private final double minDamage;
    private final double maxBowPull;
    private final double minBowPull;
    private final boolean isCancelLaunch;
    private final String damageType;
    private final Set<String> damageTypes;
    private final Set<EntityType> projectileTypes;
    private long lastTrigger;

    public Trigger(MageController controller, ConfigurationSection configuration) {
        this(controller, configuration, "");
    }

    public Trigger(MageController controller, ConfigurationSection configuration, String defaultType) {
        this.trigger = configuration.getString("trigger", configuration.getString("type", defaultType)).toLowerCase();
        this.interval = configuration.getInt("interval");
        this.maxHealth = configuration.getDouble("max_health");
        this.minHealth = configuration.getDouble("min_health");
        this.maxHealthPercentage = configuration.getDouble("max_health_percentage");
        this.minHealthPercentage = configuration.getDouble("min_health_percentage");
        this.maxDamage = configuration.getDouble("max_damage");
        this.minDamage = configuration.getDouble("min_damage");
        this.isCancelLaunch = configuration.getBoolean("cancel_launch", true);
        this.maxBowPull = configuration.getDouble("max_bowpull");
        this.minBowPull = configuration.getDouble("min_bowpull");
        this.damageType = configuration.getString("damage_type");
        List damageTypeList = configuration.getStringList("damage_types");
        damageTypeList.replaceAll(String::toLowerCase);
        this.damageTypes = damageTypeList.isEmpty() ? null : new HashSet(damageTypeList);
        List projectileTypeList = configuration.getStringList("projectile_types");
        String projectileType = configuration.getString("projectile_type");
        if (projectileType != null && !projectileType.isEmpty()) {
            projectileTypeList.add(projectileType);
        }
        if (projectileTypeList.isEmpty()) {
            this.projectileTypes = null;
        } else {
            this.projectileTypes = new HashSet<EntityType>();
            for (String t : projectileTypeList) {
                try {
                    EntityType entityType = EntityType.valueOf((String)t.toUpperCase());
                    this.projectileTypes.add(entityType);
                }
                catch (Exception ex) {
                    controller.getLogger().warning("Invalid projectile type: " + t);
                }
            }
        }
    }

    public int getInterval() {
        return this.interval;
    }

    @Nonnull
    public String getTrigger() {
        return this.trigger;
    }

    public boolean isValid(Mage mage) {
        String lastDamageType = null;
        double damage = 0.0;
        if (this.trigger.equalsIgnoreCase("damage_dealt")) {
            lastDamageType = mage.getLastDamageDealtType();
            damage = mage.getLastDamage();
        } else {
            lastDamageType = mage.getLastDamageType();
            damage = mage.getLastDamageDealt();
        }
        if (this.minDamage > 0.0 && damage < this.minDamage) {
            return false;
        }
        if (this.maxDamage > 0.0 && damage > this.maxDamage) {
            return false;
        }
        if (this.minHealth > 0.0 && mage.getHealth() < this.minHealth) {
            return false;
        }
        if (this.maxHealth > 0.0 && mage.getHealth() > this.maxHealth) {
            return false;
        }
        if (this.minHealthPercentage > 0.0 && mage.getHealth() * 100.0 / mage.getMaxHealth() < this.minHealthPercentage) {
            return false;
        }
        if (this.maxHealthPercentage > 0.0 && mage.getHealth() * 100.0 / mage.getMaxHealth() > this.maxHealthPercentage) {
            return false;
        }
        if (this.minBowPull > 0.0 && mage.getLastBowPull() < this.minBowPull) {
            return false;
        }
        if (this.maxBowPull > 0.0 && mage.getLastBowPull() > this.maxBowPull) {
            return false;
        }
        if (this.interval > 0 && System.currentTimeMillis() < this.lastTrigger + (long)this.interval) {
            return false;
        }
        if (!(this.damageType == null || this.damageType.isEmpty() || lastDamageType != null && lastDamageType.equalsIgnoreCase(this.damageType))) {
            return false;
        }
        EntityType lastProjectileType = mage.getLastProjectileType();
        if (!(this.damageTypes == null || lastDamageType != null && this.damageTypes.contains(lastDamageType.toLowerCase()))) {
            return false;
        }
        return this.projectileTypes == null || lastProjectileType != null && this.projectileTypes.contains(lastProjectileType);
    }

    public void triggered() {
        this.lastTrigger = System.currentTimeMillis();
    }

    public boolean isCancelLaunch() {
        return this.isCancelLaunch;
    }
}

