/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.UndoableSpell;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.SafetyUtils;
import com.elmakers.mine.bukkit.utility.Target;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

@Deprecated
public class PushSpell
extends UndoableSpell {
    private static final int DEFAULT_ITEM_MAGNITUDE = 1;
    private static final int DEFAULT_ENTITY_MAGNITUDE = 3;
    private static final int DEFAULT_MAX_ALL_DISTANCE = 20;

    public void forceAll(Entity sourceEntity, double mutliplier, boolean pull, int entityMagnitude, int itemMagnitude, int maxAllDistance, double damage, int fallProtection) {
        float maxDistance = (float)maxAllDistance * this.mage.getRangeMultiplier();
        float maxDistanceSquared = maxDistance * maxDistance;
        List entities = this.getWorld().getEntities();
        for (Entity target : entities) {
            Location targetLocation;
            Location playerLocation;
            Mage mage;
            if (target == sourceEntity || !this.canTarget(target)) continue;
            Mage mage2 = mage = this.controller.isMage(target) ? this.controller.getMage(target) : null;
            if (mage != null && mage.isSuperProtected()) continue;
            if (mage != null && fallProtection > 0) {
                mage.enableFallProtection(fallProtection);
            }
            if ((playerLocation = this.getLocation()).distanceSquared(targetLocation = target.getLocation()) > (double)maxDistanceSquared) continue;
            int magnitude = target instanceof LivingEntity ? entityMagnitude : itemMagnitude;
            this.forceEntity(target, mutliplier, playerLocation, targetLocation, magnitude, damage, pull);
            this.getCurrentTarget().setEntity(target);
        }
    }

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        boolean push = false;
        boolean pull = false;
        Entity sourceEntity = this.mage.getEntity();
        String typeString = parameters.getString("type", "");
        push = typeString.equals("push");
        pull = typeString.equals("pull");
        double multiplier = parameters.getDouble("size", 1.0);
        if (push) {
            multiplier *= (double)this.mage.getDamageMultiplier();
        }
        int count = parameters.getInt("count", 0);
        boolean allowAll = this.mage.isSuperPowered() || parameters.getBoolean("allow_area", true);
        boolean forceArea = parameters.getBoolean("area", false);
        int itemMagnitude = parameters.getInt("item_force", 1);
        int entityMagnitude = parameters.getInt("entity_force", 3);
        int maxAllDistance = parameters.getInt("area_range", 20);
        int fallProtection = parameters.getInt("fall_protection", 0);
        double damage = parameters.getDouble("damage", 0.0) * (double)this.mage.getDamageMultiplier();
        if (this.mage.isSuperPowered()) {
            allowAll = true;
        }
        if (allowAll && (forceArea || this.isLookingDown() || this.isLookingUp())) {
            this.forceAll(sourceEntity, multiplier, pull, entityMagnitude, itemMagnitude, maxAllDistance, damage, fallProtection);
            return SpellResult.ALTERNATE;
        }
        Target directTarget = this.getTarget();
        List<Target> targets = this.getAllTargetEntities();
        if (directTarget.hasEntity() && targets.size() == 0) {
            targets.add(directTarget);
        }
        if (targets.size() == 0) {
            return SpellResult.NO_TARGET;
        }
        int pushed = 0;
        for (Target target : targets) {
            Mage mage;
            Entity targetEntity = target.getEntity();
            Mage mage2 = mage = targetEntity != null && this.controller.isMage(targetEntity) ? this.controller.getMage(targetEntity) : null;
            if (mage != null && mage.isSuperProtected()) continue;
            if (mage != null && fallProtection > 0) {
                mage.enableFallProtection(fallProtection);
            }
            int magnitude = target instanceof LivingEntity ? entityMagnitude : itemMagnitude;
            this.getCurrentTarget().setEntity(targetEntity);
            this.forceEntity(targetEntity, multiplier, this.getLocation(), target.getLocation(), magnitude, damage, pull);
            if (count <= 0 || ++pushed < count) continue;
            break;
        }
        return SpellResult.CAST;
    }

    protected void forceEntity(Entity target, double multiplier, Location sourceLocation, Location targetLocation, int magnitude, double damage, boolean pull) {
        Vector fromVector;
        Mage targetMage;
        if (this.controller.isMage(target) && this.isSuperProtected(targetMage = this.controller.getMage(target))) {
            return;
        }
        if (target instanceof Hanging) {
            return;
        }
        if (target instanceof LivingEntity) {
            LivingEntity li = (LivingEntity)target;
            this.registerModified((Entity)li);
            if (damage > 0.0) {
                CompatibilityUtils.magicDamage((Damageable)li, damage, this.mage.getEntity());
            }
        }
        Location to = pull ? targetLocation : sourceLocation;
        Location from = pull ? sourceLocation : targetLocation;
        this.registerVelocity(target);
        magnitude = (int)((double)magnitude * multiplier);
        Vector toVector = new Vector(to.getBlockX(), to.getBlockY(), to.getBlockZ());
        Vector forceVector = fromVector = new Vector(from.getBlockX(), from.getBlockY(), from.getBlockZ());
        forceVector.subtract(toVector);
        if (forceVector.lengthSquared() < 1.0) {
            forceVector = sourceLocation.getDirection();
            if (pull) {
                forceVector.multiply(-1);
            }
        }
        forceVector.normalize();
        forceVector.multiply(magnitude);
        SafetyUtils.setVelocity(target, forceVector);
    }
}

