/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic.listener;

import com.elmakers.mine.bukkit.api.event.MagicMobDeathEvent;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.entity.EntityData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class MobController
implements Listener {
    private MageController controller;
    private final Map<String, EntityData> mobs = new HashMap<String, EntityData>();
    private final Map<String, EntityData> mobsByName = new HashMap<String, EntityData>();
    private final Map<EntityType, EntityData> defaultMobs = new HashMap<EntityType, EntityData>();

    public MobController(MageController controller) {
        this.controller = controller;
    }

    public void clear() {
        this.mobs.clear();
        this.mobsByName.clear();
    }

    public void load(String mobKey, ConfigurationSection mobConfiguration) {
        if (!mobConfiguration.getBoolean("enabled", true)) {
            return;
        }
        EntityData mob = new EntityData(this.controller, mobKey, mobConfiguration);
        try {
            EntityType defaultType = EntityType.valueOf((String)mobKey.toUpperCase());
            this.defaultMobs.put(defaultType, mob);
            return;
        }
        catch (Exception defaultType) {
            this.mobs.put(mobKey, mob);
            String mobName = mob.getName();
            if (mobName != null && !mobName.isEmpty()) {
                this.mobsByName.put(mobName, mob);
            }
            return;
        }
    }

    @EventHandler(ignoreCancelled=false, priority=EventPriority.HIGHEST)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        if (EntityData.isSpawning) {
            return;
        }
        LivingEntity entity = event.getEntity();
        CreatureSpawnEvent.SpawnReason reason = event.getSpawnReason();
        if (reason != CreatureSpawnEvent.SpawnReason.SPAWNER && reason != CreatureSpawnEvent.SpawnReason.SPAWNER_EGG && reason != CreatureSpawnEvent.SpawnReason.DISPENSE_EGG && reason != CreatureSpawnEvent.SpawnReason.CUSTOM) {
            return;
        }
        Plugin plugin = this.controller.getPlugin();
        plugin.getServer().getScheduler().runTaskLater(plugin, new Runnable((Entity)entity){
            final /* synthetic */ Entity val$entity;
            {
                this.val$entity = entity;
            }

            @Override
            public void run() {
                EntityData customMob;
                String customName = this.val$entity.getCustomName();
                if (customName != null) {
                    EntityData customMob2 = (EntityData)MobController.this.mobsByName.get(customName);
                    if (customMob2 != null) {
                        customMob2.modify(MobController.this.controller, this.val$entity);
                    }
                } else if (this.val$entity.getType() != EntityType.PLAYER && (customMob = (EntityData)MobController.this.defaultMobs.get(this.val$entity.getType())) != null) {
                    customMob.modify(MobController.this.controller, this.val$entity);
                }
            }
        }, 1L);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onEntityTarget(EntityTargetEvent event) {
        if (event.isCancelled() || !event.getEntity().hasMetadata("docile")) {
            return;
        }
        if (event.getReason() == EntityTargetEvent.TargetReason.CLOSEST_PLAYER) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityTargetEntity(EntityTargetLivingEntityEvent event) {
        Mage mage;
        Entity source = event.getEntity();
        if (source instanceof Player || event.isCancelled()) {
            return;
        }
        LivingEntity target = event.getTarget();
        if (target != null) {
            Mage targetMage;
            if (source.hasMetadata("owner")) {
                List metadata = source.getMetadata("owner");
                for (MetadataValue value : metadata) {
                    String ownerId = value.asString();
                    Mage mageOwner = this.controller.getRegisteredMage(ownerId);
                    if (mageOwner == null || mageOwner.getEntity() != target) continue;
                    event.setCancelled(true);
                    return;
                }
            }
            if ((targetMage = this.controller.getRegisteredMage((Entity)target)) != null && targetMage.isSuperProtected()) {
                event.setCancelled(true);
                return;
            }
        }
        if ((mage = this.controller.getRegisteredMage(source)) == null) {
            return;
        }
        Entity currentTarget = mage.getTopDamager();
        if (currentTarget != null && currentTarget != target) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity died = entity;
        String name = died.getCustomName();
        if (name == null || name.isEmpty()) {
            EntityData mob = this.defaultMobs.get(died.getType());
            if (mob != null && !died.hasMetadata("nodrops")) {
                mob.modifyDrops(this.controller, event);
            }
            return;
        }
        EntityData mob = this.mobsByName.get(name);
        if (mob == null) {
            return;
        }
        MagicMobDeathEvent deathEvent = new MagicMobDeathEvent(this.controller, mob, event);
        Bukkit.getPluginManager().callEvent((Event)deathEvent);
        if (!died.hasMetadata("nodrops")) {
            mob.modifyDrops(this.controller, event);
        }
        died.setCustomNameVisible(false);
        died.setCustomName(null);
    }

    public int getCount() {
        return this.mobs.size();
    }

    public Set<String> getKeys() {
        return this.mobs.keySet();
    }

    public EntityData get(String key) {
        return this.mobs.get(key);
    }

    public EntityData getByName(String name) {
        return this.mobsByName.get(name);
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent event) {
        Chunk chunk = event.getChunk();
        Collection<Mage> magicMobs = this.controller.getMobMages();
        ArrayList<Entity> toRemove = null;
        for (Mage mage : magicMobs) {
            Entity entity = mage.getEntity();
            if (entity == null) continue;
            Location location = entity.getLocation();
            if (!chunk.getWorld().getName().equals(location.getWorld().getName())) continue;
            int chunkX = chunk.getX();
            int chunkZ = chunk.getZ();
            if (chunkZ != location.getBlockZ() >> 4 || chunkX != location.getBlockX() >> 4) continue;
            mage.sendDebugMessage(ChatColor.RED + "Despawned", 4);
            if (toRemove == null) {
                toRemove = new ArrayList<Entity>();
            }
            toRemove.add(entity);
        }
        if (toRemove != null) {
            for (Entity entity : toRemove) {
                entity.remove();
            }
        }
    }
}

