/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.spell.builtin;

import com.elmakers.mine.bukkit.api.spell.SpellResult;
import com.elmakers.mine.bukkit.spell.TargetingSpell;
import com.elmakers.mine.bukkit.utility.Target;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Ocelot;

public class OcelotSpell
extends TargetingSpell {
    private static int DEFAULT_MAX_OCELOTS = 30;
    protected List<Ocelot> ocelots = new ArrayList<Ocelot>();

    @Nullable
    public Ocelot newOcelot(Target target) {
        Ocelot entity;
        Block targetBlock = target.getBlock();
        if (targetBlock == null) {
            return null;
        }
        targetBlock = targetBlock.getRelative(BlockFace.UP);
        if (target.hasEntity()) {
            targetBlock = targetBlock.getRelative(BlockFace.SOUTH);
        }
        if ((entity = (Ocelot)this.getWorld().spawnEntity(targetBlock.getLocation(), EntityType.OCELOT)) == null) {
            return null;
        }
        return entity;
    }

    @Override
    public SpellResult onCast(ConfigurationSection parameters) {
        Ocelot ocelot;
        Target target = this.getTarget();
        ArrayList<Ocelot> newocelots = new ArrayList<Ocelot>();
        for (Ocelot ocelot2 : this.ocelots) {
            if (ocelot2.isDead()) continue;
            newocelots.add(ocelot2);
        }
        this.ocelots = newocelots;
        int maxOcelots = parameters.getInt("max_ocelots", DEFAULT_MAX_OCELOTS);
        int scaledMaxOcelots = (int)(this.mage.getRadiusMultiplier() * (float)maxOcelots);
        if (this.ocelots.size() >= scaledMaxOcelots) {
            Ocelot killOcelot = this.ocelots.remove(0);
            killOcelot.setHealth(0.0);
        }
        if ((ocelot = this.newOcelot(target)) == null) {
            return SpellResult.FAIL;
        }
        this.ocelots.add(ocelot);
        Entity e = target.getEntity();
        if (e != null && e instanceof LivingEntity) {
            LivingEntity targetEntity = (LivingEntity)e;
            for (Ocelot w : this.ocelots) {
                w.setTarget(targetEntity);
            }
        }
        return SpellResult.CAST;
    }
}

