/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.requirements;

import org.bukkit.configuration.ConfigurationSection;

class RangedRequirement {
    public Double max;
    public Double min;
    public Double value;

    public RangedRequirement(ConfigurationSection configuration) {
        if (configuration.contains("min")) {
            this.min = configuration.getDouble("min");
        }
        if (configuration.contains("max")) {
            this.max = configuration.getDouble("max");
        }
        if (configuration.contains("value")) {
            this.value = configuration.getDouble("value");
        }
    }

    public boolean check(Double value) {
        if (!(this.value == null || value != null && value.equals(this.value))) {
            return false;
        }
        if (this.min != null && (value == null || value <= this.min)) {
            return false;
        }
        return this.max == null || value == null || !(value >= this.max);
    }

    public String toString() {
        return "[Require =" + this.value + " from (" + this.min + " to " + this.max + ")]";
    }
}

