/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CheckAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.api.spell.Spell;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.configuration.ConfigurationSection;

public class CheckBlockAction
extends CheckAction {
    private MaterialSet allowed;
    private boolean useTarget;
    private BlockFace direction;
    private boolean setTarget;

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        super.initialize(spell, parameters);
        this.allowed = spell.getController().getMaterialSetManager().fromConfig(parameters.getString("allowed"));
    }

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.useTarget = parameters.getBoolean("use_target", true);
        this.setTarget = parameters.getBoolean("set_target", false);
        String directionString = parameters.getString("direction");
        if (directionString != null && !directionString.isEmpty()) {
            try {
                this.direction = BlockFace.valueOf((String)directionString.toUpperCase());
            }
            catch (Exception ex) {
                context.getLogger().warning("Invalid BlockFace direction: " + directionString);
            }
        }
    }

    @Override
    protected boolean isAllowed(CastContext context) {
        Block block;
        MaterialBrush brush = context.getBrush();
        Block block2 = block = this.useTarget ? context.getTargetBlock() : context.getLocation().getBlock();
        if (block == null) {
            return false;
        }
        if (this.direction != null) {
            block = block.getRelative(this.direction);
        }
        if (this.allowed != null) {
            if (!this.allowed.testBlock(block)) {
                return false;
            }
        } else {
            if (brush != null && brush.isErase() ? !context.hasBreakPermission(block) : !context.hasBuildPermission(block)) {
                return false;
            }
            if (!context.isDestructible(block)) {
                return false;
            }
        }
        if (this.setTarget) {
            this.createActionContext(context, context.getEntity(), null, context.getTargetEntity(), block.getLocation());
        }
        return true;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }
}

