/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.entity;

import com.elmakers.mine.bukkit.api.item.ItemData;
import com.elmakers.mine.bukkit.api.magic.Mage;
import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.magic.MageTrigger;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.entity.Creature;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;

public class EntityMageData {
    private static final String[] MAGE_PROPERTIES = new String[]{"protection", "weakness", "strength"};
    protected long tickInterval;
    protected long lifetime;
    @Nullable
    protected Multimap<String, MageTrigger> triggers;
    protected ConfigurationSection mageProperties;
    protected boolean requiresTarget;
    protected ItemData requiresWand;
    protected boolean aggro;
    protected double trackRadiusSquared;

    public EntityMageData(@Nonnull MageController controller, @Nonnull ConfigurationSection parameters) {
        Set triggerKeys;
        this.requiresWand = controller.getOrCreateItemOrWand(parameters.getString("cast_requires_item"));
        this.mageProperties = parameters.getConfigurationSection("mage");
        for (String mageProperty : MAGE_PROPERTIES) {
            ConfigurationSection mageConfig = parameters.getConfigurationSection(mageProperty);
            if (mageConfig == null) continue;
            if (this.mageProperties == null) {
                this.mageProperties = new MemoryConfiguration();
            }
            this.mageProperties.set(mageProperty, (Object)mageConfig);
        }
        this.lifetime = parameters.getInt("lifetime", 0);
        this.tickInterval = parameters.getLong("interval", parameters.getLong("cast_interval", 0L));
        this.requiresTarget = parameters.getBoolean("cast_requires_target", parameters.getBoolean("interval_requires_target", true));
        this.trackRadiusSquared = parameters.getDouble("track_radius", 128.0);
        this.trackRadiusSquared *= this.trackRadiusSquared;
        ConfigurationSection triggerConfig = parameters.getConfigurationSection("triggers");
        if (parameters.contains("cast")) {
            if (triggerConfig == null) {
                triggerConfig = new MemoryConfiguration();
            }
            ConfigurationSection castSection = triggerConfig.createSection("interval");
            castSection.set("cast", (Object)parameters.getConfigurationSection("cast"));
        }
        Set set = triggerKeys = triggerConfig == null ? null : triggerConfig.getKeys(false);
        if (triggerKeys != null) {
            this.triggers = ArrayListMultimap.create();
            for (String triggerKey : triggerKeys) {
                MageTrigger trigger = new MageTrigger(controller, triggerKey, triggerConfig.getConfigurationSection(triggerKey));
                this.triggers.put((Object)trigger.getType(), (Object)trigger);
            }
        }
        if (this.triggers != null && this.tickInterval <= 0L && this.triggers.containsKey((Object)MageTrigger.MageTriggerType.INTERVAL.name())) {
            this.tickInterval = 1000L;
        }
        if (this.tickInterval < this.lifetime / 2L) {
            this.tickInterval = this.lifetime / 2L;
        }
        this.aggro = parameters.getBoolean("aggro", !this.isEmpty());
    }

    public boolean isEmpty() {
        boolean hasTriggers = this.triggers != null;
        boolean hasProperties = this.mageProperties != null;
        boolean hasLifetime = this.lifetime > 0L;
        return !hasProperties && !hasTriggers && !this.aggro && !hasLifetime;
    }

    @Nullable
    private Collection<MageTrigger> getTriggers(MageTrigger.MageTriggerType type) {
        return this.getTriggers(type.name());
    }

    @Nullable
    private Collection<MageTrigger> getTriggers(String type) {
        return this.triggers == null ? null : this.triggers.get((Object)type);
    }

    public boolean trigger(Mage mage, String triggerKey) {
        Collection<MageTrigger> triggers = this.getTriggers(triggerKey);
        if (triggers == null || triggers.isEmpty()) {
            return false;
        }
        for (MageTrigger trigger : triggers) {
            trigger.execute(mage);
        }
        return true;
    }

    public void onDeath(Mage mage) {
        Collection<MageTrigger> deathTriggers = this.getTriggers(MageTrigger.MageTriggerType.DEATH);
        if (deathTriggers == null) {
            return;
        }
        for (MageTrigger trigger : deathTriggers) {
            trigger.execute(mage);
        }
    }

    public boolean onLaunch(Mage mage, double bowpull) {
        Collection<MageTrigger> launchTriggers = this.getTriggers(MageTrigger.MageTriggerType.LAUNCH);
        if (launchTriggers == null || launchTriggers.isEmpty()) {
            return false;
        }
        for (MageTrigger trigger : launchTriggers) {
            trigger.execute(mage, 0.0, bowpull);
        }
        return true;
    }

    public void onDamage(Mage mage, double damage) {
        Collection<MageTrigger> damageTriggers = this.getTriggers(MageTrigger.MageTriggerType.DAMAGE);
        if (damageTriggers == null) {
            return;
        }
        for (MageTrigger trigger : damageTriggers) {
            trigger.execute(mage, damage);
        }
    }

    public void onSpawn(Mage mage) {
        Collection<MageTrigger> spawnTriggers = this.getTriggers(MageTrigger.MageTriggerType.SPAWN);
        if (spawnTriggers != null) {
            for (MageTrigger trigger : spawnTriggers) {
                trigger.execute(mage);
            }
        }
    }

    public void tick(Mage mage) {
        LivingEntity li;
        ItemStack itemInHand;
        Creature creature;
        if (this.lifetime > 0L && System.currentTimeMillis() > mage.getCreatedTime() + this.lifetime) {
            this.onDeath(mage);
            mage.getEntity().remove();
            return;
        }
        Collection<MageTrigger> intervalTriggers = this.getTriggers(MageTrigger.MageTriggerType.INTERVAL);
        if (intervalTriggers == null) {
            return;
        }
        LivingEntity entity = mage.getLivingEntity();
        Creature creature2 = creature = entity instanceof Creature ? (Creature)entity : null;
        if (this.requiresTarget && (creature == null || creature.getTarget() == null)) {
            return;
        }
        if (this.requiresWand != null && entity instanceof LivingEntity && ((itemInHand = (li = entity).getEquipment().getItemInMainHand()) == null || itemInHand.getType() != this.requiresWand.getType())) {
            return;
        }
        for (MageTrigger trigger : intervalTriggers) {
            trigger.execute(mage);
        }
    }

    public double getTrackRadiusSquared() {
        return this.trackRadiusSquared;
    }
}

