/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.wand;

import com.elmakers.mine.bukkit.api.magic.MagicAPI;
import com.elmakers.mine.bukkit.utility.RunnableJob;
import com.elmakers.mine.bukkit.wand.LostWand;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.ArrayDeque;
import java.util.Deque;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

public class WandCleanupRunnable
extends RunnableJob {
    private final Deque<com.elmakers.mine.bukkit.api.wand.LostWand> lostWands = new ArrayDeque<com.elmakers.mine.bukkit.api.wand.LostWand>();
    private final World world;
    private final MagicAPI api;
    private final String owner;
    private final boolean removeAll;
    private final boolean check;

    public WandCleanupRunnable(MagicAPI api, World world, String owner, boolean check) {
        super(api.getLogger());
        this.world = world;
        this.api = api;
        this.lostWands.addAll(api.getLostWands());
        this.removeAll = owner != null && owner.equals("ALL");
        this.check = check;
        this.owner = owner == null ? "" : owner;
    }

    public WandCleanupRunnable(MagicAPI api, World world) {
        super(api.getLogger());
        this.world = world;
        this.api = api;
        this.removeAll = true;
        this.check = false;
        this.owner = "";
        this.lostWands.addAll(api.getLostWands());
    }

    @Override
    public void finish() {
        super.finish();
        this.lostWands.clear();
    }

    public void run() {
        Entity[] entities;
        Chunk chunk;
        if (this.lostWands.isEmpty()) {
            this.finish();
            return;
        }
        com.elmakers.mine.bukkit.api.wand.LostWand lostWand = this.lostWands.getFirst();
        Location location = lostWand.getLocation();
        if (this.world != null && !location.getWorld().getName().equals(this.world.getName())) {
            this.lostWands.removeFirst();
            return;
        }
        String lostWandOwner = lostWand.getOwner();
        String string = lostWandOwner = lostWandOwner == null ? "" : lostWandOwner;
        if (!this.removeAll) {
            if (this.owner.length() == 0 && lostWandOwner.length() > 0) {
                this.lostWands.removeFirst();
                return;
            }
            if (this.owner.length() > 0 && !lostWandOwner.equals(this.owner)) {
                this.lostWands.removeFirst();
                return;
            }
        }
        if (!(chunk = location.getChunk()).isLoaded()) {
            chunk.load();
            return;
        }
        for (Entity entity : entities = chunk.getEntities()) {
            String lostId;
            Item item;
            ItemStack itemStack;
            if (!(entity instanceof Item) || !this.api.isWand(itemStack = (item = (Item)entity).getItemStack()) || (lostId = Wand.getWandId(itemStack)) == null || !lostWand.getId().equals(lostId)) continue;
            String description = this.check ? "Found" : "Removed";
            this.logger.info(description + " lost wand " + lostWand.getName() + " (" + lostWand.getOwner() + "), id " + lostWand.getId() + " in " + location.getWorld().getName() + " at " + location.getBlockX() + " " + location.getBlockY() + " " + location.getBlockZ());
            if (this.check) {
                if (lostWand instanceof LostWand) {
                    ((LostWand)lostWand).setLocation(entity.getLocation());
                }
            } else {
                this.api.removeLostWand(lostWand.getId());
                item.remove();
            }
            this.lostWands.removeFirst();
            return;
        }
        this.lostWands.removeFirst();
        this.api.removeLostWand(lostWand.getId());
        this.logger.info("Could not find wand " + lostWand.getName() + " (" + lostWand.getOwner() + "), id " + lostWand.getId() + ", removing from list");
    }
}

