/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.magic;

import com.elmakers.mine.bukkit.api.spell.SpellTemplate;
import com.elmakers.mine.bukkit.magic.BaseMagicConfigurable;
import com.elmakers.mine.bukkit.magic.Mage;
import com.elmakers.mine.bukkit.magic.MageClassTemplate;
import com.elmakers.mine.bukkit.magic.MageParameters;
import com.elmakers.mine.bukkit.magic.MageProperties;
import com.elmakers.mine.bukkit.magic.MagicPropertyType;
import com.elmakers.mine.bukkit.magic.TemplatedProperties;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.wand.Wand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.ChatColor;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class MageClass
extends TemplatedProperties
implements com.elmakers.mine.bukkit.api.magic.MageClass {
    @Nonnull
    protected MageClassTemplate template;
    protected final MageProperties mageProperties;
    protected final Mage mage;
    private MageClass parent;
    private Collection<EntityAttributeModifier> attributeModifiers;
    private boolean checkedAttributes = false;

    public MageClass(@Nonnull Mage mage, @Nonnull MageClassTemplate template) {
        super(template.hasParent() ? MagicPropertyType.SUBCLASS : MagicPropertyType.CLASS, mage.getController());
        this.mageProperties = mage.getProperties();
        this.mage = mage;
        this.setTemplate(template);
    }

    @Override
    protected void migrateProperty(String key, MagicPropertyType propertyType) {
        super.migrateProperty(key, propertyType, this.template);
    }

    @Override
    public boolean hasProperty(String key) {
        BaseMagicConfigurable storage = this.getStorage(key);
        if (storage != null) {
            return storage.hasOwnProperty(key);
        }
        return this.hasOwnProperty(key) || this.template.hasProperty(key);
    }

    @Override
    public boolean hasOwnProperty(String key) {
        return super.hasOwnProperty(key) || this.template.hasOwnProperty(key);
    }

    @Override
    @Nullable
    public ConfigurationSection getPropertyConfiguration(String key) {
        BaseMagicConfigurable storage = this.getStorage(key);
        if (storage != null && storage != this) {
            return storage.getPropertyConfiguration(key);
        }
        if (this.configuration.contains(key)) {
            return this.configuration;
        }
        return this.template.getConfiguration();
    }

    @Override
    @Nullable
    public Object getInheritedProperty(String key) {
        Object value = super.getProperty(key);
        if (value == null) {
            value = this.template.getProperty(key);
        }
        if (value == null && this.parent != null) {
            value = this.parent.getInheritedProperty(key);
        }
        return value;
    }

    @Override
    @Nonnull
    public MageClassTemplate getTemplate() {
        return this.template;
    }

    @Nullable
    public MageClass getParent() {
        return this.parent;
    }

    public MageClass getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    public void setParent(@Nonnull MageClass parent) {
        this.parent = parent;
    }

    @Override
    public void describe(CommandSender sender, @Nullable Set<String> ignoreProperties, @Nullable Set<String> overriddenProperties) {
        super.describe(sender, ignoreProperties, overriddenProperties);
        if (overriddenProperties == null) {
            overriddenProperties = new HashSet<String>();
        }
        Set ownKeys = this.getConfiguration().getKeys(false);
        overriddenProperties.addAll(ownKeys);
        sender.sendMessage("" + ChatColor.BOLD + ChatColor.GREEN + "Template Configuration for (" + ChatColor.DARK_GREEN + this.getKey() + ChatColor.GREEN + "):");
        HashSet<String> overriddenTemplateProperties = new HashSet<String>(overriddenProperties);
        for (String key : this.template.getConfiguration().getKeys(false)) {
            MagicPropertyType propertyRoute = (MagicPropertyType)((Object)this.propertyRoutes.get(key));
            if (propertyRoute == null || propertyRoute == this.type) {
                overriddenProperties.add(key);
                continue;
            }
            overriddenTemplateProperties.add(key);
        }
        this.template.describe(sender, ignoreProperties, overriddenTemplateProperties);
        MageClass parent = this.getParent();
        if (parent != null) {
            sender.sendMessage(ChatColor.AQUA + "Parent Class: " + ChatColor.GREEN + parent.getTemplate().getKey());
            parent.describe(sender, ignoreProperties, overriddenProperties);
        }
    }

    public ConfigurationSection getEffectiveConfiguration(boolean includeMage) {
        ConfigurationSection effectiveConfiguration = ConfigurationUtils.cloneConfiguration(this.getConfiguration());
        ConfigurationSection templateConfiguration = ConfigurationUtils.cloneConfiguration(this.template.getConfiguration());
        for (String key : templateConfiguration.getKeys(false)) {
            MagicPropertyType propertyRoute = (MagicPropertyType)((Object)this.propertyRoutes.get(key));
            if (propertyRoute == null || propertyRoute == this.type) continue;
            templateConfiguration.set(key, null);
        }
        ConfigurationUtils.overlayConfigurations(effectiveConfiguration, templateConfiguration);
        if (this.parent != null) {
            ConfigurationSection parentConfiguration = this.parent.getEffectiveConfiguration(includeMage);
            ConfigurationUtils.overlayConfigurations(effectiveConfiguration, parentConfiguration);
        } else if (includeMage) {
            ConfigurationSection mageConfiguration = this.mageProperties.getConfiguration();
            ConfigurationUtils.overlayConfigurations(effectiveConfiguration, mageConfiguration);
        }
        return effectiveConfiguration;
    }

    @Override
    @Nullable
    protected BaseMagicConfigurable getStorage(MagicPropertyType propertyType) {
        switch (propertyType) {
            case SUBCLASS: {
                return this;
            }
            case CLASS: {
                return this.getRoot();
            }
            case MAGE: {
                return this.mageProperties;
            }
        }
        return null;
    }

    @Override
    public boolean tickMana() {
        if (!this.hasOwnMana() && this.parent != null) {
            return this.parent.tickMana();
        }
        return super.tickMana();
    }

    @Override
    public Mage getMage() {
        return this.mage;
    }

    @Override
    public boolean isPlayer() {
        return this.mageProperties.isPlayer();
    }

    @Override
    @Nullable
    public Player getPlayer() {
        return this.mageProperties.getPlayer();
    }

    @Override
    public void loadProperties() {
        if (this.parent != null) {
            this.parent.loadProperties();
        }
        super.loadProperties();
        this.armorUpdated();
    }

    @Override
    public String getKey() {
        return this.template.getKey();
    }

    @Override
    public void armorUpdated() {
        if (this.hasOwnMana()) {
            this.updateMaxMana(this.mage);
        }
    }

    @Override
    public boolean updateMaxMana(Mage mage) {
        if (!this.hasOwnMana()) {
            boolean modified = false;
            if (this.parent != null) {
                modified = this.parent.updateMaxMana(mage);
                this.effectiveManaMax = this.parent.getEffectiveManaMax();
                this.effectiveManaRegeneration = this.parent.getEffectiveManaRegeneration();
            }
            return modified;
        }
        return super.updateMaxMana(mage);
    }

    @Override
    public void updated() {
        this.updateMaxMana(this.mage);
        Wand activeWand = this.mage.getActiveWand();
        if (activeWand != null) {
            activeWand.updated();
        }
        if (!this.isLocked()) {
            this.deactivateAttributes();
            this.activateAttributes();
        }
        this.mage.updatePassiveEffects();
    }

    @Override
    public String getName() {
        return this.template.getName();
    }

    public boolean isLocked() {
        if (super.getProperty("locked", false).booleanValue()) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.isLocked();
        }
        return false;
    }

    public void unlock() {
        this.configuration.set("locked", null);
        if (this.parent != null) {
            this.parent.unlock();
        }
        this.onUnlocked();
    }

    public void lock() {
        this.configuration.set("locked", (Object)true);
        this.onLocked();
    }

    @Override
    public float getCostReduction() {
        float costReduction = this.getFloat("cost_reduction");
        if (this.mage != null) {
            float reduction = this.mage.getCostReduction();
            return this.stackPassiveProperty(reduction, costReduction);
        }
        return costReduction;
    }

    @Override
    public float getCooldownReduction() {
        float cooldownReduction = this.getFloat("cooldown_reduction");
        if (this.mage != null) {
            float reduction = this.mage.getCooldownReduction();
            return this.stackPassiveProperty(reduction, cooldownReduction);
        }
        return cooldownReduction;
    }

    @Override
    public boolean isCooldownFree() {
        return this.getFloat("cooldown_reduction") > 1.0f;
    }

    @Override
    public float getConsumeReduction() {
        float consumeReduction = this.getFloat("consume_reduction");
        if (this.mage != null) {
            float reduction = this.mage.getConsumeReduction();
            return this.stackPassiveProperty(reduction, consumeReduction);
        }
        return consumeReduction;
    }

    @Override
    public float getCostScale() {
        return 1.0f;
    }

    @Override
    protected String getMessageKey(String key) {
        String mageKey = "classes." + this.template + "." + key;
        if (this.controller.getMessages().containsKey(mageKey)) {
            return mageKey;
        }
        return "mage." + key;
    }

    public void onRemoved() {
        this.onLocked();
    }

    public void onLocked() {
        List<String> classItems;
        Player player;
        this.deactivateAttributes();
        if (this.getBoolean("clean_on_lock", false) && (player = this.mage.getPlayer()) != null) {
            PlayerInventory inventory = player.getInventory();
            String key = this.getKey();
            for (int i = 0; i < inventory.getSize(); ++i) {
                String skillClass;
                ItemStack item = inventory.getItem(i);
                if (!this.controller.isSkill(item) || (skillClass = Wand.getSpellClass(item)) == null || !skillClass.equals(key)) continue;
                inventory.setItem(i, null);
            }
        }
        if ((classItems = this.getStringList("class_items")) != null) {
            for (String classItemKey : classItems) {
                ItemStack item = this.controller.createItem(classItemKey);
                if (item == null) continue;
                this.mage.removeItem(item);
            }
        }
    }

    public void onUnlocked() {
        this.activateAttributes();
        List<String> classItems = this.getStringList("class_items");
        if (classItems != null) {
            for (String classItemKey : classItems) {
                Wand wand;
                ItemStack item = this.controller.createItem(classItemKey);
                if (item == null) {
                    this.controller.getLogger().warning("Invalid class item in " + this.getKey() + ": " + classItemKey);
                    continue;
                }
                if (this.mage.hasItem(item)) continue;
                String wandKey = this.controller.getWandKey(item);
                if (wandKey != null && (wand = this.mage.getBoundWand(wandKey)) != null) {
                    this.mage.giveItem(wand.getItem());
                    continue;
                }
                this.mage.giveItem(item);
            }
        }
    }

    public void activateAttributes() {
        Collection<EntityAttributeModifier> modifiers;
        Player player;
        double healthScale = this.getDouble("health_scale");
        if (healthScale > 0.0 && (player = this.mage.getPlayer()) != null) {
            player.setHealthScale(healthScale);
        }
        if ((modifiers = this.getAttributeModifiers()) == null) {
            return;
        }
        LivingEntity entity = this.mage.getLivingEntity();
        if (entity == null) {
            return;
        }
        for (EntityAttributeModifier modifier : modifiers) {
            AttributeInstance attribute = entity.getAttribute(modifier.attribute);
            if (!this.checkedAttributes) {
                Collection existingModifiers = attribute.getModifiers();
                for (AttributeModifier existing : existingModifiers) {
                    if (!existing.getName().equalsIgnoreCase(modifier.modifier.getName())) continue;
                    this.mage.getController().getLogger().warning("Removed duplicate attribute modifier " + modifier.modifier.getName() + ", was this leftover from a server crash?");
                    attribute.removeModifier(existing);
                    break;
                }
            }
            attribute.addModifier(modifier.modifier);
        }
        this.checkedAttributes = true;
    }

    public void deactivateAttributes() {
        Player player;
        double healthScale = this.getDouble("health_scale");
        if (healthScale > 0.0 && (player = this.mage.getPlayer()) != null) {
            player.setHealthScaled(false);
        }
        if (this.attributeModifiers == null) {
            return;
        }
        LivingEntity entity = this.mage.getLivingEntity();
        if (entity == null) {
            return;
        }
        for (EntityAttributeModifier modifier : this.attributeModifiers) {
            AttributeInstance attribute = entity.getAttribute(modifier.attribute);
            attribute.removeModifier(modifier.modifier);
        }
        this.attributeModifiers = null;
    }

    @Nullable
    public Collection<EntityAttributeModifier> getAttributeModifiers() {
        if (this.attributeModifiers != null) {
            return this.attributeModifiers;
        }
        ConfigurationSection config = this.getConfigurationSection("entity_attributes");
        if (config == null) {
            return null;
        }
        Set keys = config.getKeys(false);
        if (keys.isEmpty()) {
            return null;
        }
        this.attributeModifiers = new ArrayList<EntityAttributeModifier>();
        for (String key : keys) {
            double value;
            String name = "mage_" + this.getKey() + "_" + key;
            String attributeKey = key;
            AttributeModifier.Operation operation = AttributeModifier.Operation.ADD_NUMBER;
            if (config.isConfigurationSection(key)) {
                ConfigurationSection modifierConfig = config.getConfigurationSection(key);
                name = modifierConfig.getString("name", name);
                attributeKey = modifierConfig.getString("attribute", attributeKey);
                value = modifierConfig.getDouble("value");
                String operationType = modifierConfig.getString("operation");
                if (operationType != null && !operationType.isEmpty()) {
                    try {
                        operation = AttributeModifier.Operation.valueOf((String)operationType.toUpperCase());
                    }
                    catch (Exception ex) {
                        this.controller.getLogger().warning("Invalid operation " + operationType + " on entity_attributes." + key + " in mage class " + this.getKey());
                    }
                }
            } else {
                value = config.getDouble(key);
            }
            Attribute attribute = null;
            try {
                attribute = Attribute.valueOf((String)attributeKey.toUpperCase());
            }
            catch (Exception ex) {
                this.controller.getLogger().warning("Invalid attribute " + attributeKey + " on entity_attributes." + key + " in mage class " + this.getKey());
            }
            if (attribute == null) continue;
            AttributeModifier modifier = new AttributeModifier(name, value, operation);
            this.attributeModifiers.add(new EntityAttributeModifier(attribute, modifier));
        }
        return this.attributeModifiers;
    }

    public void setTemplate(@Nonnull MageClassTemplate template) {
        this.template = template.getMageTemplate(this.getMage());
    }

    @Override
    public void load(@Nullable ConfigurationSection configuration) {
        this.configuration = new MageParameters(this.getMage(), "Mage class " + this.getKey());
        if (configuration != null) {
            ConfigurationUtils.addConfigurations(this.configuration, configuration);
        }
    }

    @Override
    @Deprecated
    @Nullable
    public SpellTemplate getBaseSpell(String spellKey) {
        return this.getSpellTemplate(spellKey);
    }

    private static class EntityAttributeModifier {
        public final AttributeModifier modifier;
        public final Attribute attribute;

        public EntityAttributeModifier(Attribute attribute, AttributeModifier modifier) {
            this.attribute = attribute;
            this.modifier = modifier;
        }
    }
}

