/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.citizens;

import com.elmakers.mine.bukkit.api.magic.MageController;
import com.elmakers.mine.bukkit.citizens.CommandCitizensTrait;
import com.elmakers.mine.bukkit.citizens.MagicCitizensTrait;
import com.elmakers.mine.bukkit.integration.NPCSupplier;
import javax.annotation.Nullable;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.TraitInfo;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class CitizensController
implements NPCSupplier {
    private Citizens citizensPlugin;

    public CitizensController(Plugin plugin, MageController controller, boolean enableTraits) {
        this.citizensPlugin = (Citizens)plugin;
        if (enableTraits) {
            CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(MagicCitizensTrait.class).withName("magic"));
            CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(CommandCitizensTrait.class).withName("command"));
        } else {
            controller.getLogger().info("Citizens traits disabled.");
        }
    }

    public Citizens getCitizensPlugin() {
        return this.citizensPlugin;
    }

    @Nullable
    private NPC getNPC(Entity entity) {
        if (entity == null) {
            return null;
        }
        return CitizensAPI.getNPCRegistry().getNPC(entity);
    }

    @Override
    public boolean isNPC(Entity entity) {
        return this.getNPC(entity) != null;
    }

    @Override
    public boolean isStaticNPC(Entity entity) {
        NPC npc = this.getNPC(entity);
        if (npc == null) {
            return false;
        }
        return (Boolean)npc.data().get("protected", (Object)true);
    }
}

