/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.BaseSpellAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.spell.SpellResult;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class FeedAction
extends BaseSpellAction {
    private static int MAX_FOOD_LEVEL = 20;
    private int feedAmount;
    private float saturationAmount;
    private boolean clearExhaustion;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        super.prepare(context, parameters);
        this.feedAmount = parameters.getInt("feed", 20);
        this.saturationAmount = parameters.getInt("saturation", 20);
        this.clearExhaustion = parameters.getBoolean("exhaustion", true);
    }

    @Override
    public SpellResult perform(CastContext context) {
        Entity targetEntity = context.getTargetEntity();
        if (!(targetEntity instanceof Player)) {
            return SpellResult.NO_TARGET;
        }
        Player player = (Player)targetEntity;
        if (this.feedAmount > 0 && player.getFoodLevel() >= MAX_FOOD_LEVEL) {
            return SpellResult.NO_TARGET;
        }
        if (this.feedAmount < 0 && player.getFoodLevel() == 0) {
            return SpellResult.NO_TARGET;
        }
        if (this.clearExhaustion) {
            player.setExhaustion(0.0f);
        }
        if (this.saturationAmount != 0.0f) {
            player.setSaturation(this.saturationAmount);
        }
        if (this.feedAmount != 0) {
            player.setFoodLevel(Math.min(MAX_FOOD_LEVEL, Math.max(0, player.getFoodLevel() + this.feedAmount)));
        }
        return SpellResult.CAST;
    }

    @Override
    public boolean requiresTargetEntity() {
        return true;
    }
}

