/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CheckAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.api.block.MaterialBrush;
import com.elmakers.mine.bukkit.api.magic.MaterialSet;
import com.elmakers.mine.bukkit.api.spell.Spell;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;

public class CheckBlockAction
extends CheckAction {
    private MaterialSet allowed;

    @Override
    public void initialize(Spell spell, ConfigurationSection parameters) {
        super.initialize(spell, parameters);
        this.allowed = spell.getController().getMaterialSetManager().fromConfig(parameters.getString("allowed"));
    }

    @Override
    protected boolean isAllowed(CastContext context) {
        MaterialBrush brush = context.getBrush();
        Block block = context.getTargetBlock();
        if (block == null) {
            return false;
        }
        if (this.allowed != null) {
            if (!this.allowed.testBlock(block)) {
                return false;
            }
        } else {
            if (brush != null && brush.isErase() ? !context.hasBreakPermission(block) : !context.hasBuildPermission(block)) {
                return false;
            }
            if (!context.isDestructible(block)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }
}

