/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.effect;

import com.elmakers.mine.bukkit.api.block.MaterialAndData;
import com.elmakers.mine.bukkit.api.effect.EffectContext;
import com.elmakers.mine.bukkit.api.effect.EffectPlay;
import com.elmakers.mine.bukkit.effect.EffectLibManager;
import com.elmakers.mine.bukkit.effect.EffectLibPlay;
import com.elmakers.mine.bukkit.effect.EffectUtils;
import com.elmakers.mine.bukkit.effect.SoundEffect;
import com.elmakers.mine.bukkit.effect.Visibility;
import com.elmakers.mine.bukkit.magic.SourceLocation;
import com.elmakers.mine.bukkit.slikey.effectlib.util.DynamicLocation;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Effect;
import org.bukkit.EntityEffect;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public abstract class EffectPlayer
implements com.elmakers.mine.bukkit.api.effect.EffectPlayer {
    private static final String EFFECT_BUILTIN_CLASSPATH = "com.elmakers.mine.bukkit.effect.builtin";
    public static int PARTICLE_RANGE = 32;
    private static Map<String, Class<?>> effectClasses = new HashMap();
    private static EffectLibManager effectLib = null;
    private ConfigurationSection effectLibConfig = null;
    private Collection<EffectPlay> currentEffects = null;
    public static boolean SOUNDS_ENABLED = true;
    protected Plugin plugin;
    private DynamicLocation origin;
    private DynamicLocation target;
    private Vector originOffset;
    private Vector targetOffset;
    private Vector originRelativeOffset;
    private Vector targetRelativeOffset;
    private Visibility visibility = Visibility.ALL;
    protected boolean playAtOrigin = true;
    protected boolean playAtTarget = false;
    protected boolean playAtAllTargets = false;
    protected Color color = null;
    protected com.elmakers.mine.bukkit.block.MaterialAndData material;
    protected int delayTicks = 0;
    protected com.elmakers.mine.bukkit.block.MaterialAndData material1;
    protected Color color1 = null;
    protected Color color2 = null;
    protected boolean useColor = true;
    protected EntityEffect entityEffect = null;
    protected Effect effect = null;
    protected Integer effectData = null;
    protected SoundEffect sound = null;
    protected boolean broadcastSound = true;
    protected boolean hasFirework = false;
    protected FireworkEffect.Type fireworkType;
    protected int fireworkPower = 1;
    protected Boolean fireworkFlicker;
    protected boolean fireworkSilent;
    protected FireworkEffect fireworkEffect;
    protected Particle particleType = null;
    protected Particle particleOverride = null;
    protected String useParticleOverride = null;
    protected String useColorOverride = null;
    protected float particleData = 0.0f;
    protected float particleXOffset = 0.3f;
    protected float particleYOffset = 0.3f;
    protected float particleZOffset = 0.3f;
    protected int particleCount = 1;
    protected float particleSize = 1.0f;
    protected boolean requireEntity = false;
    protected boolean requireTargetEntity = false;
    protected boolean sampleTarget = false;
    protected SourceLocation sourceLocation = null;
    protected SourceLocation targetLocation = null;
    protected float scale = 1.0f;
    protected ConfigurationSection parameterMap = null;

    public static boolean initialize(Plugin plugin) {
        effectLib = EffectLibManager.initialize(plugin);
        return effectLib != null;
    }

    public static void debugEffects(boolean debug) {
        if (effectLib != null) {
            effectLib.enableDebug(debug);
        }
    }

    public static void setParticleRange(int range) {
        PARTICLE_RANGE = range;
        if (effectLib != null) {
            effectLib.setParticleRange(range);
        }
    }

    public EffectPlayer() {
    }

    public EffectPlayer(Plugin plugin) {
        this.plugin = plugin;
    }

    private void warn(String warning) {
        if (this.plugin != null) {
            this.plugin.getLogger().warning(warning);
        }
    }

    public void load(Plugin plugin, ConfigurationSection configuration) {
        String visibilityType;
        String typeName;
        String effectName;
        this.plugin = plugin;
        if (effectLib != null && configuration.contains("effectlib")) {
            this.effectLibConfig = ConfigurationUtils.getConfigurationSection(configuration, "effectlib");
            if (this.effectLibConfig == null) {
                Object rawConfig = configuration.get("effectlib");
                this.warn("Could not load effectlib node of type " + rawConfig.getClass());
            }
        } else {
            this.effectLibConfig = null;
        }
        this.broadcastSound = configuration.getBoolean("sound_broadcast", true);
        this.useParticleOverride = configuration.getString("particle_override", null);
        this.useColorOverride = configuration.getString("color_override", null);
        this.originOffset = ConfigurationUtils.getVector(configuration, "origin_offset", ConfigurationUtils.getVector(configuration, "offset"));
        this.targetOffset = ConfigurationUtils.getVector(configuration, "target_offset");
        this.originRelativeOffset = ConfigurationUtils.getVector(configuration, "relative_offset");
        this.targetRelativeOffset = ConfigurationUtils.getVector(configuration, "relative_target_offset");
        this.delayTicks = configuration.getInt("delay", this.delayTicks) * 20 / 1000;
        this.material1 = ConfigurationUtils.getMaterialAndData(configuration, "material");
        if (configuration.isBoolean("color") && !configuration.getBoolean("color")) {
            this.useColor = false;
        } else {
            this.color1 = ConfigurationUtils.getColor(configuration, "color", null);
            this.color2 = ConfigurationUtils.getColor(configuration, "color2", null);
        }
        if (configuration.contains("effect")) {
            effectName = configuration.getString("effect");
            try {
                this.effect = Effect.valueOf((String)effectName.toUpperCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.effect == null) {
                this.warn("Unknown effect type " + effectName);
            } else {
                this.effectData = ConfigurationUtils.getInteger(configuration, "effect_data", this.effectData);
            }
        }
        if (configuration.contains("entity_effect")) {
            effectName = configuration.getString("entity_effect");
            try {
                this.entityEffect = EntityEffect.valueOf((String)effectName.toUpperCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.entityEffect == null) {
                this.warn("Unknown entity effect type " + effectName);
            }
        }
        if (configuration.contains("sound")) {
            this.sound = new SoundEffect(configuration.getString("sound"));
        } else if (configuration.contains("custom_sound")) {
            this.sound = new SoundEffect(configuration.getString("custom_sound"));
        }
        if (this.sound != null) {
            this.sound.setVolume((float)configuration.getDouble("sound_volume", (double)this.sound.getVolume()));
            this.sound.setPitch((float)configuration.getDouble("sound_pitch", (double)this.sound.getPitch()));
            this.sound.setRange(configuration.getInt("sound_range", this.sound.getRange()));
        }
        if (configuration.contains("firework") || configuration.contains("firework_power")) {
            this.hasFirework = true;
            this.fireworkType = null;
            if (configuration.contains("firework")) {
                typeName = configuration.getString("firework");
                try {
                    this.fireworkType = FireworkEffect.Type.valueOf((String)typeName.toUpperCase());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.fireworkType == null) {
                    this.warn("Unknown firework type " + typeName);
                }
            }
            this.fireworkPower = configuration.getInt("firework_power", this.fireworkPower);
            this.fireworkFlicker = ConfigurationUtils.getBoolean(configuration, "firework_flicker", this.fireworkFlicker);
            this.fireworkSilent = configuration.getBoolean("firework_silent", true);
        }
        if (configuration.contains("particle")) {
            typeName = configuration.getString("particle");
            try {
                this.particleType = Particle.valueOf((String)typeName.toUpperCase());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.particleType == null) {
                this.warn("Unknown particle type " + typeName);
            } else {
                this.particleData = (float)configuration.getDouble("particle_data", (double)this.particleData);
                this.particleData = (float)configuration.getDouble("particle_speed", (double)this.particleData);
                this.particleXOffset = (float)configuration.getDouble("particle_offset_x", (double)this.particleXOffset);
                this.particleYOffset = (float)configuration.getDouble("particle_offset_y", (double)this.particleYOffset);
                this.particleZOffset = (float)configuration.getDouble("particle_offset_z", (double)this.particleZOffset);
                this.particleCount = configuration.getInt("particle_count", this.particleCount);
                this.particleSize = (float)configuration.getDouble("particle_size", (double)this.particleSize);
            }
        }
        if ((visibilityType = configuration.getString("visibility")) != null) {
            try {
                this.visibility = Visibility.valueOf(visibilityType.toUpperCase());
            }
            catch (Exception ex) {
                this.warn("Invalid visibility type: " + visibilityType);
            }
        }
        this.setLocationType(configuration.getString("location", "origin"));
        this.requireEntity = configuration.getBoolean("requires_entity", false);
        this.requireTargetEntity = configuration.getBoolean("requires_entity_target", false);
        this.sourceLocation = new SourceLocation(configuration);
        this.targetLocation = new SourceLocation(configuration, "target_location", false);
        this.sampleTarget = configuration.getString("sample", "").equalsIgnoreCase("target");
    }

    public void setLocationType(String locationType) {
        if (locationType.equals("target")) {
            this.playAtOrigin = false;
            this.playAtTarget = true;
            this.playAtAllTargets = false;
        } else if (locationType.equals("origin")) {
            this.playAtTarget = false;
            this.playAtOrigin = true;
            this.playAtAllTargets = false;
        } else if (locationType.equals("both")) {
            this.playAtTarget = true;
            this.playAtOrigin = true;
            this.playAtAllTargets = false;
        } else if (locationType.equals("targets")) {
            this.playAtTarget = true;
            this.playAtOrigin = false;
            this.playAtAllTargets = true;
        }
    }

    public FireworkEffect getFireworkEffect(Color color1, Color color2, FireworkEffect.Type fireworkType) {
        return this.getFireworkEffect(color1, color2, fireworkType, null, null);
    }

    public FireworkEffect getFireworkEffect(Color color1, Color color2, FireworkEffect.Type fireworkType, Boolean flicker, Boolean trail) {
        Random rand = new Random();
        if (color1 == null) {
            color1 = Color.fromRGB((int)rand.nextInt(255), (int)rand.nextInt(255), (int)rand.nextInt(255));
        }
        if (color2 == null) {
            color2 = Color.fromRGB((int)rand.nextInt(255), (int)rand.nextInt(255), (int)rand.nextInt(255));
        }
        if (fireworkType == null) {
            fireworkType = FireworkEffect.Type.values()[rand.nextInt(FireworkEffect.Type.values().length)];
        }
        if (flicker == null) {
            flicker = rand.nextBoolean();
        }
        if (trail == null) {
            trail = rand.nextBoolean();
        }
        return FireworkEffect.builder().flicker(flicker.booleanValue()).withColor(color1).withFade(color2).with(fireworkType).trail(trail.booleanValue()).build();
    }

    @Override
    public void setEffect(Effect effect) {
        this.effect = effect;
    }

    public void setEntityEffect(EntityEffect entityEffect) {
        this.entityEffect = entityEffect;
    }

    public void setParticleType(Particle particleType) {
        this.particleType = particleType;
    }

    @Override
    public void setParticleOverride(String particleType) {
        if (particleType == null || particleType.isEmpty()) {
            this.particleOverride = null;
            return;
        }
        try {
            this.particleOverride = Particle.valueOf((String)particleType.toUpperCase());
        }
        catch (Exception ex) {
            this.warn("Error setting particle override: " + ex.getMessage());
            this.particleOverride = null;
        }
    }

    @Override
    public void setEffectData(int data) {
        this.effectData = data;
    }

    protected com.elmakers.mine.bukkit.block.MaterialAndData getWorkingMaterial() {
        Location target = this.getTarget();
        if (this.sampleTarget && target != null) {
            return new com.elmakers.mine.bukkit.block.MaterialAndData(target.getBlock().getType(), target.getBlock().getData());
        }
        if (this.material1 != null) {
            return this.material1;
        }
        com.elmakers.mine.bukkit.block.MaterialAndData result = this.material;
        Location origin = this.getOrigin();
        if (result == null && target != null) {
            result = new com.elmakers.mine.bukkit.block.MaterialAndData(target.getBlock().getType(), target.getBlock().getData());
        } else if (result == null && origin != null) {
            result = new com.elmakers.mine.bukkit.block.MaterialAndData(origin.getBlock().getType(), origin.getBlock().getData());
        } else if (result == null) {
            result = new com.elmakers.mine.bukkit.block.MaterialAndData(Material.AIR);
        }
        return result;
    }

    protected void playEffect() {
        this.playEffect(this.origin, this.target);
    }

    protected void playEffect(DynamicLocation origin, DynamicLocation target) {
        if (this.requireTargetEntity && (target == null || target.getEntity() == null)) {
            return;
        }
        if (this.playAtOrigin && origin != null) {
            this.performEffects(origin, target);
        }
        if (this.playAtTarget && target != null) {
            this.performEffects(target, origin);
        }
    }

    protected void performEffects(DynamicLocation source, DynamicLocation target) {
        Material material;
        Entity sourceEntity;
        Location sourceLocation;
        Location location = sourceLocation = source == null ? null : source.getLocation();
        if (sourceLocation == null) {
            return;
        }
        Entity entity = sourceEntity = source == null ? null : source.getEntity();
        if (this.requireEntity && sourceEntity == null) {
            return;
        }
        if (effectLib != null && this.effectLibConfig != null) {
            EffectLibPlay play = effectLib.play(this.effectLibConfig, this, source, target, this.parameterMap);
            if (this.currentEffects != null && play != null) {
                this.currentEffects.add(play);
            }
        }
        if (this.effect != null) {
            int data;
            int n = data = this.effectData == null ? 0 : this.effectData;
            if (this.effect == Effect.STEP_SOUND && this.effectData == null) {
                material = this.getWorkingMaterial().getMaterial();
                if (!material.isSolid()) {
                    return;
                }
                sourceLocation.getWorld().playEffect(sourceLocation, this.effect, (Object)material);
            } else {
                sourceLocation.getWorld().playEffect(sourceLocation, this.effect, data);
            }
        }
        if (this.entityEffect != null && sourceEntity != null) {
            sourceEntity.playEffect(this.entityEffect);
        }
        if (this.sound != null) {
            if (this.broadcastSound) {
                this.sound.play(this.plugin, sourceLocation);
            } else if (sourceEntity != null) {
                this.sound.play(this.plugin, sourceEntity);
            }
        }
        if (this.fireworkEffect != null) {
            EffectUtils.spawnFireworkEffect(this.plugin.getServer(), sourceLocation, this.fireworkEffect, this.fireworkPower, this.fireworkSilent);
        }
        if (this.particleType != null) {
            Particle useEffect = this.overrideParticle(this.particleType);
            material = this.getWorkingMaterial().getMaterial();
            Short data = this.getWorkingMaterial().getData();
            EffectPlayer.displayParticle(useEffect, sourceLocation, this.particleXOffset, this.particleYOffset, this.particleZOffset, this.particleData, this.particleCount, this.particleSize, this.getColor1(), material, data == null ? (byte)0 : (byte)data.shortValue(), PARTICLE_RANGE);
        }
    }

    public static void displayParticle(Particle particle, Location center, float offsetX, float offsetY, float offsetZ, float speed, int amount, float size, Color color, Material material, byte materialData, double range) {
        effectLib.displayParticle(particle, center, offsetX, offsetY, offsetZ, speed, amount, size, color, material, materialData, range);
    }

    public Particle overrideParticle(Particle particle) {
        return this.useParticleOverride != null && !this.useParticleOverride.isEmpty() && this.particleOverride != null ? this.particleOverride : particle;
    }

    public String getParticleOverrideName() {
        return this.useParticleOverride;
    }

    public String getColorOverrideName() {
        return this.useColorOverride;
    }

    public void setParticleData(float effectData) {
        this.particleData = effectData;
    }

    public void setParticleCount(int particleCount) {
        this.particleCount = particleCount;
    }

    public void setParticleOffset(float xOffset, float yOffset, float zOffset) {
        this.particleXOffset = xOffset;
        this.particleYOffset = yOffset;
        this.particleZOffset = zOffset;
    }

    @Override
    public void setScale(float scale) {
        this.scale = scale;
    }

    @Override
    public void setSound(Sound sound) {
        this.sound = new SoundEffect(sound);
    }

    @Override
    public void setSound(Sound sound, float volume, float pitch) {
        this.sound = new SoundEffect(sound);
        this.sound.setVolume(volume);
        this.sound.setPitch(pitch);
    }

    @Override
    public void setDelayTicks(int ticks) {
        this.delayTicks = ticks;
    }

    @Override
    public void start(Entity originEntity, Entity targetEntity) {
        this.startEffects(new DynamicLocation(originEntity), new DynamicLocation(targetEntity));
    }

    @Override
    public void start(Location origin, Entity originEntity, Location target, Entity targetEntity) {
        this.startEffects(new DynamicLocation(origin, originEntity), new DynamicLocation(target, targetEntity));
    }

    @Override
    public void start(Location origin, Entity originEntity, Location target, Entity targetEntity, Collection<Entity> targets) {
        if (this.playsAtAllTargets()) {
            this.start(origin, originEntity, targets);
        } else {
            this.start(origin, originEntity, target, targetEntity);
        }
    }

    public void start(Location origin, Entity originEntity, Collection<Entity> targets) {
        if (targets == null || targets.size() == 0) {
            return;
        }
        DynamicLocation source = new DynamicLocation(origin, originEntity);
        for (Entity targetEntity : targets) {
            if (targetEntity == null) continue;
            DynamicLocation target = new DynamicLocation(targetEntity);
            this.startEffects(source, target);
        }
    }

    @Override
    public void start(Location origin, Location target) {
        this.startEffects(new DynamicLocation(origin), new DynamicLocation(target));
    }

    @Override
    public void start(EffectContext context) {
        context.trackEffects(this);
        Location source = this.getSourceLocation(context);
        Location target = this.getSourceLocation(context);
        this.setColor(context.getEffectColor());
        this.setParticleOverride(context.getEffectParticle());
        this.start(source, context.getEntity(), target, context.getTargetEntity());
    }

    public void startEffects(DynamicLocation origin, DynamicLocation target) {
        Location originLocation;
        Location targetLocation = target == null ? null : target.getLocation();
        Location location = originLocation = origin == null ? null : origin.getLocation();
        if (targetLocation != null && originLocation != null && !originLocation.getWorld().equals(targetLocation.getWorld())) {
            targetLocation.setWorld(originLocation.getWorld());
        }
        this.origin = origin;
        this.target = target;
        if (this.originRelativeOffset != null && this.origin != null) {
            this.origin.addRelativeOffset(this.originRelativeOffset);
        }
        if (this.targetRelativeOffset != null && this.target != null) {
            this.target.addRelativeOffset(this.targetRelativeOffset);
        }
        this.fireworkEffect = this.hasFirework ? this.getFireworkEffect(this.getColor1(), this.getColor2(), this.fireworkType, this.fireworkFlicker, false) : null;
        if (this.delayTicks > 0 && this.plugin != null) {
            final EffectPlayer player = this;
            Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, new Runnable(){

                @Override
                public void run() {
                    player.startPlay();
                }
            }, (long)this.delayTicks);
        } else {
            this.startPlay();
        }
    }

    protected void checkLocations() {
        if (this.origin != null && this.originOffset != null) {
            this.origin.addOffset(this.originOffset);
        }
        if (this.target != null && this.targetOffset != null) {
            this.target.addOffset(this.targetOffset);
        }
    }

    protected void startPlay() {
        this.checkLocations();
        this.play();
    }

    protected Vector getDirection() {
        Location origin = this.getOrigin();
        Location target = this.getTarget();
        if (origin == null) {
            return new Vector(0, 1, 0);
        }
        Vector direction = target == null ? origin.getDirection() : target.toVector().subtract(origin.toVector());
        return direction.normalize();
    }

    @Override
    public void setMaterial(MaterialAndData material) {
        this.material = material == null ? null : new com.elmakers.mine.bukkit.block.MaterialAndData(material);
    }

    @Override
    public void setMaterial(Block block) {
        this.material = block == null ? null : new com.elmakers.mine.bukkit.block.MaterialAndData(block);
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Nullable
    public Color getColor1() {
        return this.useColor ? (this.color1 != null ? this.color1 : this.color) : null;
    }

    @Nullable
    public Color getColor2() {
        return this.useColor ? (this.color2 != null ? this.color2 : this.color) : null;
    }

    public abstract void play();

    @Nullable
    public Location getOrigin() {
        return this.origin == null ? null : this.origin.getLocation();
    }

    @Nullable
    public Location getTarget() {
        return this.target == null ? null : this.target.getLocation();
    }

    public void setOrigin(Location location) {
        if (this.origin == null) {
            this.origin = new DynamicLocation(location);
        } else {
            Location originLocation = this.origin.getLocation();
            originLocation.setX(location.getX());
            originLocation.setY(location.getY());
            originLocation.setZ(location.getZ());
        }
    }

    public void setTarget(Location location) {
        if (this.target == null) {
            this.target = new DynamicLocation(location);
        } else {
            Location targetLocation = this.target.getLocation();
            targetLocation.setX(location.getX());
            targetLocation.setY(location.getY());
            targetLocation.setZ(location.getZ());
        }
    }

    @Nullable
    public Entity getOriginEntity() {
        return this.origin == null ? null : this.origin.getEntity();
    }

    @Nullable
    public Entity getTargetEntity() {
        return this.target == null ? null : this.target.getEntity();
    }

    @Override
    public void cancel() {
        if (this.currentEffects != null) {
            for (EffectPlay effect : this.currentEffects) {
                effect.cancel();
            }
            this.currentEffects.clear();
        }
    }

    public static Collection<com.elmakers.mine.bukkit.api.effect.EffectPlayer> loadEffects(Plugin plugin, ConfigurationSection root, String key) {
        ArrayList<com.elmakers.mine.bukkit.api.effect.EffectPlayer> players = new ArrayList<com.elmakers.mine.bukkit.api.effect.EffectPlayer>();
        Collection<ConfigurationSection> effectNodes = ConfigurationUtils.getNodeList(root, key);
        if (effectNodes != null) {
            for (ConfigurationSection effectValues : effectNodes) {
                String effectClass = effectValues.getString("class", "EffectSingle");
                try {
                    Class<?> genericClass;
                    if (!effectClass.contains(".")) {
                        effectClass = "com.elmakers.mine.bukkit.effect.builtin." + effectClass;
                    }
                    if ((genericClass = effectClasses.get(effectClass)) == null) {
                        genericClass = Class.forName(effectClass);
                        effectClasses.put(effectClass, genericClass);
                    }
                    if (!EffectPlayer.class.isAssignableFrom(genericClass)) {
                        throw new Exception("Must extend EffectPlayer");
                    }
                    Class<?> playerClass = genericClass;
                    EffectPlayer player = (EffectPlayer)playerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    player.load(plugin, effectValues);
                    players.add(player);
                }
                catch (ClassNotFoundException unknown) {
                    if (plugin == null) continue;
                    plugin.getLogger().warning("Unknown effect class: " + effectClass);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (plugin == null) continue;
                    plugin.getLogger().warning("Error creating effect class: " + effectClass + " " + ex.getMessage());
                }
            }
        }
        return players;
    }

    @Override
    public void setEffectPlayList(Collection<EffectPlay> plays) {
        this.currentEffects = plays;
    }

    @Override
    @Nullable
    public Location getSourceLocation(@Nonnull EffectContext context) {
        return this.sourceLocation.getLocation(context);
    }

    @Override
    @Nullable
    public Location getTargetLocation(@Nonnull EffectContext context) {
        return this.targetLocation.getLocation(context);
    }

    @Override
    @Deprecated
    public void setParameterMap(Map<String, String> map) {
        this.parameterMap = ConfigurationUtils.toStringConfiguration(map);
    }

    @Override
    public void setParameterMap(ConfigurationSection map) {
        this.parameterMap = map;
    }

    @Override
    public boolean playsAtOrigin() {
        return this.playAtOrigin;
    }

    @Override
    public boolean playsAtTarget() {
        return this.playAtTarget;
    }

    @Override
    public boolean playsAtAllTargets() {
        return this.playAtAllTargets;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    @Deprecated
    public boolean shouldUseBlockLocation() {
        return this.targetLocation.shouldUseBlockLocation();
    }

    @Override
    @Deprecated
    public boolean shouldUseHitLocation() {
        return this.targetLocation.shouldUseHitLocation();
    }

    @Override
    @Deprecated
    public boolean shouldUseWandLocation() {
        return this.sourceLocation.shouldUseWandLocation();
    }

    @Override
    @Deprecated
    public boolean shouldUseCastLocation() {
        return this.sourceLocation.shouldUseCastLocation();
    }

    @Override
    @Deprecated
    public boolean shouldUseEyeLocation() {
        return this.sourceLocation.shouldUseEyeLocation();
    }
}

