/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.action.builtin;

import com.elmakers.mine.bukkit.action.CheckAction;
import com.elmakers.mine.bukkit.api.action.CastContext;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class CheckEntityAction
extends CheckAction {
    private boolean allowCaster;
    private boolean onlyCaster;
    private Set<EntityType> allowedTypes;
    private Set<EntityType> deniedTypes;

    @Override
    public void prepare(CastContext context, ConfigurationSection parameters) {
        EntityType entityType;
        List<String> keys;
        super.prepare(context, parameters);
        this.allowCaster = parameters.getBoolean("allow_caster", true);
        this.onlyCaster = parameters.getBoolean("only_caster", false);
        if (parameters.contains("allowed_entities")) {
            keys = ConfigurationUtils.getStringList(parameters, "allowed_entities");
            this.allowedTypes = new HashSet<EntityType>();
            for (String key : keys) {
                try {
                    entityType = EntityType.valueOf((String)key.toUpperCase());
                    this.allowedTypes.add(entityType);
                }
                catch (Exception ex) {
                    context.getLogger().warning("Invalid entity type in CheckEntity configuration: " + key);
                }
            }
        }
        if (parameters.contains("denied_entities")) {
            keys = ConfigurationUtils.getStringList(parameters, "denied_entities");
            this.deniedTypes = new HashSet<EntityType>();
            for (String key : keys) {
                try {
                    entityType = EntityType.valueOf((String)key.toUpperCase());
                    this.deniedTypes.add(entityType);
                }
                catch (Exception ex) {
                    context.getLogger().warning("Invalid entity type in CheckEntity configuration: " + key);
                }
            }
        }
    }

    @Override
    protected boolean isAllowed(CastContext context) {
        boolean isCaster;
        Entity targetEntity = context.getTargetEntity();
        if (targetEntity == null) {
            return false;
        }
        boolean bl = isCaster = targetEntity == context.getEntity();
        if (!this.allowCaster && isCaster) {
            return false;
        }
        if (this.onlyCaster && !isCaster) {
            return false;
        }
        if (this.allowedTypes != null && !this.allowedTypes.contains(targetEntity.getType())) {
            return false;
        }
        return this.deniedTypes == null || !this.deniedTypes.contains(targetEntity.getType());
    }

    @Override
    public boolean requiresTarget() {
        return true;
    }

    @Override
    public boolean requiresTargetEntity() {
        return true;
    }
}

