/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.maps;

import com.elmakers.mine.bukkit.block.DefaultMaterials;
import com.elmakers.mine.bukkit.maps.URLMap;
import com.elmakers.mine.bukkit.utility.CompatibilityUtils;
import com.elmakers.mine.bukkit.utility.InventoryUtils;
import com.elmakers.mine.bukkit.utility.NMSUtils;
import com.elmakers.mine.bukkit.utility.SkinUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.map.MapView;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class MapController
implements com.elmakers.mine.bukkit.api.maps.MapController {
    private final File configurationFile;
    private final File cacheFolder;
    private final Plugin plugin;
    private boolean animationAllowed = true;
    private boolean loaded = false;
    private boolean disabled = false;
    private BukkitTask saveTask = null;
    private HashMap<String, URLMap> keyMap = new HashMap();
    private HashMap<String, URLMap> playerMap = new HashMap();
    private HashMap<Integer, URLMap> idMap = new HashMap();

    public MapController(Plugin plugin, File configFile, File cache) {
        this.plugin = plugin;
        this.configurationFile = configFile;
        this.cacheFolder = cache;
    }

    @Override
    public List<com.elmakers.mine.bukkit.api.maps.URLMap> getAll() {
        return new ArrayList<com.elmakers.mine.bukkit.api.maps.URLMap>(this.idMap.values());
    }

    public void loadConfiguration() {
        if (this.configurationFile == null) {
            return;
        }
        YamlConfiguration configuration = new YamlConfiguration();
        if (this.configurationFile.exists()) {
            try {
                this.info("Loading image map data from " + this.configurationFile.getName());
                configuration.load(this.configurationFile);
                Set maps = configuration.getKeys(false);
                boolean needsUpdate = false;
                for (String mapIdString : maps) {
                    ConfigurationSection mapConfig = configuration.getConfigurationSection(mapIdString);
                    try {
                        Integer mapId = null;
                        URLMap map = null;
                        Integer priority = null;
                        if (mapConfig.contains("priority")) {
                            priority = mapConfig.getInt("priority");
                        }
                        Integer xOverlay = null;
                        if (mapConfig.contains("x_overlay")) {
                            xOverlay = mapConfig.getInt("x_overlay");
                        }
                        Integer yOverlay = null;
                        if (mapConfig.contains("y_overlay")) {
                            yOverlay = mapConfig.getInt("y_overlay");
                        }
                        String world = "world";
                        if (mapConfig.contains("world")) {
                            world = mapConfig.getString("world");
                        }
                        String playerName = null;
                        if (mapConfig.contains("player")) {
                            playerName = mapConfig.getString("player");
                        }
                        try {
                            mapId = Integer.parseInt(mapIdString);
                        }
                        catch (Exception ex) {
                            map = this.get(world, mapConfig.getString("url"), mapConfig.getString("name"), mapConfig.getInt("x"), mapConfig.getInt("y"), xOverlay, yOverlay, mapConfig.getInt("width"), mapConfig.getInt("height"), priority, playerName);
                            this.info("Created new map id " + map.id + " for config id " + mapIdString);
                            needsUpdate = true;
                        }
                        if (map == null && mapId != null) {
                            map = this.get(world, mapId, mapConfig.getString("url"), mapConfig.getString("name"), mapConfig.getInt("x"), mapConfig.getInt("y"), xOverlay, yOverlay, mapConfig.getInt("width"), mapConfig.getInt("height"), priority, playerName);
                        }
                        if (map == null) {
                            throw new Exception("Failed to load map id " + mapIdString);
                        }
                        if (!mapConfig.getBoolean("enabled")) {
                            map.disable();
                            continue;
                        }
                        map.getMapView();
                    }
                    catch (Exception ex) {
                        this.warning("Failed to load " + this.configurationFile.getAbsolutePath() + ": " + ex.getMessage() + ", saving will be disabled until this issues is resolved");
                        this.disabled = true;
                    }
                }
                if (needsUpdate) {
                    this.save();
                }
                this.info("Loaded " + this.keyMap.size() + " image maps");
            }
            catch (Exception ex) {
                this.warning("Failed to load " + this.configurationFile.getAbsolutePath() + ": " + ex.getMessage());
            }
        }
        this.loaded = true;
    }

    @Override
    public void save() {
        this.save(true);
    }

    public void save(boolean asynchronous) {
        if (!this.loaded) {
            if (this.plugin == null) {
                Bukkit.getLogger().warning("[Magic] Attempted to save image map data before initialization");
            } else {
                this.plugin.getLogger().warning("Attempted to save image map data before initialization");
            }
            return;
        }
        if (this.configurationFile == null || this.disabled) {
            return;
        }
        if (asynchronous && (this.saveTask != null || this.plugin == null)) {
            return;
        }
        SaveRunnable runnable = new SaveRunnable(this.idMap.values());
        if (asynchronous) {
            this.saveTask = Bukkit.getScheduler().runTaskAsynchronously(this.plugin, (Runnable)runnable);
        } else {
            runnable.run();
        }
    }

    protected void info(String message) {
        if (this.plugin != null) {
            this.plugin.getLogger().info(message);
        }
    }

    protected void warning(String message) {
        if (this.plugin != null) {
            this.plugin.getLogger().warning(message);
        }
    }

    public void resetAll() {
        for (URLMap map : this.keyMap.values()) {
            map.reset();
        }
    }

    public void clearCache() {
        String[] cacheFiles;
        for (String cacheFilename : cacheFiles = this.cacheFolder.list()) {
            if (!cacheFilename.endsWith(".png") && !cacheFilename.endsWith(".jpeg") && !cacheFilename.endsWith(".jpg") && !cacheFilename.endsWith(".gif")) continue;
            File cacheFile = new File(this.cacheFolder, cacheFilename);
            cacheFile.delete();
            if (this.plugin == null) continue;
            this.plugin.getLogger().info("Deleted file " + cacheFile.getAbsolutePath());
        }
        this.loadConfiguration();
    }

    @Override
    @Nullable
    public ItemStack getPlayerPortrait(String worldName, String playerName, Integer priority, String photoLabel) {
        photoLabel = photoLabel == null ? playerName : photoLabel;
        String url = SkinUtils.getOnlineSkinURL(playerName);
        if (url != null) {
            MapView mapView = this.getURL(worldName, url, photoLabel, 8, 8, 40, 8, 8, 8, priority, playerName);
            return this.getMapItem(photoLabel, mapView);
        }
        MapView mapView = this.getURL(worldName, null, photoLabel, 8, 8, 40, 8, 8, 8, priority, playerName);
        return this.getMapItem(photoLabel, mapView);
    }

    @Nullable
    public MapView getURL(String worldName, String url, String name, int x, int y, Integer xOverlay, Integer yOverlay, int width, int height, Integer priority) {
        URLMap map = this.get(worldName, url, name, x, y, xOverlay, yOverlay, width, height, priority);
        return map.getMapView();
    }

    @Nullable
    public MapView getURL(String worldName, String url, String name, int x, int y, Integer xOverlay, Integer yOverlay, int width, int height, Integer priority, String playerName) {
        URLMap map = this.get(worldName, url, name, x, y, xOverlay, yOverlay, width, height, priority, playerName);
        return map.getMapView();
    }

    public ItemStack getMapItem(String name, int mapId) {
        ItemStack newMapItem = this.createMap(mapId);
        if (name != null) {
            ItemMeta meta = newMapItem.getItemMeta();
            meta.setDisplayName(name);
            newMapItem.setItemMeta(meta);
        }
        return newMapItem;
    }

    @Override
    public ItemStack getMapItem(int id) {
        String mapName;
        ItemStack newMapItem = this.createMap(id);
        URLMap loadedMap = this.idMap.get(id);
        if (loadedMap != null && (mapName = loadedMap.getName()) != null) {
            ItemMeta meta = newMapItem.getItemMeta();
            meta.setDisplayName(mapName);
            newMapItem.setItemMeta(meta);
        }
        return newMapItem;
    }

    protected ItemStack getMapItem(String name, MapView mapView) {
        short id = 0;
        if (mapView != null) {
            id = mapView.getId();
        }
        return this.getMapItem(name, id);
    }

    public ItemStack createMap(int mapId) {
        short durability = NMSUtils.isCurrentVersion() ? (short)0 : (short)mapId;
        ItemStack mapItem = new ItemStack(DefaultMaterials.getFilledMap(), 1, durability);
        if (NMSUtils.isCurrentVersion()) {
            mapItem = CompatibilityUtils.makeReal(mapItem);
            InventoryUtils.setMetaInt(mapItem, "map", mapId);
        }
        return mapItem;
    }

    @Override
    public ItemStack getURLItem(String world, String url, String name, int x, int y, int width, int height, Integer priority) {
        MapView mapView = this.getURL(world, url, name, x, y, null, null, width, height, priority);
        return this.getMapItem(name, mapView);
    }

    @Override
    public int getURLMapId(String world, String url, String name, int x, int y, int width, int height, Integer priority) {
        MapView mapView = this.getURL(world, url, name, x, y, null, null, width, height, priority);
        return mapView == null ? (short)0 : mapView.getId();
    }

    @Override
    public int getURLMapId(String world, String url) {
        return this.getURLMapId(world, url, null, 0, 0, 0, 0, null);
    }

    @Override
    public void forceReloadPlayerPortrait(String worldName, String playerName) {
        this.forceReload(worldName, "http://s3.amazonaws.com/MinecraftSkins/" + playerName + ".png", 8, 8, 8, 8);
    }

    public void forceReload(String worldName, String url, int x, int y, int width, int height) {
        this.get(worldName, url, x, y, width, height).reload();
    }

    public void resend(String playerName) {
        for (URLMap map : this.keyMap.values()) {
            map.resendTo(playerName);
        }
    }

    @Override
    public void loadMap(String world, int id, String url, String name, int x, int y, int width, int height, Integer priority) {
        URLMap map = this.get(world, id, url, name, x, y, null, null, width, height, priority, null);
        map.getMapView();
    }

    @Override
    public boolean hasMap(int id) {
        return this.idMap.containsKey(id);
    }

    @Override
    public URLMap getMap(int id) {
        return this.idMap.get(id);
    }

    public URLMap get(String world, int mapId, String url, String name, int x, int y, Integer xOverlay, Integer yOverlay, int width, int height, Integer priority) {
        return this.get(world, mapId, url, name, x, y, xOverlay, yOverlay, width, height, priority, null);
    }

    public URLMap get(String world, int mapId, String url, String name, int x, int y, Integer xOverlay, Integer yOverlay, int width, int height, Integer priority, String playerName) {
        String key = URLMap.getKey(world, url, playerName, x, y, width, height);
        URLMap map = this.idMap.get(mapId);
        if (map != null) {
            if (!map.getKey().equals(key)) {
                this.warning("Two maps with the same id but different keys: " + mapId + ": " + key + ", " + map.getKey());
            }
            return map;
        }
        map = this.keyMap.get(key);
        if (map != null) {
            if (map.id != mapId) {
                this.warning("Two maps with the same key but different ids: " + key + ": " + mapId + ", " + map.id);
            }
            return map;
        }
        map = new URLMap(this, world, mapId, url, name, x, y, xOverlay, yOverlay, width, height, priority, playerName);
        this.keyMap.put(key, map);
        this.idMap.put(mapId, map);
        if (playerName != null) {
            this.playerMap.put(playerName, map);
        }
        return map;
    }

    @Nullable
    private URLMap get(String worldName, String url, int x, int y, int width, int height) {
        return this.get(worldName, url, x, y, width, height, null);
    }

    @Nullable
    private URLMap get(String worldName, String url, String name, int x, int y, Integer xOverlay, Integer yOverlay, int width, int height, Integer priority) {
        return this.get(worldName, url, name, x, y, xOverlay, yOverlay, width, height, priority, null);
    }

    @Nullable
    private URLMap get(String worldName, String url, String name, int x, int y, Integer xOverlay, Integer yOverlay, int width, int height, Integer priority, String playerName) {
        URLMap existing = null;
        if (url == null) {
            existing = this.playerMap.get(playerName);
        } else {
            String key = URLMap.getKey(worldName, url, playerName, x, y, width, height);
            existing = this.keyMap.get(key);
        }
        if (existing != null) {
            existing.priority = priority;
            existing.name = name;
            existing.xOverlay = xOverlay;
            existing.yOverlay = yOverlay;
            return existing;
        }
        World world = Bukkit.getWorld((String)worldName);
        MapView mapView = Bukkit.createMap((World)world);
        if (mapView == null) {
            if (url == null) {
                this.warning("Unable to create new map for player " + playerName);
            } else {
                this.warning("Unable to create new map for url " + url);
            }
            return null;
        }
        URLMap newMap = this.get(worldName, mapView.getId(), url, name, x, y, xOverlay, yOverlay, width, height, priority, playerName);
        this.save();
        return newMap;
    }

    @Nullable
    private URLMap get(String worldName, String url, int x, int y, int width, int height, Integer priority) {
        return this.get(worldName, url, null, x, y, null, null, width, height, priority);
    }

    protected Plugin getPlugin() {
        return this.plugin;
    }

    public File getCacheFolder() {
        return this.cacheFolder;
    }

    @Override
    public boolean remove(int id) {
        URLMap map = this.idMap.get(id);
        if (map != null) {
            map.enabled = false;
            this.keyMap.remove(map.getKey());
            String playerName = map.getPlayerName();
            if (playerName != null) {
                this.playerMap.remove(playerName);
            }
            this.idMap.remove(id);
            return true;
        }
        return false;
    }

    public boolean isAnimationAllowed() {
        return this.animationAllowed;
    }

    public void setAnimationAllowed(boolean allowed) {
        this.animationAllowed = allowed;
    }

    private class SaveRunnable
    implements Runnable {
        final List<URLMap> saveMaps;

        public SaveRunnable(Collection<URLMap> maps) {
            this.saveMaps = new ArrayList<URLMap>(maps);
        }

        @Override
        public void run() {
            try {
                YamlConfiguration configuration = new YamlConfiguration();
                for (URLMap map : this.saveMaps) {
                    ConfigurationSection mapConfig = configuration.createSection(Integer.toString(map.id));
                    mapConfig.set("world", (Object)map.world);
                    mapConfig.set("url", (Object)map.url);
                    mapConfig.set("x", (Object)map.x);
                    mapConfig.set("y", (Object)map.y);
                    mapConfig.set("width", (Object)map.width);
                    mapConfig.set("height", (Object)map.height);
                    mapConfig.set("enabled", (Object)map.isEnabled());
                    mapConfig.set("name", (Object)map.name);
                    mapConfig.set("player", (Object)map.playerName);
                    if (map.priority != null) {
                        mapConfig.set("priority", (Object)map.priority);
                    }
                    if (map.xOverlay != null) {
                        mapConfig.set("x_overlay", (Object)map.xOverlay);
                    }
                    if (map.yOverlay == null) continue;
                    mapConfig.set("y_overlay", (Object)map.yOverlay);
                }
                File tempFile = new File(MapController.this.configurationFile.getAbsolutePath() + ".tmp");
                configuration.save(tempFile);
                if (MapController.this.configurationFile.exists()) {
                    File backupFile = new File(MapController.this.configurationFile.getAbsolutePath() + ".bak");
                    if (!backupFile.exists() || MapController.this.configurationFile.length() >= backupFile.length()) {
                        if (backupFile.exists() && !backupFile.delete()) {
                            MapController.this.warning("Failed to delete backup file in order to replace it: " + backupFile.getAbsolutePath());
                        }
                        MapController.this.configurationFile.renameTo(backupFile);
                    } else {
                        MapController.this.warning("Backup file is larger than current map file, you may want to restore or delete it? " + backupFile.getAbsolutePath());
                        if (!MapController.this.configurationFile.delete()) {
                            MapController.this.warning("Failed to delete file in order to replace it: " + MapController.this.configurationFile.getAbsolutePath());
                        }
                    }
                }
                if (!tempFile.renameTo(MapController.this.configurationFile)) {
                    MapController.this.warning("Failed to rename file from " + tempFile.getAbsolutePath() + " to " + MapController.this.configurationFile.getAbsolutePath());
                }
            }
            catch (Exception ex) {
                MapController.this.warning("Failed to save file " + MapController.this.configurationFile.getAbsolutePath());
            }
            MapController.this.saveTask = null;
        }
    }
}

